/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;

public class BiomeSpecialEffectsBuilder
extends BiomeSpecialEffects.Builder {
    public static BiomeSpecialEffectsBuilder copyOf(BiomeSpecialEffects baseEffects) {
        BiomeSpecialEffectsBuilder builder = BiomeSpecialEffectsBuilder.create(baseEffects.getFogColor(), baseEffects.getWaterColor(), baseEffects.getWaterFogColor(), baseEffects.getSkyColor());
        builder.grassColorModifier = baseEffects.getGrassColorModifier();
        baseEffects.getFoliageColorOverride().ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder).foliageColorOverride(arg_0));
        baseEffects.getGrassColorOverride().ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder).grassColorOverride(arg_0));
        baseEffects.getAmbientParticleSettings().ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder).ambientParticle(arg_0));
        baseEffects.getAmbientLoopSoundEvent().ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder).ambientLoopSound(arg_0));
        baseEffects.getAmbientMoodSettings().ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder).ambientMoodSound(arg_0));
        baseEffects.getAmbientAdditionsSettings().ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder).ambientAdditionsSound(arg_0));
        baseEffects.getBackgroundMusic().ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder).backgroundMusic(arg_0));
        return builder;
    }

    public static BiomeSpecialEffectsBuilder create(int fogColor, int waterColor, int waterFogColor, int skyColor) {
        return new BiomeSpecialEffectsBuilder(fogColor, waterColor, waterFogColor, skyColor);
    }

    protected BiomeSpecialEffectsBuilder(int fogColor, int waterColor, int waterFogColor, int skyColor) {
        this.fogColor(fogColor);
        this.waterColor(waterColor);
        this.waterFogColor(waterFogColor);
        this.skyColor(skyColor);
    }

    public int getFogColor() {
        return this.fogColor.getAsInt();
    }

    public int waterColor() {
        return this.waterColor.getAsInt();
    }

    public int getWaterFogColor() {
        return this.waterFogColor.getAsInt();
    }

    public int getSkyColor() {
        return this.skyColor.getAsInt();
    }

    public BiomeSpecialEffects.GrassColorModifier getGrassColorModifier() {
        return this.grassColorModifier;
    }

    public Optional<Integer> getFoliageColorOverride() {
        return this.foliageColorOverride;
    }

    public Optional<Integer> getGrassColorOverride() {
        return this.grassColorOverride;
    }

    public Optional<AmbientParticleSettings> getAmbientParticle() {
        return this.ambientParticle;
    }

    public Optional<Holder<SoundEvent>> getAmbientLoopSound() {
        return this.ambientLoopSoundEvent;
    }

    public Optional<AmbientMoodSettings> getAmbientMoodSound() {
        return this.ambientMoodSettings;
    }

    public Optional<AmbientAdditionsSettings> getAmbientAdditionsSound() {
        return this.ambientAdditionsSettings;
    }

    public Optional<WeightedList<Music>> getBackgroundMusic() {
        return this.backgroundMusic;
    }
}

