/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraftforge.common.extensions.IForgeRawTagBuilder;

public class TagBuilder
implements IForgeRawTagBuilder {
    private final List<TagEntry> entries = new ArrayList<TagEntry>();
    private final List<TagEntry> removeEntries = new ArrayList<TagEntry>();
    private boolean replace = false;

    public static TagBuilder create() {
        return new TagBuilder();
    }

    public List<TagEntry> build() {
        return List.copyOf(this.entries);
    }

    public TagBuilder addElement(ResourceLocation p_215901_) {
        this.entries.add(TagEntry.element(p_215901_));
        return this;
    }

    public TagBuilder addOptionalElement(ResourceLocation p_215906_) {
        this.entries.add(TagEntry.optionalElement(p_215906_));
        return this;
    }

    public TagBuilder addTag(ResourceLocation p_215908_) {
        this.entries.add(TagEntry.tag(p_215908_));
        return this;
    }

    public TagBuilder addOptionalTag(ResourceLocation p_215910_) {
        this.entries.add(TagEntry.optionalTag(p_215910_));
        return this;
    }

    public Stream<TagEntry> getRemoveEntries() {
        return this.removeEntries.stream();
    }

    public TagBuilder remove(TagEntry entry) {
        this.removeEntries.add(entry);
        return this;
    }

    public TagBuilder replace(boolean value) {
        this.replace = value;
        return this;
    }

    public boolean isReplace() {
        return this.replace;
    }
}

