/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.loading;

import com.mojang.blaze3d.opengl.GlTexture;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.earlydisplay.DisplayWindow;
import net.minecraftforge.fml.loading.progress.ProgressMeter;

public class ForgeLoadingOverlay
extends LoadingOverlay {
    private static final boolean ENABLE = false;
    private final Minecraft minecraft;
    private final ReloadInstance reload;
    private final DisplayWindow displayWindow;
    private final ProgressMeter progress;
    private final RenderType earlyBuffer;

    public ForgeLoadingOverlay(Minecraft mc, ReloadInstance reloader, Consumer<Optional<Throwable>> errorConsumer, DisplayWindow displayWindow) {
        super(mc, reloader, errorConsumer, false);
        this.minecraft = mc;
        this.reload = reloader;
        this.displayWindow = displayWindow;
        AbstractTexture texture = mc.getTextureManager().getTexture(MOJANG_STUDIOS_LOGO_LOCATION);
        GlTexture glTexture = (GlTexture)texture.getTexture();
        displayWindow.addMojangTexture(glTexture.glId());
        this.progress = StartupMessageManager.prependProgressBar((String)"Minecraft Progress", (int)100);
        this.earlyBuffer = ForgeRenderTypes.getLoadingOverlay(displayWindow);
    }

    public static Supplier<LoadingOverlay> newInstance(Supplier<Minecraft> mc, Supplier<ReloadInstance> ri, Consumer<Optional<Throwable>> handler, DisplayWindow window) {
        return () -> new ForgeLoadingOverlay((Minecraft)mc.get(), (ReloadInstance)ri.get(), handler, window);
    }

    protected boolean renderContents(GuiGraphics gui, float fade) {
        return true;
    }
}

