/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public sealed interface PistonEvent
extends BlockEvent {
    @Override
    public BlockPos getPos();

    public Direction getDirection();

    default public BlockPos getFaceOffsetPos() {
        return this.getPos().relative(this.getDirection());
    }

    public PistonMoveType getPistonMoveType();

    default public @Nullable PistonStructureResolver getStructureHelper() {
        if (this.getLevel() instanceof Level) {
            return new PistonStructureResolver((Level)this.getLevel(), this.getPos(), this.getDirection(), this.getPistonMoveType().isExtend());
        }
        return null;
    }

    public static enum PistonMoveType {
        EXTEND{

            @Override
            public final boolean isExtend() {
                return true;
            }
        }
        ,
        RETRACT;


        public boolean isExtend() {
            return false;
        }
    }

    public record Post(LevelAccessor getLevel, BlockPos getPos, BlockState getState, Direction getDirection, PistonMoveType getPistonMoveType) implements RecordEvent,
    PistonEvent
    {
        public static final EventBus<Post> BUS = EventBus.create(Post.class);

        public Post(Level world, BlockPos pos, Direction direction, PistonMoveType moveType) {
            this((LevelAccessor)world, pos, world.getBlockState(pos), direction, moveType);
        }
    }

    public record Pre(LevelAccessor getLevel, BlockPos getPos, BlockState getState, Direction getDirection, PistonMoveType getPistonMoveType) implements Cancellable,
    PistonEvent,
    RecordEvent
    {
        public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

        public Pre(Level world, BlockPos pos, Direction direction, PistonMoveType moveType) {
            this((LevelAccessor)world, pos, world.getBlockState(pos), direction, moveType);
        }
    }
}

