/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.BandwidthLimitedCause;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkAvailability;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeClusterConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeControllerConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeControllerKt;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 R2\u00020\u0001:\u0002QRB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ3\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u000f\u00a2\u0006\u0004\b+\u0010,J#\u0010-\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u000f\u00a2\u0006\u0004\b.\u0010/J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0014H\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010*\u001a\u00020\u000fH\u0002J+\u00107\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u00108\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u000f\u00a2\u0006\u0004\b9\u0010:J\u000e\u0010\u001f\u001a\u0002042\u0006\u0010;\u001a\u00020\fJ\u000e\u0010<\u001a\u0002042\u0006\u0010;\u001a\u00020\fJ\u0015\u0010=\u001a\u0002042\b\u0010>\u001a\u0004\u0018\u00010?\u00a2\u0006\u0002\u0010@J\u000e\u0010A\u001a\u0002042\u0006\u0010B\u001a\u00020?J\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010*\u001a\u00020\u000fJ\u000e\u0010D\u001a\u0002042\u0006\u0010*\u001a\u00020\u000fJ\u0010\u0010E\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0010\u0010F\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0010\u0010G\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u001f\u0010H\u001a\u00020(2\u0006\u0010*\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\bI\u0010JJ\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010*\u001a\u00020\u000fJ,\u0010L\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010M\u001a\u00020\u000f2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00160O2\u0006\u0010P\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0018\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u001b\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u001c\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\"\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010#\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeController;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "config", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeControllerConfig;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeControllerConfig;)V", "logger", "networkAvailable", "", "repeatedInitialProbingEnabled", "lastAllowedRepeatedInitialProbe", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "bandwidthLimitedCause", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthLimitedCause;", "state", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeController$State;", "minBitrateToProbeFurther", "Lorg/jitsi/nlj/util/Bandwidth;", "J", "timeLastProbingInitiated", "estimatedBitrate", "startBitrate", "maxBitrate", "lastBweDropProbingTime", "alrStartTime", "alrEndTime", "enablePeriodicAlrProbing", "timeOfLastLargeDrop", "bitrateBeforeLastLargeDrop", "maxTotalAllocatedBitrate", "inRapidRecoveryExperiment", "nextProbeClusterId", "", "setBitrates", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeClusterConfig;", "minBitrate", "atTime", "setBitrates-JpFWP7k", "(JJJLjava/time/Instant;)Ljava/util/List;", "onMaxTotalAllocatedBitrate", "onMaxTotalAllocatedBitrate-SimD6oM", "(JLjava/time/Instant;)Ljava/util/List;", "onNetworkAvailability", "msg", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkAvailability;", "updateState", "", "newState", "initiateExponentialProbing", "setEstimatedBitrate", "bitrate", "setEstimatedBitrate-ZbyzzGk", "(JLorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthLimitedCause;Ljava/time/Instant;)Ljava/util/List;", "enable", "enableRepeatedInitialProbing", "setAlrStartTimeMs", "alrStartTimeMs", "", "(Ljava/lang/Long;)V", "setAlrEndedTimeMs", "alrEndTimeMs", "requestProbe", "reset", "timeForAlrProbe", "timeForNetworkStateProbe", "timeForNextRepeatedInitialProbe", "createProbeClusterConfig", "createProbeClusterConfig-ERFH51c", "(Ljava/time/Instant;J)Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeClusterConfig;", "process", "initiateProbing", "now", "bitratesToProbe", "", "probeFurtherIn", "State", "Companion", "jitsi-media-transform"})
public final class ProbeController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final ProbeControllerConfig config;
    @NotNull
    private final Logger logger;
    private boolean networkAvailable;
    private boolean repeatedInitialProbingEnabled;
    private Instant lastAllowedRepeatedInitialProbe;
    @NotNull
    private BandwidthLimitedCause bandwidthLimitedCause;
    @NotNull
    private State state;
    private long minBitrateToProbeFurther;
    private Instant timeLastProbingInitiated;
    private long estimatedBitrate;
    private long startBitrate;
    private long maxBitrate;
    private Instant lastBweDropProbingTime;
    @Nullable
    private Instant alrStartTime;
    @Nullable
    private Instant alrEndTime;
    private boolean enablePeriodicAlrProbing;
    private Instant timeOfLastLargeDrop;
    private long bitrateBeforeLastLargeDrop;
    private long maxTotalAllocatedBitrate;
    private final boolean inRapidRecoveryExperiment;
    private int nextProbeClusterId;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(ProbeController.class);

    public ProbeController(@NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext, @NotNull ProbeControllerConfig config) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.diagnosticContext = diagnosticContext;
        this.config = config;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.lastAllowedRepeatedInitialProbe = Instant.MIN;
        this.bandwidthLimitedCause = BandwidthLimitedCause.kDelayBasedLimited;
        this.state = State.kInit;
        this.minBitrateToProbeFurther = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.timeLastProbingInitiated = Instant.MIN;
        this.estimatedBitrate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.startBitrate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.maxBitrate = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.lastBweDropProbingTime = Instant.MIN;
        this.timeOfLastLargeDrop = Instant.MIN;
        this.bitrateBeforeLastLargeDrop = Bandwidth.Companion.getZERO-rlWvAKk();
        this.maxTotalAllocatedBitrate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.nextProbeClusterId = 1;
    }

    public /* synthetic */ ProbeController(Logger logger, DiagnosticContext diagnosticContext, ProbeControllerConfig probeControllerConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            probeControllerConfig = new ProbeControllerConfig(0.0, null, 0.0, 0.0, false, null, null, null, null, 0.0, null, 0.0, null, 0.0, null, null, false, null, null, 0.0, 0, null, null, 0.0, 0.0, 0.0, 0x3FFFFFF, null);
        }
        this(logger, diagnosticContext, probeControllerConfig);
    }

    @NotNull
    public final List<ProbeClusterConfig> setBitrates-JpFWP7k(long l, long l2, long l3, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        if (Bandwidth.compareTo-_2icLw0(l2, Bandwidth.Companion.getZERO-rlWvAKk()) > 0) {
            this.startBitrate = l2;
            this.estimatedBitrate = l2;
        } else if (Bandwidth.equals-impl0(this.startBitrate, Bandwidth.Companion.getZERO-rlWvAKk())) {
            this.startBitrate = l;
        }
        long oldMaxBitrate = this.maxBitrate;
        this.maxBitrate = Bandwidth.isFinite-impl(l3) ? l3 : ProbeControllerKt.access$getKDefaultMaxProbingBitrate$p();
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                if (!this.networkAvailable) break;
                return this.initiateExponentialProbing(atTime);
            }
            case 2: {
                break;
            }
            case 3: {
                if (Bandwidth.equals-impl0(this.estimatedBitrate, Bandwidth.Companion.getZERO-rlWvAKk()) || Bandwidth.compareTo-_2icLw0(oldMaxBitrate, this.maxBitrate) >= 0 || Bandwidth.compareTo-_2icLw0(this.estimatedBitrate, this.maxBitrate) >= 0) break;
                return this.initiateProbing(atTime, CollectionsKt.listOf((Object)Bandwidth.box-impl(l3)), false);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new ArrayList();
    }

    @NotNull
    public final List<ProbeClusterConfig> onMaxTotalAllocatedBitrate-SimD6oM(long l, @NotNull Instant atTime) {
        boolean inAlr;
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        boolean allowAllocationProbe = inAlr = this.alrStartTime != null;
        if (this.config.getProbeOnMaxAllocatedBitrateChange() && this.state == State.kProbingComplete && !Bandwidth.equals-impl0(l, this.maxTotalAllocatedBitrate) && Bandwidth.compareTo-_2icLw0(this.estimatedBitrate, this.maxBitrate) < 0 && Bandwidth.compareTo-_2icLw0(this.estimatedBitrate, l) < 0 && allowAllocationProbe) {
            boolean limitedByCurrentBwe;
            this.maxTotalAllocatedBitrate = l;
            if (this.config.getFirstAllocationProbeScale() == null) {
                return new ArrayList();
            }
            long firstProbeRate = Bandwidth.times-WElJv5I(l, this.config.getFirstAllocationProbeScale());
            long currentBweLimit = BandwidthKt.times-ERFH51c(this.config.getAllocationProbeLimitByCurrentScale(), this.estimatedBitrate);
            boolean bl = limitedByCurrentBwe = Bandwidth.compareTo-_2icLw0(currentBweLimit, firstProbeRate) < 0;
            if (limitedByCurrentBwe) {
                firstProbeRate = currentBweLimit;
            }
            Object[] objectArray = new Bandwidth[]{Bandwidth.box-impl(firstProbeRate)};
            List probes = CollectionsKt.mutableListOf((Object[])objectArray);
            if (!limitedByCurrentBwe && this.config.getSecondAllocationProbeScale() != null) {
                long secondProbeRate = Bandwidth.times-WElJv5I(l, this.config.getSecondAllocationProbeScale());
                boolean bl2 = limitedByCurrentBwe = Bandwidth.compareTo-_2icLw0(currentBweLimit, secondProbeRate) < 0;
                if (limitedByCurrentBwe) {
                    secondProbeRate = currentBweLimit;
                }
                if (Bandwidth.compareTo-_2icLw0(secondProbeRate, firstProbeRate) > 0) {
                    probes.add(Bandwidth.box-impl(secondProbeRate));
                }
            }
            boolean allowFurtherProbing = limitedByCurrentBwe;
            return this.initiateProbing(atTime, probes, allowFurtherProbing);
        }
        if (!Bandwidth.equals-impl0(l, Bandwidth.Companion.getZERO-rlWvAKk())) {
            this.lastAllowedRepeatedInitialProbe = atTime;
        }
        this.maxTotalAllocatedBitrate = l;
        return new ArrayList();
    }

    @NotNull
    public final List<ProbeClusterConfig> onNetworkAvailability(@NotNull NetworkAvailability msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.networkAvailable = msg.getNetworkAvailable();
        if (!this.networkAvailable && this.state == State.kWaitingForProbingResult) {
            this.state = State.kProbingComplete;
            this.minBitrateToProbeFurther = Bandwidth.Companion.getINFINITY-rlWvAKk();
        }
        if (this.networkAvailable && this.state == State.kInit && !Bandwidth.equals-impl0(this.startBitrate, Bandwidth.Companion.getZERO-rlWvAKk())) {
            return this.initiateExponentialProbing(msg.getAtTime());
        }
        return new ArrayList();
    }

    private final void updateState(State newState) {
        switch (WhenMappings.$EnumSwitchMapping$0[newState.ordinal()]) {
            case 1: {
                this.state = State.kInit;
                break;
            }
            case 2: {
                this.state = State.kWaitingForProbingResult;
                break;
            }
            case 3: {
                this.state = State.kProbingComplete;
                this.minBitrateToProbeFurther = Bandwidth.Companion.getINFINITY-rlWvAKk();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final List<ProbeClusterConfig> initiateExponentialProbing(Instant atTime) {
        boolean bl = this.networkAvailable;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl2 = bl = this.state == State.kInit;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = Bandwidth.compareTo-_2icLw0(this.startBitrate, Bandwidth.Companion.getZERO-rlWvAKk()) > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object[] objectArray = new Bandwidth[]{Bandwidth.box-impl(BandwidthKt.times-ERFH51c(this.config.getFirstExponentialProbeScale(), this.startBitrate))};
        List probes = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.config.getSecondExponentialProbeScale() != null && this.config.getSecondExponentialProbeScale() > 0.0) {
            probes.add(Bandwidth.box-impl(BandwidthKt.times-ERFH51c(this.config.getSecondExponentialProbeScale(), this.startBitrate)));
        }
        if (this.repeatedInitialProbingEnabled && Bandwidth.equals-impl0(this.maxTotalAllocatedBitrate, Bandwidth.Companion.getZERO-rlWvAKk())) {
            this.lastAllowedRepeatedInitialProbe = atTime.plus(this.config.getRepeatedInitialProbingTimePeriod());
            this.logger.info(() -> ProbeController.initiateExponentialProbing$lambda$0(this, atTime));
        }
        return this.initiateProbing(atTime, probes, true);
    }

    @NotNull
    public final List<ProbeClusterConfig> setEstimatedBitrate-ZbyzzGk(long l, @NotNull BandwidthLimitedCause bandwidthLimitedCause, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)bandwidthLimitedCause), (String)"bandwidthLimitedCause");
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        this.bandwidthLimitedCause = bandwidthLimitedCause;
        if (Bandwidth.compareTo-_2icLw0(l, BandwidthKt.times-ERFH51c(0.66, this.estimatedBitrate)) < 0) {
            this.timeOfLastLargeDrop = atTime;
            this.bitrateBeforeLastLargeDrop = this.estimatedBitrate;
        }
        this.estimatedBitrate = l;
        if (this.state == State.kWaitingForProbingResult) {
            if (this.config.getAbortFurtherProbeIfMaxLowerThanCurrent() && (Bandwidth.compareTo-_2icLw0(l, this.maxBitrate) > 0 || !Bandwidth.equals-impl0(this.maxTotalAllocatedBitrate, Bandwidth.Companion.getZERO-rlWvAKk()) && Bandwidth.compareTo-_2icLw0(l, BandwidthKt.times-ERFH51c(2, this.maxTotalAllocatedBitrate)) > 0)) {
                this.minBitrateToProbeFurther = Bandwidth.Companion.getINFINITY-rlWvAKk();
            }
            long networkStateEstimateProbeFurtherLimit = Bandwidth.Companion.getINFINITY-rlWvAKk();
            this.logger.info((Object)("Measured bitrate: " + Bandwidth.toString-impl(l) + " Minimum to probe further: " + Bandwidth.toString-impl(this.minBitrateToProbeFurther) + " upper limit: " + Bandwidth.toString-impl(networkStateEstimateProbeFurtherLimit)));
            if (Bandwidth.compareTo-_2icLw0(l, this.minBitrateToProbeFurther) > 0 && Bandwidth.compareTo-_2icLw0(l, networkStateEstimateProbeFurtherLimit) <= 0) {
                return this.initiateProbing(atTime, CollectionsKt.listOf((Object)Bandwidth.box-impl(BandwidthKt.times-ERFH51c(this.config.getFurtherExponentialProbeScale(), l))), true);
            }
        }
        return new ArrayList();
    }

    public final void enablePeriodicAlrProbing(boolean enable) {
        this.enablePeriodicAlrProbing = enable;
    }

    public final void enableRepeatedInitialProbing(boolean enable) {
        this.repeatedInitialProbingEnabled = enable;
    }

    public final void setAlrStartTimeMs(@Nullable Long alrStartTimeMs) {
        this.alrStartTime = alrStartTimeMs != null ? Instant.ofEpochMilli(alrStartTimeMs) : null;
    }

    public final void setAlrEndedTimeMs(long alrEndTimeMs) {
        this.alrEndTime = Instant.ofEpochMilli(alrEndTimeMs);
    }

    @NotNull
    public final List<ProbeClusterConfig> requestProbe(@NotNull Instant atTime) {
        boolean alrEndedRecently;
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        boolean inAlr = this.alrStartTime != null;
        boolean bl = alrEndedRecently = this.alrEndTime != null && Duration.between(this.alrEndTime, atTime).compareTo(ProbeControllerKt.access$getKAlrEndedTimeout$p()) < 0;
        if ((inAlr || alrEndedRecently || this.inRapidRecoveryExperiment) && this.state == State.kProbingComplete) {
            long suggestedProbe = BandwidthKt.times-ERFH51c(0.85, this.bitrateBeforeLastLargeDrop);
            long minExpectedProbeResult = BandwidthKt.times-ERFH51c(0.95, suggestedProbe);
            Duration timeSinceDrop = Duration.between(this.timeOfLastLargeDrop, atTime);
            Duration timeSinceProbe = Duration.between(this.lastBweDropProbingTime, atTime);
            if (Bandwidth.compareTo-_2icLw0(minExpectedProbeResult, this.estimatedBitrate) > 0 && timeSinceDrop.compareTo(ProbeControllerKt.access$getKBitrateDropTimeout$p()) < 0 && timeSinceProbe.compareTo(ProbeControllerKt.access$getKMinTimeBetweenAlrProbes$p()) > 0) {
                this.logger.info((Object)"Detected big bandwidth drop, start probing");
                this.lastBweDropProbingTime = atTime;
                return this.initiateProbing(atTime, CollectionsKt.listOf((Object)Bandwidth.box-impl(suggestedProbe)), false);
            }
        }
        return new ArrayList();
    }

    public final void reset(@NotNull Instant atTime) {
        Instant now;
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        this.bandwidthLimitedCause = BandwidthLimitedCause.kDelayBasedLimited;
        this.state = State.kInit;
        this.minBitrateToProbeFurther = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.timeLastProbingInitiated = Instant.MIN;
        this.estimatedBitrate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.startBitrate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.maxBitrate = ProbeControllerKt.access$getKDefaultMaxProbingBitrate$p();
        this.lastBweDropProbingTime = now = atTime;
        this.alrEndTime = null;
        this.timeOfLastLargeDrop = now;
        this.bitrateBeforeLastLargeDrop = Bandwidth.Companion.getZERO-rlWvAKk();
    }

    private final boolean timeForAlrProbe(Instant atTime) {
        if (this.enablePeriodicAlrProbing && this.alrStartTime != null) {
            Instant instant = this.alrStartTime;
            Intrinsics.checkNotNull((Object)instant);
            Instant instant2 = this.timeLastProbingInitiated;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"timeLastProbingInitiated");
            Instant nextProbeTime = InstantKt.max((Instant)instant, (Instant)instant2).plus(this.config.getAlrProbingInterval());
            return atTime.compareTo(nextProbeTime) >= 0;
        }
        return false;
    }

    private final boolean timeForNetworkStateProbe(Instant atTime) {
        return false;
    }

    private final boolean timeForNextRepeatedInitialProbe(Instant atTime) {
        Instant nextProbeTime;
        return this.state != State.kWaitingForProbingResult && this.lastAllowedRepeatedInitialProbe.compareTo(atTime) > 0 && atTime.compareTo(nextProbeTime = this.timeLastProbingInitiated.plus(ProbeControllerKt.access$getKMaxWaitingTimeForProbingResult$p())) >= 0;
    }

    private final ProbeClusterConfig createProbeClusterConfig-ERFH51c(Instant atTime, long l) {
        ProbeClusterConfig config = new ProbeClusterConfig(null, 0L, null, null, 0, 0, 63, null);
        config.setAtTime(atTime);
        config.setTargetDataRate-_2icLw0(l);
        if (atTime.compareTo(this.lastAllowedRepeatedInitialProbe) < 0) {
            config.setTargetDuration(this.config.getInitialProbeDuration());
            config.setMinProbeDelta(this.config.getInitialMinProbeDelta());
        } else {
            config.setTargetDuration(this.config.getMinProbeDuration());
            config.setMinProbeDelta(this.config.getMinProbeDelta());
        }
        config.setTargetProbeCount(this.config.getMinProbePacketsSent());
        config.setId(this.nextProbeClusterId);
        int n = this.nextProbeClusterId;
        this.nextProbeClusterId = n + 1;
        ProbeController.Companion.maybeLogProbeClusterCreated(this.diagnosticContext, config);
        return config;
    }

    @NotNull
    public final List<ProbeClusterConfig> process(@NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        if (Duration.between(this.timeLastProbingInitiated, atTime).compareTo(ProbeControllerKt.access$getKMaxWaitingTimeForProbingResult$p()) > 0 && this.state == State.kWaitingForProbingResult) {
            this.logger.info((Object)"kWaitingForProbingResult: timeout");
            this.updateState(State.kProbingComplete);
        }
        if (Bandwidth.equals-impl0(this.estimatedBitrate, Bandwidth.Companion.getZERO-rlWvAKk()) || this.state != State.kProbingComplete) {
            return new ArrayList();
        }
        if (this.timeForNextRepeatedInitialProbe(atTime)) {
            return this.initiateProbing(atTime, CollectionsKt.listOf((Object)Bandwidth.box-impl(Bandwidth.times-WElJv5I(this.estimatedBitrate, this.config.getFirstExponentialProbeScale()))), true);
        }
        if (this.timeForAlrProbe(atTime) || this.timeForNetworkStateProbe(atTime)) {
            return this.initiateProbing(atTime, CollectionsKt.listOf((Object)Bandwidth.box-impl(Bandwidth.times-WElJv5I(this.estimatedBitrate, this.config.getAlrProbeScale()))), true);
        }
        return new ArrayList();
    }

    private final List<ProbeClusterConfig> initiateProbing(Instant now, List<Bandwidth> bitratesToProbe, boolean probeFurtherIn) {
        boolean probeFurther = probeFurtherIn;
        if (this.config.getSkipIfEstimateLargerThanFractionOfMax() > 0.0) {
            long maxProbeRate;
            long networkEstimate = Bandwidth.Companion.getINFINITY-rlWvAKk();
            long l = maxProbeRate = Bandwidth.equals-impl0(this.maxTotalAllocatedBitrate, Bandwidth.Companion.getZERO-rlWvAKk()) ? this.maxBitrate : BandwidthKt.min-YUm52VA(BandwidthKt.times-ERFH51c(this.config.getSkipProbeMaxAllocatedScale(), this.maxTotalAllocatedBitrate), this.maxBitrate);
            if (Bandwidth.compareTo-_2icLw0(BandwidthKt.min-YUm52VA(networkEstimate, this.estimatedBitrate), BandwidthKt.times-ERFH51c(this.config.getSkipIfEstimateLargerThanFractionOfMax(), maxProbeRate)) > 0) {
                this.updateState(State.kProbingComplete);
                return new ArrayList();
            }
        }
        long maxProbeBitrate = this.maxBitrate;
        if (Bandwidth.compareTo-_2icLw0(this.maxTotalAllocatedBitrate, Bandwidth.Companion.getZERO-rlWvAKk()) > 0) {
            maxProbeBitrate = BandwidthKt.min-YUm52VA(maxProbeBitrate, Bandwidth.times-WElJv5I(this.maxTotalAllocatedBitrate, 2));
        }
        switch (WhenMappings.$EnumSwitchMapping$1[this.bandwidthLimitedCause.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.logger.info(() -> ProbeController.initiateProbing$lambda$0(this));
                return new ArrayList();
            }
            case 4: {
                maxProbeBitrate = BandwidthKt.min-YUm52VA(maxProbeBitrate, Bandwidth.times-WElJv5I(this.estimatedBitrate, this.config.getLossLimitedProbeScale()));
                break;
            }
            case 5: {
                break;
            }
        }
        List pendingProbes = new ArrayList();
        Iterator<Bandwidth> iterator = bitratesToProbe.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            long b = iterator.next().unbox-impl();
            boolean bl2 = bl = !Bandwidth.equals-impl0(b, Bandwidth.Companion.getZERO-rlWvAKk());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            long bitrate = b;
            if (Bandwidth.compareTo-_2icLw0(bitrate, maxProbeBitrate) >= 0) {
                bitrate = maxProbeBitrate;
                probeFurther = false;
            }
            pendingProbes.add(this.createProbeClusterConfig-ERFH51c(now, bitrate));
        }
        this.timeLastProbingInitiated = now;
        if (probeFurther) {
            this.updateState(State.kWaitingForProbingResult);
            this.minBitrateToProbeFurther = Bandwidth.times-WElJv5I(((ProbeClusterConfig)CollectionsKt.last((List)pendingProbes)).getTargetDataRate-rlWvAKk(), this.config.getFurtherProbeThreshold());
        } else {
            this.updateState(State.kProbingComplete);
        }
        return pendingProbes;
    }

    private static final String initiateExponentialProbing$lambda$0(ProbeController this$0, Instant $atTime) {
        return "Repeated initial probing enabled, last allowed probe: " + this$0.lastAllowedRepeatedInitialProbe + " now: " + $atTime;
    }

    private static final String initiateProbing$lambda$0(ProbeController this$0) {
        return "Not sending probe in bandwidth limited state. " + this$0.bandwidthLimitedCause;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeController$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "maybeLogProbeClusterCreated", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "probe", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeClusterConfig;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        private final void maybeLogProbeClusterCreated(DiagnosticContext diagnosticContext, ProbeClusterConfig probe) {
            DataSize minDataSize = BandwidthKt.times-SimD6oM(probe.getTargetDataRate-rlWvAKk(), probe.getTargetDuration());
            timeSeriesLogger.trace(() -> Companion.maybeLogProbeClusterCreated$lambda$0(diagnosticContext, probe, minDataSize));
        }

        private static final Map maybeLogProbeClusterCreated$lambda$0(DiagnosticContext $diagnosticContext, ProbeClusterConfig $probe, DataSize $minDataSize) {
            return (Map)$diagnosticContext.makeTimeSeriesPoint("ProbeClusterCreated").addField("probe_id", (Object)$probe.getId()).addField("probe_target_data_rate_bps", (Object)$probe.getTargetDataRate-rlWvAKk()).addField("probe_target_probe_count", (Object)$probe.getTargetProbeCount()).addField("probe_min_data_size", (Object)$minDataSize.getBytes());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeController$State;", "", "<init>", "(Ljava/lang/String;I)V", "kInit", "kWaitingForProbingResult", "kProbingComplete", "jitsi-media-transform"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State kInit = new State();
        public static final /* enum */ State kWaitingForProbingResult = new State();
        public static final /* enum */ State kProbingComplete = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.kInit, State.kWaitingForProbingResult, State.kProbingComplete};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.kInit.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.kWaitingForProbingResult.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.kProbingComplete.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BandwidthLimitedCause.values().length];
            try {
                nArray[BandwidthLimitedCause.kRttBasedBackOffHighRtt.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BandwidthLimitedCause.kDelayBasedLimitedDelayIncreased.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BandwidthLimitedCause.kLossLimitedBwe.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BandwidthLimitedCause.kLossLimitedBweIncreasing.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BandwidthLimitedCause.kDelayBasedLimited.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

