/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import org.ice4j.StunMessageEvent;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.IceControlAttribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.PriorityAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.Agent;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.security.CredentialsAuthority;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunStack;
import org.jitsi.utils.logging2.Logger;

class ConnectivityCheckServer
implements RequestListener,
CredentialsAuthority {
    private final Agent parentAgent;
    private boolean started = false;
    private final StunStack stunStack;
    private boolean alive = false;
    private Logger logger;

    public ConnectivityCheckServer(Agent parentAgent) {
        this.parentAgent = parentAgent;
        this.logger = parentAgent.getLogger().createChildLogger(this.getClass().getName());
        this.stunStack = this.parentAgent.getStunStack();
        this.stunStack.getCredentialsManager().registerAuthority(this);
        this.start();
    }

    boolean isAlive() {
        return this.alive;
    }

    @Override
    public void processRequest(StunMessageEvent evt) throws IllegalArgumentException {
        this.logger.trace(() -> "Received request " + String.valueOf(evt));
        this.alive = true;
        Request request = (Request)evt.getMessage();
        UsernameAttribute uname = (UsernameAttribute)request.getAttribute('\u0006');
        if (uname == null || !this.checkLocalUserName(new String(uname.getUsername()))) {
            return;
        }
        if ((this.parentAgent.isControlling() && request.containsAttribute('\u802a') || !this.parentAgent.isControlling() && request.containsAttribute('\u8029')) && !this.repairRoleConflict(evt)) {
            return;
        }
        long priority = 0L;
        boolean useCandidate = request.containsAttribute('%');
        String username = new String(uname.getUsername());
        String remoteUfrag = null;
        String localUFrag = null;
        priority = this.extractPriority(request);
        int colon = username.indexOf(":");
        remoteUfrag = username.substring(0, colon);
        boolean respond = this.parentAgent.incomingCheckReceived(evt.getRemoteAddress(), evt.getLocalAddress(), priority, remoteUfrag, localUFrag, useCandidate);
        Response response = respond ? MessageFactory.createBindingResponse(request, evt.getRemoteAddress()) : MessageFactory.createBindingErrorResponse('\u0193', "Cannot add new remote candidates in current ICE state");
        UsernameAttribute usernameAttribute = AttributeFactory.createUsernameAttribute(uname.getUsername());
        response.putAttribute(usernameAttribute);
        MessageIntegrityAttribute messageIntegrityAttribute = AttributeFactory.createMessageIntegrityAttribute(new String(uname.getUsername()));
        response.putAttribute(messageIntegrityAttribute);
        try {
            this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
        }
        catch (Exception e) {
            this.logger.info((Object)("Failed to send " + String.valueOf(response) + " through " + String.valueOf(evt.getLocalAddress()) + "\n" + e.toString()));
            throw new RuntimeException("Failed to send a response", e);
        }
    }

    private long extractPriority(Request request) throws IllegalArgumentException {
        PriorityAttribute priorityAttr = (PriorityAttribute)request.getAttribute('$');
        if (priorityAttr == null) {
            this.logger.debug(() -> "Received a connectivity check withno PRIORITY attribute. Discarding.");
            throw new IllegalArgumentException("Missing PRIORITY attribute!");
        }
        return priorityAttr.getPriority();
    }

    private boolean repairRoleConflict(StunMessageEvent evt) {
        IceControlAttribute theirIceControl;
        long theirTieBreaker;
        boolean bothControlledConflict;
        Message req = evt.getMessage();
        boolean selfIceControlling = this.parentAgent.isControlling();
        boolean bothControllingConflict = selfIceControlling && req.containsAttribute('\u802a');
        boolean bl = bothControlledConflict = !selfIceControlling && req.containsAttribute('\u8029');
        if (!bothControllingConflict && !bothControlledConflict) {
            return true;
        }
        long selfTieBreaker = this.parentAgent.getTieBreaker();
        if (Long.compareUnsigned(selfTieBreaker, theirTieBreaker = (theirIceControl = bothControllingConflict ? (IceControlAttribute)req.getAttribute('\u802a') : (IceControlAttribute)req.getAttribute('\u8029')).getTieBreaker()) >= 0) {
            UsernameAttribute requestUserName = (UsernameAttribute)req.getAttribute('\u0006');
            Response response = MessageFactory.createBindingErrorResponse('\u01e7');
            MessageIntegrityAttribute messageIntegrityAttribute = AttributeFactory.createMessageIntegrityAttribute(new String(requestUserName.getUsername()));
            response.putAttribute(messageIntegrityAttribute);
            try {
                this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
                return false;
            }
            catch (Exception exc) {
                throw new RuntimeException("Failed to send a 487", exc);
            }
        }
        String selfNextControlState = selfIceControlling ? "controlled" : "controlling";
        this.logger.trace(() -> "Switching to " + selfNextControlState + " because  theirTieBreaker= " + theirTieBreaker + " and selfTieBreaker= " + selfTieBreaker);
        this.parentAgent.setControlling(!selfIceControlling);
        return true;
    }

    @Override
    public boolean checkLocalUserName(String username) {
        String ufrag = null;
        int colon = username.indexOf(":");
        ufrag = colon < 0 ? username : username.substring(0, colon);
        return ufrag.equals(this.parentAgent.getLocalUfrag());
    }

    @Override
    public byte[] getLocalKey(String username) {
        return this.checkLocalUserName(username) ? this.parentAgent.getLocalPassword().getBytes() : null;
    }

    @Override
    public byte[] getRemoteKey(String username, String media) {
        IceMediaStream stream = this.parentAgent.getStream(media);
        if (stream == null) {
            return null;
        }
        int colon = username.indexOf(":");
        if (colon < 0 ? username.equals(stream.getRemoteUfrag()) : username.equals(this.parentAgent.generateLocalUserName(media)) && stream.getRemotePassword() != null) {
            return stream.getRemotePassword().getBytes();
        }
        return null;
    }

    public void start() {
        if (!this.started) {
            this.stunStack.addRequestListener(this);
            this.started = true;
        }
    }

    public void stop() {
        this.stunStack.removeRequestListener(this);
        this.started = false;
    }
}

