/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.format.Vp8PayloadType;
import org.jitsi.nlj.format.Vp9PayloadType;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.codec.VideoCodecParser;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DDParser;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Parser;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Parser;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014Ja\u0010\u001c\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001d\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u001e\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001e0!2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u001f0$H\u0082\bJ8\u0010%\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u001f0$H\u0082\b\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u000fH\u0002J\u0016\u0010.\u001a\u00020)2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020)00H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\u0006\u00105\u001a\u000206R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoParser;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "logger", "stats", "Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats;", "sources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "[Lorg/jitsi/nlj/MediaSourceDesc;", "signaledSources", "av1DDExtId", "", "Ljava/lang/Integer;", "videoCodecParsers", "", "", "Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "parseNormalPayload", "Lkotlin/Pair;", "Lorg/jitsi/nlj/rtp/ParsedVideoPacket;", "T", "otherTypeCreator", "Lkotlin/Function3;", "", "parserConstructor", "Lkotlin/Function1;", "checkParserType", "constructor", "(Lorg/jitsi/nlj/PacketInfo;Lkotlin/jvm/functions/Function1;)Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "resetSource", "source", "trace", "f", "Lkotlin/Function0;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "getStats", "Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats$Snapshot;", "Stats", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nVideoParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoParser.kt\norg/jitsi/nlj/transform/node/incoming/VideoParser\n+ 2 Packet.kt\norg/jitsi/rtp/Packet\n+ 3 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n160#1:282\n161#1,6:284\n190#1,10:290\n200#1,2:302\n203#1,3:305\n167#1:308\n206#1:309\n207#1,2:311\n210#1:314\n170#1,41:315\n160#1:356\n161#1,6:358\n190#1,10:364\n200#1,2:376\n203#1,3:379\n167#1:382\n206#1:383\n207#1,2:385\n210#1:388\n170#1,30:389\n200#1,2:421\n203#1,4:424\n207#1,2:429\n210#1:432\n183#1:433\n190#1,10:434\n200#1,2:446\n203#1,4:449\n207#1,2:454\n210#1:457\n190#1,10:473\n200#1,2:485\n203#1,4:488\n207#1,2:493\n210#1:496\n190#1,10:497\n200#1,2:509\n203#1,4:512\n207#1,2:517\n210#1:520\n29#2:283\n29#2:357\n29#2:472\n63#3,2:300\n66#3:304\n63#3,2:374\n66#3:378\n63#3,2:419\n66#3:423\n63#3,2:444\n66#3:448\n63#3,4:458\n63#3,4:464\n63#3,4:468\n63#3,2:483\n66#3:487\n63#3,2:507\n66#3:511\n63#3,4:521\n63#3,4:531\n13805#4:310\n13806#4:313\n13805#4:384\n13806#4:387\n13805#4:428\n13806#4:431\n13805#4:453\n13806#4:456\n13805#4,2:462\n13805#4:492\n13806#4:495\n13805#4:516\n13806#4:519\n13805#4,2:525\n13805#4:527\n13805#4,2:528\n13806#4:530\n1#5:535\n*S KotlinDebug\n*F\n+ 1 VideoParser.kt\norg/jitsi/nlj/transform/node/incoming/VideoParser\n*L\n81#1:282\n81#1:284,6\n81#1:290,10\n81#1:302,2\n81#1:305,3\n81#1:308\n81#1:309\n81#1:311,2\n81#1:314\n81#1:315,41\n88#1:356\n88#1:358,6\n88#1:364,10\n88#1:376,2\n88#1:379,3\n88#1:382\n88#1:383\n88#1:385,2\n88#1:388\n88#1:389,30\n88#1:421,2\n88#1:424,4\n88#1:429,2\n88#1:432\n88#1:433\n95#1:434,10\n95#1:446,2\n95#1:449,4\n95#1:454,2\n95#1:457\n166#1:473,10\n166#1:485,2\n166#1:488,4\n166#1:493,2\n166#1:496\n181#1:497,10\n181#1:509,2\n181#1:512,4\n181#1:517,2\n181#1:520\n81#1:283\n88#1:357\n160#1:472\n81#1:300,2\n81#1:304\n88#1:374,2\n88#1:378\n88#1:419,2\n88#1:423\n95#1:444,2\n95#1:448\n109#1:458,4\n139#1:464,4\n143#1:468,4\n166#1:483,2\n166#1:487\n181#1:507,2\n181#1:511\n199#1:521,4\n237#1:531,4\n81#1:310\n81#1:313\n88#1:384\n88#1:387\n88#1:428\n88#1:431\n95#1:453\n95#1:456\n115#1:462,2\n166#1:492\n166#1:495\n181#1:516\n181#1:519\n206#1:525,2\n219#1:527\n220#1:528,2\n219#1:530\n*E\n"})
public final class VideoParser
extends TransformerNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Stats stats;
    @NotNull
    private MediaSourceDesc[] sources;
    @NotNull
    private MediaSourceDesc[] signaledSources;
    @Nullable
    private Integer av1DDExtId;
    @NotNull
    private final Map<Long, VideoCodecParser> videoCodecParsers;

    public VideoParser(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter((Object)streamInformationStore, (String)"streamInformationStore");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        super("Video parser");
        this.streamInformationStore = streamInformationStore;
        this.diagnosticContext = diagnosticContext;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.stats = new Stats();
        this.sources = new MediaSourceDesc[0];
        this.signaledSources = this.sources;
        this.videoCodecParsers = new LinkedHashMap();
        this.streamInformationStore.onRtpExtensionMapping(RtpExtensionType.AV1_DEPENDENCY_DESCRIPTOR, (Function1<? super Integer, Unit>)((Function1)arg_0 -> VideoParser._init_$lambda$0(this, arg_0)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        packet = (RtpPacket)packetInfo.packetAs();
        av1DDExtId = this.av1DDExtId;
        v0 = this.streamInformationStore.getRtpPayloadTypes().get((byte)packet.getPayloadType());
        if (v0 == null) {
            $this$transform_u24lambda_u240 = this;
            $i$a$-run-VideoParser$transform$payloadType$1 = false;
            $this$transform_u24lambda_u240.logger.error((Object)("Unrecognized video payload type " + packet.getPayloadType() + ", cannot parse video information"));
            var9_14 = $this$transform_u24lambda_u240.stats;
            var10_20 = var9_14.getNumPacketsDroppedUnknownPt();
            var9_14.setNumPacketsDroppedUnknownPt(var10_20 + 1);
            return null;
        }
        payloadType = v0;
        videoCodecParser = null;
        try {
            block57: {
                block58: {
                    block56: {
                        if (!(payloadType instanceof Vp8PayloadType)) break block56;
                        $i$a$-run-VideoParser$transform$payloadType$1 = this;
                        packetInfo$iv = packetInfo;
                        $i$f$parseNormalPayload = false;
                        this_$iv$iv = packetInfo$iv.getPacket();
                        $i$f$toOtherType = false;
                        Intrinsics.checkNotNullExpressionValue((Object)this_$iv$iv.buffer, (String)"buffer");
                        var13_37 = this_$iv$iv.length;
                        var14_41 = this_$iv$iv.offset;
                        p0 = this_$iv$iv.buffer;
                        $i$a$-parseNormalPayload-VideoParser$transform$parsedPacket$1 = false;
                        parsedPacket$iv = (ParsedVideoPacket)((Packet)new Vp8Packet(p0, (int)p1, (int)p2));
                        if (parsedPacket$iv.meetsRoutingNeeds()) ** GOTO lbl-1000
                        packet$iv = (RtpPacket)packetInfo$iv.packetAs();
                        av1DDExtId$iv = this_$iv.av1DDExtId;
                        if (av1DDExtId$iv != null && packet$iv.getHeaderExtension(av1DDExtId$iv.intValue()) != null) {
                            var18_52 = this_$iv;
                            packetInfo$iv$iv = packetInfo$iv;
                            $i$f$checkParserType = false;
                            packet$iv$iv = (RtpPacket)packetInfo$iv$iv.packetAs();
                            parser$iv$iv = this_$iv$iv.videoCodecParsers.get(packet$iv$iv.getSsrc());
                            if (parser$iv$iv instanceof Av1DDParser) {
                                v1 = parser$iv$iv;
                            } else {
                                v2 = MediaSourceDescKt.findRtpSource(this_$iv$iv.sources, packet$iv$iv);
                                if (v2 == null) {
                                    v1 = null;
                                } else {
                                    source$iv$iv = v2;
                                    $this$cdebug$iv$iv$iv = this_$iv$iv.logger;
                                    $i$f$cdebug = false;
                                    if ($this$cdebug$iv$iv$iv.isDebugEnabled()) {
                                        var26_88 = $this$cdebug$iv$iv$iv;
                                        $i$a$-cdebug-VideoParser$checkParserType$1$iv$iv = false;
                                        var26_88.debug((Object)("Creating new " + Av1DDParser.class.getSimpleName() + " for source " + source$iv$iv.getSourceName() + ", current videoCodecParser is " + ((v3 = parser$iv$iv) != null && (v3 = v3.getClass()) != null ? v3.getSimpleName() : null)));
                                    }
                                    super.resetSource(source$iv$iv);
                                    packetInfo$iv$iv.setLayeringChanged(true);
                                    source$iv = source$iv$iv;
                                    $i$a$-checkParserType-VideoParser$parseNormalPayload$parser$1$iv = false;
                                    newParser$iv$iv /* !! */  = new Av1DDParser(source$iv, this_$iv.logger, this_$iv.diagnosticContext);
                                    $this$forEach$iv$iv$iv = source$iv$iv.getRtpEncodings();
                                    $i$f$forEach = 0;
                                    var31_99 = $this$forEach$iv$iv$iv.length;
                                    for (var30_98 = 0; var30_98 < var31_99; ++var30_98) {
                                        it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var30_98];
                                        $i$a$-forEach-VideoParser$checkParserType$2$iv$iv = false;
                                        this_$iv$iv.videoCodecParsers.put(it$iv$iv.getPrimarySSRC(), (VideoCodecParser)newParser$iv$iv /* !! */ );
                                    }
                                    v1 = newParser$iv$iv /* !! */ ;
                                }
                            }
                            if ((v4 /* !! */  = (parser$iv = (Av1DDParser)v1)) != null && (v4 /* !! */  = v4 /* !! */ .createFrom(packet$iv, av1DDExtId$iv)) != null) {
                                it$iv /* !! */  = $i$f$checkParserType /* !! */  = v4 /* !! */ ;
                                $i$a$-also-VideoParser$parseNormalPayload$av1DDPacket$1$iv = false;
                                packetInfo$iv.setPacket((Packet)it$iv /* !! */ );
                                packetInfo$iv.resetPayloadVerification();
                                v5 /* !! */  = $i$f$checkParserType /* !! */ ;
                            } else {
                                v5 /* !! */  = null;
                            }
                            av1DDPacket$iv = v5 /* !! */ ;
                            v6 = new Pair(av1DDPacket$iv, (Object)parser$iv);
                        } else lbl-1000:
                        // 2 sources

                        {
                            packetInfo$iv.setPacket((Packet)parsedPacket$iv);
                            packetInfo$iv.resetPayloadVerification();
                            av1DDExtId$iv = this_$iv;
                            packetInfo$iv$iv = packetInfo$iv;
                            $i$f$checkParserType = false;
                            packet$iv$iv = (RtpPacket)packetInfo$iv$iv.packetAs();
                            parser$iv$iv = this_$iv$iv.videoCodecParsers.get(packet$iv$iv.getSsrc());
                            if (parser$iv$iv instanceof Vp8Parser) {
                                v7 = parser$iv$iv;
                            } else {
                                v8 = MediaSourceDescKt.findRtpSource(this_$iv$iv.sources, packet$iv$iv);
                                if (v8 == null) {
                                    v7 = null;
                                } else {
                                    source$iv$iv = v8;
                                    $this$cdebug$iv$iv$iv = this_$iv$iv.logger;
                                    $i$f$cdebug = false;
                                    if ($this$cdebug$iv$iv$iv.isDebugEnabled()) {
                                        newParser$iv$iv /* !! */  = $this$cdebug$iv$iv$iv;
                                        $i$a$-cdebug-VideoParser$checkParserType$1$iv$iv = false;
                                        newParser$iv$iv /* !! */ .debug((Object)("Creating new " + Vp8Parser.class.getSimpleName() + " for source " + source$iv$iv.getSourceName() + ", current videoCodecParser is " + ((v9 = parser$iv$iv) != null && (v9 = v9.getClass()) != null ? v9.getSimpleName() : null)));
                                    }
                                    super.resetSource(source$iv$iv);
                                    packetInfo$iv$iv.setLayeringChanged(true);
                                    source = source$iv$iv;
                                    $i$a$-parseNormalPayload-VideoParser$transform$parsedPacket$2 = false;
                                    newParser$iv$iv = new Vp8Parser(source, this.logger);
                                    $this$forEach$iv$iv$iv = source$iv$iv.getRtpEncodings();
                                    $i$f$forEach = false;
                                    $i$f$forEach = $this$forEach$iv$iv$iv.length;
                                    for (var26_89 = 0; var26_89 < $i$f$forEach; ++var26_89) {
                                        it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var26_89];
                                        $i$a$-forEach-VideoParser$checkParserType$2$iv$iv = 0;
                                        this_$iv$iv.videoCodecParsers.put(it$iv$iv.getPrimarySSRC(), newParser$iv$iv);
                                    }
                                    v7 = newParser$iv$iv;
                                }
                            }
                            parser$iv = v7;
                            v6 = new Pair((Object)parsedPacket$iv, (Object)parser$iv);
                        }
                        $this$transform_u24lambda_u240 = v6;
                        vp8Packet /* !! */  = (ParsedVideoPacket)$this$transform_u24lambda_u240.component1();
                        videoCodecParser = parser = (VideoCodecParser)$this$transform_u24lambda_u240.component2();
                        v10 /* !! */  = vp8Packet /* !! */ ;
                        break block57;
                    }
                    if (!(payloadType instanceof Vp9PayloadType)) break block58;
                    vp8Packet /* !! */  = this;
                    packetInfo$iv = packetInfo;
                    $i$f$parseNormalPayload = false;
                    this_$iv$iv = packetInfo$iv.getPacket();
                    $i$f$toOtherType = false;
                    Intrinsics.checkNotNullExpressionValue((Object)this_$iv$iv.buffer, (String)"buffer");
                    p2 = this_$iv$iv.length;
                    $i$a$-parseNormalPayload-VideoParser$transform$parsedPacket$2 = this_$iv$iv.offset;
                    p0 = this_$iv$iv.buffer;
                    $i$a$-parseNormalPayload-VideoParser$transform$parsedPacket$3 = false;
                    parsedPacket$iv = (ParsedVideoPacket)((Packet)new Vp9Packet(p0, (int)p1, p2));
                    if (parsedPacket$iv.meetsRoutingNeeds()) ** GOTO lbl-1000
                    packet$iv = (RtpPacket)packetInfo$iv.packetAs();
                    av1DDExtId$iv = this_$iv.av1DDExtId;
                    if (av1DDExtId$iv != null && packet$iv.getHeaderExtension(av1DDExtId$iv.intValue()) != null) {
                        $i$f$checkParserType = this_$iv;
                        packetInfo$iv$iv = packetInfo$iv;
                        $i$f$checkParserType = false;
                        packet$iv$iv = (RtpPacket)packetInfo$iv$iv.packetAs();
                        parser$iv$iv = this_$iv$iv.videoCodecParsers.get(packet$iv$iv.getSsrc());
                        if (parser$iv$iv instanceof Av1DDParser) {
                            v11 = parser$iv$iv;
                        } else {
                            v12 = MediaSourceDescKt.findRtpSource(this_$iv$iv.sources, packet$iv$iv);
                            if (v12 == null) {
                                v11 = null;
                            } else {
                                source$iv$iv = v12;
                                $this$cdebug$iv$iv$iv = this_$iv$iv.logger;
                                $i$f$cdebug = false;
                                if ($this$cdebug$iv$iv$iv.isDebugEnabled()) {
                                    var26_90 = $this$cdebug$iv$iv$iv;
                                    $i$a$-cdebug-VideoParser$checkParserType$1$iv$iv = false;
                                    var26_90.debug((Object)("Creating new " + Av1DDParser.class.getSimpleName() + " for source " + source$iv$iv.getSourceName() + ", current videoCodecParser is " + ((v13 = parser$iv$iv) != null && (v13 = v13.getClass()) != null ? v13.getSimpleName() : null)));
                                }
                                super.resetSource(source$iv$iv);
                                packetInfo$iv$iv.setLayeringChanged(true);
                                source$iv = source$iv$iv;
                                $i$a$-checkParserType-VideoParser$parseNormalPayload$parser$1$iv = false;
                                newParser$iv$iv /* !! */  = new Av1DDParser(source$iv, this_$iv.logger, this_$iv.diagnosticContext);
                                $this$forEach$iv$iv$iv = source$iv$iv.getRtpEncodings();
                                $i$f$forEach = 0;
                                var31_99 = $this$forEach$iv$iv$iv.length;
                                for ($i$a$-forEach-VideoParser$checkParserType$2$iv$iv = 0; $i$a$-forEach-VideoParser$checkParserType$2$iv$iv < var31_99; ++$i$a$-forEach-VideoParser$checkParserType$2$iv$iv) {
                                    it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[$i$a$-forEach-VideoParser$checkParserType$2$iv$iv];
                                    $i$a$-forEach-VideoParser$checkParserType$2$iv$iv = false;
                                    this_$iv$iv.videoCodecParsers.put(it$iv$iv.getPrimarySSRC(), (VideoCodecParser)newParser$iv$iv /* !! */ );
                                }
                                v11 = newParser$iv$iv /* !! */ ;
                            }
                        }
                        if ((v14 /* !! */  = (parser$iv = (Av1DDParser)v11)) != null && (v14 /* !! */  = v14 /* !! */ .createFrom(packet$iv, av1DDExtId$iv)) != null) {
                            it$iv /* !! */  = $i$f$checkParserType /* !! */  = v14 /* !! */ ;
                            $i$a$-also-VideoParser$parseNormalPayload$av1DDPacket$1$iv = false;
                            packetInfo$iv.setPacket((Packet)it$iv /* !! */ );
                            packetInfo$iv.resetPayloadVerification();
                            v15 /* !! */  = $i$f$checkParserType /* !! */ ;
                        } else {
                            v15 /* !! */  = null;
                        }
                        av1DDPacket$iv = v15 /* !! */ ;
                        v16 = new Pair(av1DDPacket$iv, (Object)parser$iv);
                    } else lbl-1000:
                    // 2 sources

                    {
                        packetInfo$iv.setPacket((Packet)parsedPacket$iv);
                        packetInfo$iv.resetPayloadVerification();
                        av1DDExtId$iv = this_$iv;
                        packetInfo$iv$iv = packetInfo$iv;
                        $i$f$checkParserType = false;
                        packet$iv$iv = (RtpPacket)packetInfo$iv$iv.packetAs();
                        parser$iv$iv = this_$iv$iv.videoCodecParsers.get(packet$iv$iv.getSsrc());
                        if (parser$iv$iv instanceof Vp9Parser) {
                            v17 = parser$iv$iv;
                        } else {
                            v18 = MediaSourceDescKt.findRtpSource(this_$iv$iv.sources, packet$iv$iv);
                            if (v18 == null) {
                                v17 = null;
                            } else {
                                source$iv$iv = v18;
                                $this$cdebug$iv$iv$iv = this_$iv$iv.logger;
                                $i$f$cdebug = false;
                                if ($this$cdebug$iv$iv$iv.isDebugEnabled()) {
                                    var24_81 = $this$cdebug$iv$iv$iv;
                                    $i$a$-cdebug-VideoParser$checkParserType$1$iv$iv = false;
                                    var24_81.debug((Object)("Creating new " + Vp9Parser.class.getSimpleName() + " for source " + source$iv$iv.getSourceName() + ", current videoCodecParser is " + ((v19 = parser$iv$iv) != null && (v19 = v19.getClass()) != null ? v19.getSimpleName() : null)));
                                }
                                super.resetSource(source$iv$iv);
                                packetInfo$iv$iv.setLayeringChanged(true);
                                source = source$iv$iv;
                                $i$a$-parseNormalPayload-VideoParser$transform$parsedPacket$4 = false;
                                newParser$iv$iv = new Vp9Parser(source, this.logger);
                                $this$forEach$iv$iv$iv = source$iv$iv.getRtpEncodings();
                                $i$f$forEach = false;
                                var27_92 = $this$forEach$iv$iv$iv.length;
                                for (var26_91 = 0; var26_91 < var27_92; ++var26_91) {
                                    it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var26_91];
                                    $i$a$-forEach-VideoParser$checkParserType$2$iv$iv = 0;
                                    this_$iv$iv.videoCodecParsers.put(it$iv$iv.getPrimarySSRC(), newParser$iv$iv);
                                }
                                v17 = newParser$iv$iv;
                            }
                        }
                        parser$iv = v17;
                        v16 = new Pair((Object)parsedPacket$iv, (Object)parser$iv);
                    }
                    $this$transform_u24lambda_u240 = v16;
                    vp9Packet = (ParsedVideoPacket)$this$transform_u24lambda_u240.component1();
                    videoCodecParser = parser = (VideoCodecParser)$this$transform_u24lambda_u240.component2();
                    v10 /* !! */  = vp9Packet;
                    break block57;
                }
                if (av1DDExtId != null && packet.getHeaderExtension(av1DDExtId.intValue()) != null) {
                    $this$transform_u24lambda_u240 = this;
                    packetInfo$iv = packetInfo;
                    $i$f$checkParserType = false;
                    packet$iv /* !! */  = (RtpPacket)packetInfo$iv.packetAs();
                    parser$iv = this_$iv.videoCodecParsers.get(packet$iv /* !! */ .getSsrc());
                    if (parser$iv instanceof Av1DDParser) {
                        v20 = parser$iv;
                    } else {
                        v21 = MediaSourceDescKt.findRtpSource(this_$iv.sources, packet$iv /* !! */ );
                        if (v21 == null) {
                            v20 = null;
                        } else {
                            source$iv = v21;
                            $this$cdebug$iv$iv = this_$iv.logger;
                            $i$f$cdebug = false;
                            if ($this$cdebug$iv$iv.isDebugEnabled()) {
                                var15_46 = $this$cdebug$iv$iv;
                                $i$a$-cdebug-VideoParser$checkParserType$1$iv = false;
                                var15_46.debug((Object)("Creating new " + Av1DDParser.class.getSimpleName() + " for source " + source$iv.getSourceName() + ", current videoCodecParser is " + ((v22 = parser$iv) != null && (v22 = v22.getClass()) != null ? v22.getSimpleName() : null)));
                            }
                            super.resetSource(source$iv);
                            packetInfo$iv.setLayeringChanged(true);
                            source = source$iv;
                            $i$a$-checkParserType-VideoParser$transform$parsedPacket$5 = false;
                            newParser$iv = new Av1DDParser(source, this.logger, this.diagnosticContext);
                            $this$forEach$iv$iv = source$iv.getRtpEncodings();
                            $i$f$forEach = false;
                            var20_67 = $this$forEach$iv$iv.length;
                            for (var19_60 = 0; var19_60 < var20_67; ++var19_60) {
                                it$iv = element$iv$iv = $this$forEach$iv$iv[var19_60];
                                $i$a$-forEach-VideoParser$checkParserType$2$iv = false;
                                this_$iv.videoCodecParsers.put(it$iv.getPrimarySSRC(), newParser$iv);
                            }
                            v20 = videoCodecParser = newParser$iv;
                        }
                    }
                    if ((v23 /* !! */  = (Av1DDParser)videoCodecParser) != null && (v23 /* !! */  = v23 /* !! */ .createFrom(packet, av1DDExtId)) != null) {
                        it /* !! */  = packet$iv /* !! */  = v23 /* !! */ ;
                        $i$a$-also-VideoParser$transform$parsedPacket$av1DDPacket$1 = false;
                        packetInfo.setPacket((Packet)it /* !! */ );
                        packetInfo.resetPayloadVerification();
                        v24 /* !! */  = packet$iv /* !! */ ;
                    } else {
                        v24 /* !! */  = null;
                    }
                    av1DDPacket = v24 /* !! */ ;
                    v10 /* !! */  = (ParsedVideoPacket)av1DDPacket;
                } else {
                    curParser = this.videoCodecParsers.get(packet.getSsrc());
                    if (curParser != null) {
                        $this$cdebug$iv = this.logger;
                        $i$f$cdebug = false;
                        if ($this$cdebug$iv.isDebugEnabled()) {
                            var36_104 = $this$cdebug$iv;
                            $i$a$-cdebug-VideoParser$transform$parsedPacket$6 = false;
                            var36_104.debug((Object)("Removing videoCodecParser on " + payloadType.getClass() + " packet, current videoCodecParser is " + curParser.getClass()));
                        }
                        v25 = MediaSourceDescKt.findRtpSource(this.sources, packet);
                        if (v25 != null) {
                            source = v25;
                            $i$a$-let-VideoParser$transform$parsedPacket$7 = false;
                            this.resetSource(source);
                            $this$forEach$iv = source.getRtpEncodings();
                            $i$f$forEach = false;
                            var15_47 = $this$forEach$iv.length;
                            for (var14_45 = 0; var14_45 < var15_47; ++var14_45) {
                                it = element$iv = $this$forEach$iv[var14_45];
                                $i$a$-forEach-VideoParser$transform$parsedPacket$7$1 = false;
                                this.videoCodecParsers.remove(it.getPrimarySSRC());
                            }
                            v26 = Unit.INSTANCE;
                        } else {
                            v26 = null;
                        }
                        packetInfo.setLayeringChanged(true);
                    }
                    return packetInfo;
                }
            }
            it = curParser = v10 /* !! */ ;
            $i$a$-also-VideoParser$transform$parsedPacket$8 = false;
            v27 = videoCodecParser;
            if (v27 != null) {
                v27.parse(packetInfo);
                v28 = Unit.INSTANCE;
            } else {
                v28 = null;
            }
        }
        catch (Exception e) {
            Intrinsics.checkNotNullExpressionValue((Object)packet.buffer, (String)"buffer");
            this.logger.error((Object)("Exception parsing video packet.  Packet data is: " + ByteArrayExtensionsKt.toHex((byte[])packet.buffer, (int)packet.offset, (int)Math.min(packet.length, 80))), (Throwable)e);
            return null;
        }
        parsedPacket = curParser;
        if (parsedPacket != null && parsedPacket.isKeyframe() && parsedPacket.isStartOfFrame()) {
            $this$cdebug$iv = this.logger;
            $i$f$cdebug = 0;
            if ($this$cdebug$iv.isDebugEnabled()) {
                var36_105 = $this$cdebug$iv;
                $i$a$-cdebug-VideoParser$transform$1 = false;
                var36_105.debug((Object)("Received a keyframe for ssrc " + packet.getSsrc() + " at seq " + packet.getSequenceNumber()));
            }
            $this$cdebug$iv = this.stats;
            $i$f$cdebug = $this$cdebug$iv.getNumKeyframes();
            $this$cdebug$iv.setNumKeyframes($i$f$cdebug + 1);
        }
        if (packetInfo.getLayeringChanged()) {
            $this$cdebug$iv = this.logger;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                var36_105 = $this$cdebug$iv;
                $i$a$-cdebug-VideoParser$transform$2 = false;
                var36_105.debug((Object)("Layering structure changed for ssrc " + packet.getSsrc() + " at seq " + packet.getSequenceNumber()));
            }
            var7_5 = this.stats;
            var8_13 = var7_5.getNumLayeringChanges();
            var7_5.setNumLayeringChanges(var8_13 + 1);
        }
        return packetInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <T extends VideoCodecParser> Pair<ParsedVideoPacket, VideoCodecParser> parseNormalPayload(PacketInfo packetInfo, Function3<? super byte[], ? super Integer, ? super Integer, ? extends ParsedVideoPacket> otherTypeCreator, Function1<? super MediaSourceDesc, ? extends T> parserConstructor) {
        VideoCodecParser videoCodecParser;
        void this_$iv;
        boolean $i$f$parseNormalPayload = false;
        Packet this_$iv2 = packetInfo.getPacket();
        boolean $i$f$toOtherType = false;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv2.buffer, (String)"buffer");
        ParsedVideoPacket parsedPacket = (ParsedVideoPacket)((Packet)otherTypeCreator.invoke((Object)this_$iv2.buffer, (Object)this_$iv2.offset, (Object)this_$iv2.length));
        if (!parsedPacket.meetsRoutingNeeds()) {
            RtpPacket packet = (RtpPacket)packetInfo.packetAs();
            Integer av1DDExtId = this.av1DDExtId;
            if (av1DDExtId != null && packet.getHeaderExtension(av1DDExtId.intValue()) != null) {
                Av1DDPacket av1DDPacket;
                Av1DDParser parser2;
                Object object;
                VideoCodecParser videoCodecParser2;
                void this_$iv3;
                VideoParser videoParser = this;
                PacketInfo packetInfo$iv = packetInfo;
                boolean $i$f$checkParserType2 = false;
                RtpPacket packet$iv = (RtpPacket)packetInfo$iv.packetAs();
                VideoCodecParser parser$iv = this_$iv3.videoCodecParsers.get(packet$iv.getSsrc());
                if (parser$iv instanceof Av1DDParser) {
                    videoCodecParser2 = parser$iv;
                } else {
                    MediaSourceDesc mediaSourceDesc = MediaSourceDescKt.findRtpSource(this_$iv3.sources, packet$iv);
                    if (mediaSourceDesc == null) {
                        videoCodecParser2 = null;
                    } else {
                        MediaSourceDesc source$iv = mediaSourceDesc;
                        Logger $this$cdebug$iv$iv = this_$iv3.logger;
                        boolean $i$f$cdebug = false;
                        if ($this$cdebug$iv$iv.isDebugEnabled()) {
                            Object object2;
                            Logger logger = $this$cdebug$iv$iv;
                            boolean bl = false;
                            logger.debug((Object)("Creating new " + Av1DDParser.class.getSimpleName() + " for source " + source$iv.getSourceName() + ", current videoCodecParser is " + ((object2 = parser$iv) != null && (object2 = object2.getClass()) != null ? ((Class)object2).getSimpleName() : null)));
                        }
                        super.resetSource(source$iv);
                        packetInfo$iv.setLayeringChanged(true);
                        MediaSourceDesc source = source$iv;
                        boolean bl = false;
                        VideoCodecParser newParser$iv = new Av1DDParser(source, this.logger, this.diagnosticContext);
                        RtpEncodingDesc[] $this$forEach$iv$iv = source$iv.getRtpEncodings();
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv$iv.length;
                        for (int i = 0; i < n; ++i) {
                            RtpEncodingDesc element$iv$iv;
                            RtpEncodingDesc it$iv = element$iv$iv = $this$forEach$iv$iv[i];
                            boolean bl2 = false;
                            this_$iv3.videoCodecParsers.put(it$iv.getPrimarySSRC(), newParser$iv);
                        }
                        videoCodecParser2 = newParser$iv;
                    }
                }
                if ((object = (parser2 = (Av1DDParser)videoCodecParser2)) != null && (object = object.createFrom(packet, av1DDExtId)) != null) {
                    Object $i$f$checkParserType2 = object;
                    Av1DDPacket it = (Av1DDPacket)((Object)$i$f$checkParserType2);
                    boolean bl = false;
                    packetInfo.setPacket((Packet)it);
                    packetInfo.resetPayloadVerification();
                    av1DDPacket = (Av1DDPacket)((Object)$i$f$checkParserType2);
                } else {
                    av1DDPacket = null;
                }
                Av1DDPacket av1DDPacket2 = av1DDPacket;
                return new Pair(av1DDPacket2, (Object)parser2);
            }
        }
        packetInfo.setPacket((Packet)parsedPacket);
        packetInfo.resetPayloadVerification();
        VideoParser av1DDExtId = this;
        PacketInfo packetInfo$iv = packetInfo;
        boolean $i$f$checkParserType = false;
        RtpPacket packet$iv = (RtpPacket)packetInfo$iv.packetAs();
        VideoCodecParser parser$iv = this_$iv.videoCodecParsers.get(packet$iv.getSsrc());
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (parser$iv instanceof VideoCodecParser) {
            videoCodecParser = parser$iv;
        } else {
            MediaSourceDesc mediaSourceDesc = MediaSourceDescKt.findRtpSource(this_$iv.sources, packet$iv);
            if (mediaSourceDesc == null) {
                videoCodecParser = null;
            } else {
                MediaSourceDesc source$iv = mediaSourceDesc;
                Logger $this$cdebug$iv$iv = this_$iv.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv$iv.isDebugEnabled()) {
                    Object object;
                    Logger logger = $this$cdebug$iv$iv;
                    boolean bl = false;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    logger.debug((Object)("Creating new " + VideoCodecParser.class.getSimpleName() + " for source " + source$iv.getSourceName() + ", current videoCodecParser is " + ((object = parser$iv) != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null)));
                }
                super.resetSource(source$iv);
                packetInfo$iv.setLayeringChanged(true);
                VideoCodecParser newParser$iv = (VideoCodecParser)parserConstructor.invoke((Object)source$iv);
                RtpEncodingDesc[] $this$forEach$iv$iv = source$iv.getRtpEncodings();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    RtpEncodingDesc element$iv$iv;
                    RtpEncodingDesc it$iv = element$iv$iv = $this$forEach$iv$iv[i];
                    boolean bl = false;
                    this_$iv.videoCodecParsers.put(it$iv.getPrimarySSRC(), newParser$iv);
                }
                videoCodecParser = newParser$iv;
            }
        }
        VideoCodecParser parser3 = videoCodecParser;
        return new Pair((Object)parsedPacket, (Object)parser3);
    }

    private final /* synthetic */ <T extends VideoCodecParser> T checkParserType(PacketInfo packetInfo, Function1<? super MediaSourceDesc, ? extends T> constructor) {
        boolean $i$f$checkParserType = false;
        RtpPacket packet = (RtpPacket)packetInfo.packetAs();
        VideoCodecParser parser2 = this.videoCodecParsers.get(packet.getSsrc());
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (parser2 instanceof VideoCodecParser) {
            return (T)parser2;
        }
        MediaSourceDesc mediaSourceDesc = MediaSourceDescKt.findRtpSource(this.sources, packet);
        if (mediaSourceDesc == null) {
            return null;
        }
        MediaSourceDesc source = mediaSourceDesc;
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Object object;
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            logger.debug((Object)("Creating new " + VideoCodecParser.class.getSimpleName() + " for source " + source.getSourceName() + ", current videoCodecParser is " + ((object = parser2) != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null)));
        }
        this.resetSource(source);
        packetInfo.setLayeringChanged(true);
        VideoCodecParser newParser = (VideoCodecParser)constructor.invoke((Object)source);
        RtpEncodingDesc[] $this$forEach$iv = source.getRtpEncodings();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            RtpEncodingDesc element$iv;
            RtpEncodingDesc it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.videoCodecParsers.put(it.getPrimarySSRC(), newParser);
        }
        return (T)newParser;
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof SetMediaSourcesEvent) {
            this.sources = ((SetMediaSourcesEvent)event).getMediaSourceDescs();
            this.signaledSources = ((SetMediaSourcesEvent)event).getSignaledMediaSourceDescs();
            Set ssrcsSeen = new LinkedHashSet();
            MediaSourceDesc[] $this$forEach$iv = this.sources;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv;
                MediaSourceDesc source = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                RtpEncodingDesc[] $this$forEach$iv2 = source.getRtpEncodings();
                boolean $i$f$forEach2 = false;
                int n2 = $this$forEach$iv2.length;
                for (int j = 0; j < n2; ++j) {
                    RtpEncodingDesc element$iv2;
                    RtpEncodingDesc it = element$iv2 = $this$forEach$iv2[j];
                    boolean bl2 = false;
                    VideoCodecParser videoCodecParser = this.videoCodecParsers.get(it.getPrimarySSRC());
                    if (videoCodecParser != null) {
                        videoCodecParser.setSource(source);
                    }
                    ssrcsSeen.add(it.getPrimarySSRC());
                }
            }
            this.videoCodecParsers.keySet().removeIf(arg_0 -> VideoParser.handleEvent$lambda$2(arg_0 -> VideoParser.handleEvent$lambda$1(ssrcsSeen, arg_0), arg_0));
        }
        super.handleEvent(event);
    }

    private final void resetSource(MediaSourceDesc source) {
        MediaSourceDesc signaledSource = MediaSourceDescKt.findRtpSourceByPrimary(this.signaledSources, source.getPrimarySSRC());
        if (signaledSource == null) {
            this.logger.warn((Object)("Unable to find signaled source corresponding to " + source.getPrimarySSRC()));
            return;
        }
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Resetting source " + source.getSourceName() + " to signaled source: " + signaledSource));
        }
        for (RtpEncodingDesc signaledEncoding : signaledSource.getRtpEncodings()) {
            source.setEncodingLayers(signaledEncoding.getLayers$jitsi_media_transform(), signaledEncoding.getPrimarySSRC());
        }
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        this.stats.addToNodeStatsBlock($this$getNodeStats_u24lambda_u240);
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    public OrderedJsonObject statsJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$statsJson_u24lambda_u240 = orderedJsonObject = super.statsJson();
        boolean bl = false;
        this.stats.addToJson($this$statsJson_u24lambda_u240);
        return orderedJsonObject;
    }

    @NotNull
    public final Stats.Snapshot getStats() {
        return this.stats.snapshot();
    }

    private static final Unit _init_$lambda$0(VideoParser this$0, Integer it) {
        this$0.av1DDExtId = it;
        return Unit.INSTANCE;
    }

    private static final boolean handleEvent$lambda$1(Set $ssrcsSeen, Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$ssrcsSeen.contains(it);
    }

    private static final boolean handleEvent$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats;", "", "<init>", "()V", "numKeyframes", "", "getNumKeyframes", "()I", "setNumKeyframes", "(I)V", "numLayeringChanges", "getNumLayeringChanges", "setNumLayeringChanges", "numPacketsDroppedUnknownPt", "getNumPacketsDroppedUnknownPt", "setNumPacketsDroppedUnknownPt", "snapshot", "Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats$Snapshot;", "addToNodeStatsBlock", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "nodeStatsBlock", "addToJson", "", "o", "Lorg/jitsi/utils/OrderedJsonObject;", "Snapshot", "jitsi-media-transform"})
    public static final class Stats {
        private int numKeyframes;
        private int numLayeringChanges;
        private int numPacketsDroppedUnknownPt;

        public final int getNumKeyframes() {
            return this.numKeyframes;
        }

        public final void setNumKeyframes(int n) {
            this.numKeyframes = n;
        }

        public final int getNumLayeringChanges() {
            return this.numLayeringChanges;
        }

        public final void setNumLayeringChanges(int n) {
            this.numLayeringChanges = n;
        }

        public final int getNumPacketsDroppedUnknownPt() {
            return this.numPacketsDroppedUnknownPt;
        }

        public final void setNumPacketsDroppedUnknownPt(int n) {
            this.numPacketsDroppedUnknownPt = n;
        }

        @NotNull
        public final Snapshot snapshot() {
            return new Snapshot(this.numKeyframes, this.numLayeringChanges, this.numPacketsDroppedUnknownPt);
        }

        @NotNull
        public final NodeStatsBlock addToNodeStatsBlock(@NotNull NodeStatsBlock nodeStatsBlock) {
            NodeStatsBlock nodeStatsBlock2;
            Intrinsics.checkNotNullParameter((Object)nodeStatsBlock, (String)"nodeStatsBlock");
            NodeStatsBlock $this$addToNodeStatsBlock_u24lambda_u240 = nodeStatsBlock2 = nodeStatsBlock;
            boolean bl = false;
            $this$addToNodeStatsBlock_u24lambda_u240.addNumber("num_packets_dropped_unknown_pt", this.numPacketsDroppedUnknownPt);
            $this$addToNodeStatsBlock_u24lambda_u240.addNumber("num_keyframes", this.numKeyframes);
            $this$addToNodeStatsBlock_u24lambda_u240.addNumber("num_layering_changes", this.numLayeringChanges);
            return nodeStatsBlock2;
        }

        public final void addToJson(@NotNull OrderedJsonObject o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            ((Map)o).put("num_packets_dropped_unknown_pt", this.numPacketsDroppedUnknownPt);
            ((Map)o).put("num_keyframes", this.numKeyframes);
            ((Map)o).put("num_layering_changes", this.numLayeringChanges);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\t\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats$Snapshot;", "", "numKeyframes", "", "numLayeringChanges", "numPacketsDroppedUnknownPt", "<init>", "(III)V", "getNumKeyframes", "()I", "getNumLayeringChanges", "setNumLayeringChanges", "(I)V", "getNumPacketsDroppedUnknownPt", "setNumPacketsDroppedUnknownPt", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "jitsi-media-transform"})
        public static final class Snapshot {
            private final int numKeyframes;
            private int numLayeringChanges;
            private int numPacketsDroppedUnknownPt;

            public Snapshot(int numKeyframes, int numLayeringChanges, int numPacketsDroppedUnknownPt) {
                this.numKeyframes = numKeyframes;
                this.numLayeringChanges = numLayeringChanges;
                this.numPacketsDroppedUnknownPt = numPacketsDroppedUnknownPt;
            }

            public final int getNumKeyframes() {
                return this.numKeyframes;
            }

            public final int getNumLayeringChanges() {
                return this.numLayeringChanges;
            }

            public final void setNumLayeringChanges(int n) {
                this.numLayeringChanges = n;
            }

            public final int getNumPacketsDroppedUnknownPt() {
                return this.numPacketsDroppedUnknownPt;
            }

            public final void setNumPacketsDroppedUnknownPt(int n) {
                this.numPacketsDroppedUnknownPt = n;
            }

            @NotNull
            public final OrderedJsonObject toJson() {
                OrderedJsonObject orderedJsonObject;
                OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
                boolean bl = false;
                $this$toJson_u24lambda_u240.put((Object)"num_packets_dropped_unknown_pt", (Object)this.numPacketsDroppedUnknownPt);
                $this$toJson_u24lambda_u240.put((Object)"num_keyframes", (Object)this.numKeyframes);
                $this$toJson_u24lambda_u240.put((Object)"num_layering_changes", (Object)this.numLayeringChanges);
                return orderedJsonObject;
            }

            public final int component1() {
                return this.numKeyframes;
            }

            public final int component2() {
                return this.numLayeringChanges;
            }

            public final int component3() {
                return this.numPacketsDroppedUnknownPt;
            }

            @NotNull
            public final Snapshot copy(int numKeyframes, int numLayeringChanges, int numPacketsDroppedUnknownPt) {
                return new Snapshot(numKeyframes, numLayeringChanges, numPacketsDroppedUnknownPt);
            }

            public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = snapshot.numKeyframes;
                }
                if ((n4 & 2) != 0) {
                    n2 = snapshot.numLayeringChanges;
                }
                if ((n4 & 4) != 0) {
                    n3 = snapshot.numPacketsDroppedUnknownPt;
                }
                return snapshot.copy(n, n2, n3);
            }

            @NotNull
            public String toString() {
                return "Snapshot(numKeyframes=" + this.numKeyframes + ", numLayeringChanges=" + this.numLayeringChanges + ", numPacketsDroppedUnknownPt=" + this.numPacketsDroppedUnknownPt + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.numKeyframes);
                result = result * 31 + Integer.hashCode(this.numLayeringChanges);
                result = result * 31 + Integer.hashCode(this.numPacketsDroppedUnknownPt);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Snapshot)) {
                    return false;
                }
                Snapshot snapshot = (Snapshot)other;
                if (this.numKeyframes != snapshot.numKeyframes) {
                    return false;
                }
                if (this.numLayeringChanges != snapshot.numLayeringChanges) {
                    return false;
                }
                return this.numPacketsDroppedUnknownPt == snapshot.numPacketsDroppedUnknownPt;
            }
        }
    }
}

