/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.CustomNullStringSerializerProvider;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.NullKeySerializer;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.http.TmmHttpServer;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.http.TvShowCommandHandler;
import org.tinymediamanager.scraper.util.MetadataUtil;

public final class TvShowModuleManager
implements ITmmModule {
    private static final String MODULE_TITLE = "TV show management";
    private static final String TV_SHOW_DB = "tvshows.db";
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowModuleManager.class);
    private static final int COMMIT_DELAY = 2000;
    private static final String METADATA_VERSION = "VERSION";
    private static TvShowModuleManager instance;
    private final List<String> startupMessages = new ArrayList<String>();
    private final Map<MediaEntity, Long> pendingChanges = new HashMap<MediaEntity, Long>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean enabled = false;
    private int autoCommitBufferSize = 8192;
    private MVStore mvStore;
    private ObjectWriter tvShowObjectWriter;
    private ObjectReader tvShowObjectReader;
    private ObjectWriter seasonObjectWriter;
    private ObjectReader seasonObjectReader;
    private ObjectWriter episodeObjectWriter;
    private ObjectReader episodeObjectReader;
    private MVMap<UUID, String> tvShowMap;
    private MVMap<UUID, String> seasonMap;
    private MVMap<UUID, String> episodeMap;
    private MVMap<String, String> metadataMap;
    private Timer databaseTimer;

    private TvShowModuleManager() {
        int bufferSize = Integer.getInteger("tmm.mvstore.buffersize", 8);
        if (2 <= bufferSize && bufferSize <= 64) {
            this.autoCommitBufferSize = 1024 * bufferSize;
        }
    }

    public static TvShowModuleManager getInstance() {
        if (instance == null) {
            instance = new TvShowModuleManager();
        }
        return instance;
    }

    static void clearInstances() {
        instance = null;
        TvShowSettings.clearInstance();
        TvShowList.clearInstance();
    }

    public TvShowSettings getSettings() {
        return TvShowSettings.getInstance();
    }

    public TvShowList getTvShowList() {
        return TvShowList.getInstance();
    }

    @Override
    public String getModuleTitle() {
        return MODULE_TITLE;
    }

    @Override
    public void startUp() {
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.AUTO_DETECT_GETTERS, false)).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false)).configure(MapperFeature.AUTO_DETECT_SETTERS, false)).configure(MapperFeature.AUTO_DETECT_FIELDS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).addModule((Module)new BlackbirdModule())).build();
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        objectMapper.setSerializerProvider((DefaultSerializerProvider)new CustomNullStringSerializerProvider());
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        this.tvShowObjectWriter = objectMapper.writerFor(TvShow.class);
        this.tvShowObjectReader = objectMapper.readerFor(TvShow.class);
        this.seasonObjectWriter = objectMapper.writerFor(TvShowSeason.class);
        this.seasonObjectReader = objectMapper.readerFor(TvShowSeason.class);
        this.episodeObjectWriter = objectMapper.writerFor(TvShowEpisode.class);
        this.episodeObjectReader = objectMapper.readerFor(TvShowEpisode.class);
        this.openDatabaseAndLoadTvShows();
        this.enabled = true;
        TimerTask databaseWriteTask = new TimerTask(){

            @Override
            public void run() {
                TvShowModuleManager.this.writePendingChanges();
            }
        };
        this.databaseTimer = new Timer();
        this.databaseTimer.schedule(databaseWriteTask, 2000L, 2000L);
        try {
            TmmHttpServer.getInstance().createContext("tvshow", new TvShowCommandHandler());
        }
        catch (Exception e) {
            LOGGER.warn("Could not register TV show API - '{}'", (Object)e.getMessage());
        }
    }

    private void openDatabaseAndLoadTvShows() {
        Path databaseFile = Paths.get(Settings.getInstance().getSettingsFolder(), TV_SHOW_DB);
        try {
            this.loadDatabase(databaseFile);
            return;
        }
        catch (Exception e) {
            if (e instanceof MVStoreException && e.getMessage().contains("format 1 is smaller")) {
                LOGGER.warn("Database file '{}' contains an old format - trying to import via dbmigrator.jar", (Object)databaseFile);
                try {
                    Map oldMetadataMap;
                    Map oldEpisodesMap;
                    Map oldSeasonsMap;
                    Path databaseBackup = Paths.get(Globals.BACKUP_FOLDER, "tvshows.db.oldv1");
                    Utils.deleteFileSafely(databaseBackup);
                    Utils.moveFileSafe(databaseFile, databaseBackup);
                    Map<?, ?> oldDatabase = UpgradeTasks.loadOldDatabase(databaseBackup);
                    this.loadDatabase(databaseFile);
                    this.tvShowMap = this.mvStore.openMap("tvshows");
                    this.seasonMap = this.mvStore.openMap("seasons");
                    this.episodeMap = this.mvStore.openMap("episodes");
                    Map oldTvShowsMap = (Map)oldDatabase.get("tvshows");
                    if (oldTvShowsMap != null) {
                        this.tvShowMap.putAll(oldTvShowsMap);
                    }
                    if ((oldSeasonsMap = (Map)oldDatabase.get("seasons")) != null) {
                        this.seasonMap.putAll(oldSeasonsMap);
                    }
                    if ((oldEpisodesMap = (Map)oldDatabase.get("episodes")) != null) {
                        this.episodeMap.putAll(oldEpisodesMap);
                    }
                    if ((oldMetadataMap = (Map)oldDatabase.get("metadata")) != null) {
                        this.metadataMap.putAll(oldMetadataMap);
                    }
                    this.getTvShowList().loadTvShowsFromDatabase(this.tvShowMap, this.seasonMap, this.episodeMap);
                    this.getTvShowList().initDataAfterLoading();
                    return;
                }
                catch (Exception ex) {
                    LOGGER.error("Could not load old database - '{}'", (Object)ex.getMessage());
                }
            }
            if ((e instanceof IllegalStateException || e instanceof MVStoreException) && e.getMessage().contains("file is locked")) {
                throw e;
            }
            if (this.mvStore != null && !this.mvStore.isClosed()) {
                this.mvStore.close();
            }
            LOGGER.error("Could not open database file '{}' - '{}'", (Object)databaseFile, (Object)e.getMessage());
            try {
                Path corruptedFile = Paths.get(Globals.BACKUP_FOLDER, "tvshows.db.corrupted");
                Utils.deleteFileSafely(corruptedFile);
                Utils.moveFileSafe(databaseFile, corruptedFile);
            }
            catch (Exception e2) {
                LOGGER.error("Could not move corrupted database to '{}' - '{}", (Object)"tvshows.db.corrupted", (Object)e2.getMessage());
            }
            LOGGER.info("Try to restore the database from the backups");
            List<Path> backups = Utils.listFiles(Paths.get(Globals.BACKUP_FOLDER, new String[0]));
            backups.sort(Comparator.reverseOrder());
            boolean first = true;
            for (Path backup : backups) {
                if (!backup.getFileName().toString().startsWith("data.")) continue;
                if (first) {
                    first = false;
                    continue;
                }
                try {
                    Utils.unzipFile(backup, Paths.get("/", "data", TV_SHOW_DB), databaseFile);
                    this.loadDatabase(databaseFile);
                    this.startupMessages.add(TmmResourceBundle.getString("tvshow.loaddb.failed.restore"));
                    LOGGER.info("Restored database from backup: '{}'", (Object)backup);
                    return;
                }
                catch (Exception e3) {
                    if (this.mvStore != null && !this.mvStore.isClosed()) {
                        this.mvStore.close();
                    }
                    LOGGER.error("Could not open database file from backup - '{}'", (Object)e3.getMessage());
                }
            }
            LOGGER.info("Starting over with an empty database file");
            try {
                Utils.deleteFileSafely(databaseFile);
                this.loadDatabase(databaseFile);
                this.startupMessages.add(TmmResourceBundle.getString("tvshow.loaddb.failed"));
            }
            catch (Exception e1) {
                LOGGER.error("Could not move old database file and create a new one - '{}'", (Object)e1.getMessage());
            }
            return;
        }
    }

    private void loadDatabase(final Path databaseFile) {
        Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){
            private int counter = 0;

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof IllegalStateException || e instanceof MVStoreException) {
                    if (this.counter < 10) {
                        ++this.counter;
                        return;
                    }
                    LOGGER.error("Database ({}) corruption detected - try to recover", (Object)databaseFile);
                    TvShowModuleManager.this.mvStore.close();
                    try {
                        Path corruptedFile = Paths.get(Globals.BACKUP_FOLDER, "tvshows.db.corrupted");
                        Utils.deleteFileSafely(corruptedFile);
                        Utils.moveFileSafe(databaseFile, corruptedFile);
                    }
                    catch (Exception e1) {
                        LOGGER.error("Could not move corrupted database to '{}' - '{}", (Object)"tvshows.db.corrupted", (Object)e1.getMessage());
                    }
                    TvShowModuleManager.this.mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitBufferSize(TvShowModuleManager.this.autoCommitBufferSize).backgroundExceptionHandler((Thread.UncaughtExceptionHandler)this).open();
                    TvShowModuleManager.this.mvStore.setAutoCommitDelay(2000);
                    TvShowModuleManager.this.mvStore.setRetentionTime(0);
                    TvShowModuleManager.this.mvStore.setReuseSpace(true);
                    TvShowModuleManager.this.mvStore.setCacheSize(8);
                    TvShowModuleManager.this.tvShowMap = TvShowModuleManager.this.mvStore.openMap("tvshows");
                    TvShowModuleManager.this.seasonMap = TvShowModuleManager.this.mvStore.openMap("seasons");
                    TvShowModuleManager.this.episodeMap = TvShowModuleManager.this.mvStore.openMap("episodes");
                    TvShowModuleManager.this.metadataMap = TvShowModuleManager.this.mvStore.openMap("metadata");
                    for (TvShow tvShow : TvShowModuleManager.this.getTvShowList().getTvShows()) {
                        TvShowModuleManager.this.persistTvShow(tvShow);
                        for (TvShowSeason season : tvShow.getSeasons()) {
                            TvShowModuleManager.this.persistSeason(season);
                        }
                        for (TvShowEpisode episode : tvShow.getEpisodes()) {
                            TvShowModuleManager.this.persistEpisode(episode);
                        }
                    }
                    this.counter = 0;
                }
            }
        };
        this.mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitBufferSize(this.autoCommitBufferSize).backgroundExceptionHandler(exceptionHandler).open();
        this.mvStore.setAutoCommitDelay(2000);
        this.mvStore.setRetentionTime(0);
        this.mvStore.setReuseSpace(true);
        this.mvStore.setCacheSize(8);
        this.tvShowMap = this.mvStore.openMap("tvshows");
        this.seasonMap = this.mvStore.openMap("seasons");
        this.episodeMap = this.mvStore.openMap("episodes");
        this.metadataMap = this.mvStore.openMap("metadata");
        this.getTvShowList().loadTvShowsFromDatabase(this.tvShowMap, this.seasonMap, this.episodeMap);
        this.getTvShowList().initDataAfterLoading();
    }

    @Override
    public synchronized void shutDown() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.enabled = false;
        this.databaseTimer.cancel();
        if (this.mvStore != null && !this.mvStore.isClosed()) {
            this.writePendingChanges(true);
            this.mvStore.close();
        }
        if (Settings.getInstance().isDeleteTrashOnExit()) {
            for (String ds : this.getSettings().getTvShowDataSource()) {
                Path file = Paths.get(ds, ".deletedByTMM");
                Utils.deleteDirectoryRecursive(file);
            }
        }
    }

    private void writePendingChanges() {
        this.writePendingChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writePendingChanges(boolean force) {
        if (this.mvStore == null || this.mvStore.isClosed() || this.pendingChanges.isEmpty()) {
            return;
        }
        if (force) {
            this.lock.writeLock().lock();
        } else if (!this.lock.writeLock().tryLock()) {
            return;
        }
        if (this.mvStore.isReadOnly()) {
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TV show database", "tmm.db.readonly", new String[]{TV_SHOW_DB}));
            this.pendingChanges.clear();
            this.lock.writeLock().unlock();
            return;
        }
        try {
            long now = System.currentTimeMillis();
            TreeMap<UUID, MediaEntity> mapToSave = new TreeMap<UUID, MediaEntity>();
            for (Map.Entry<MediaEntity, Long> entry : this.pendingChanges.entrySet()) {
                if (!force && entry.getValue() >= now - 2000L) continue;
                mapToSave.put(entry.getKey().getDbId(), entry.getKey());
            }
            for (Map.Entry<MediaEntity, Long> entry : mapToSave.entrySet()) {
                try {
                    TvShowEpisode episode;
                    String newValue;
                    Object oldValue;
                    Long l = entry.getValue();
                    if (l instanceof TvShow) {
                        TvShow tvShow = (TvShow)((Object)l);
                        oldValue = (String)this.tvShowMap.get((Object)tvShow.getDbId());
                        if (StringUtils.equals((CharSequence)oldValue, (CharSequence)(newValue = this.tvShowObjectWriter.writeValueAsString((Object)tvShow)))) continue;
                        this.tvShowMap.put((Object)tvShow.getDbId(), (Object)newValue);
                        continue;
                    }
                    oldValue = entry.getValue();
                    if (oldValue instanceof TvShowSeason) {
                        TvShowSeason season = (TvShowSeason)oldValue;
                        if (StringUtils.equals((CharSequence)(oldValue = (String)this.seasonMap.get((Object)season.getDbId())), (CharSequence)(newValue = this.seasonObjectWriter.writeValueAsString((Object)season)))) continue;
                        this.seasonMap.put((Object)season.getDbId(), (Object)newValue);
                        continue;
                    }
                    oldValue = entry.getValue();
                    if (!(oldValue instanceof TvShowEpisode) || StringUtils.equals((CharSequence)(oldValue = (String)this.episodeMap.get((Object)(episode = (TvShowEpisode)oldValue).getDbId())), (CharSequence)(newValue = this.episodeObjectWriter.writeValueAsString((Object)episode)))) continue;
                    this.episodeMap.put((Object)episode.getDbId(), (Object)newValue);
                }
                catch (Exception e) {
                    LOGGER.debug("could not store '{}' - '{}'", (Object)((MediaEntity)((Object)entry.getValue())).getClass().getName(), (Object)e.getMessage());
                }
                finally {
                    this.pendingChanges.remove(entry.getValue());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTvShowJsonFromDB(TvShow tvShow, boolean withChilds) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode showNode = (ObjectNode)mapper.readValue((String)this.tvShowMap.get((Object)tvShow.getDbId()), ObjectNode.class);
            if (withChilds) {
                ArrayNode seasons = JsonNodeFactory.instance.arrayNode();
                for (TvShowSeason se : tvShow.getSeasons()) {
                    ObjectNode seasonNode = (ObjectNode)mapper.readValue((String)this.seasonMap.get((Object)se.getDbId()), ObjectNode.class);
                    ArrayNode episodes = JsonNodeFactory.instance.arrayNode();
                    for (TvShowEpisode ep : se.getEpisodes()) {
                        ObjectNode epNode = (ObjectNode)mapper.readValue((String)this.episodeMap.get((Object)ep.getDbId()), ObjectNode.class);
                        episodes.add((JsonNode)epNode);
                    }
                    seasonNode.set("episodes", (JsonNode)episodes);
                    seasons.add((JsonNode)seasonNode);
                }
                showNode.set("seasons", (JsonNode)seasons);
            }
            String s = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)showNode);
            return s;
        }
        catch (Exception e) {
            LOGGER.debug("Cannot parse JSON!", (Throwable)e);
            return "";
        }
    }

    public void dump(TvShow tvShow, boolean withChilds) {
        String d = this.getTvShowJsonFromDB(tvShow, withChilds);
        if (!d.isEmpty()) {
            LOGGER.debug("Dumping TvShow: {}\n{}", (Object)tvShow.getDbId(), (Object)d);
        }
    }

    public void dump(TvShowSeason season, boolean withChilds) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode seasonNode = (ObjectNode)mapper.readValue((String)this.seasonMap.get((Object)season.getDbId()), ObjectNode.class);
            if (withChilds) {
                ArrayNode episodes = JsonNodeFactory.instance.arrayNode();
                for (TvShowEpisode ep : season.getEpisodes()) {
                    ObjectNode epNode = (ObjectNode)mapper.readValue((String)this.episodeMap.get((Object)ep.getDbId()), ObjectNode.class);
                    episodes.add((JsonNode)epNode);
                }
                seasonNode.set("episodes", (JsonNode)episodes);
            }
            String s = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)seasonNode);
            LOGGER.debug("Dumping TvShowSeason: {}\n{}", (Object)season.getDbId(), (Object)s);
        }
        catch (Exception e) {
            LOGGER.debug("Cannot parse JSON!", (Throwable)e);
        }
    }

    public void dump(TvShowEpisode episode) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            if (this.episodeMap.get((Object)episode.getDbId()) != null) {
                ObjectNode epNode = (ObjectNode)mapper.readValue((String)this.episodeMap.get((Object)episode.getDbId()), ObjectNode.class);
                String s = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)epNode);
                LOGGER.debug("Dumping TvShowEpisode: {}\n{}", (Object)episode.getDbId(), (Object)s);
            } else {
                LOGGER.debug("Cannot dump DummyEpisode - check them on show level!");
            }
        }
        catch (Exception e) {
            LOGGER.debug("Cannot parse JSON!", (Throwable)e);
        }
    }

    void persistTvShow(TvShow tvShow) {
        if (!this.enabled) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.put(tvShow, System.currentTimeMillis());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void removeTvShowFromDb(TvShow tvShow) {
        if (!this.enabled) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.remove(tvShow);
            this.tvShowMap.remove((Object)tvShow.getDbId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void persistSeason(TvShowSeason season) {
        if (!this.enabled) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.put(season, System.currentTimeMillis());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void removeSeasonFromDb(TvShowSeason season) {
        if (!this.enabled) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.remove(season);
            this.seasonMap.remove((Object)season.getDbId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void persistEpisode(TvShowEpisode episode) {
        if (!this.enabled) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.put(episode, System.currentTimeMillis());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void removeEpisodeFromDb(TvShowEpisode episode) {
        if (!this.enabled) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.remove(episode);
            this.episodeMap.remove((Object)episode.getDbId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void initializeDatabase() {
        Utils.deleteFileSafely(Paths.get(Settings.getInstance().getSettingsFolder(), TV_SHOW_DB));
    }

    @Override
    public void saveSettings() {
        this.getSettings().saveSettings();
    }

    @Override
    public List<String> getStartupMessages() {
        return this.startupMessages;
    }

    public ObjectReader getTvShowObjectReader() {
        return this.tvShowObjectReader;
    }

    public ObjectReader getEpisodeObjectReader() {
        return this.episodeObjectReader;
    }

    public ObjectReader getSeasonObjectReader() {
        return this.seasonObjectReader;
    }

    public int getDbVersion() {
        return MetadataUtil.parseInt((String)this.metadataMap.get((Object)METADATA_VERSION), 0);
    }

    public void setDbVersion(int ver) {
        this.metadataMap.put((Object)METADATA_VERSION, (Object)String.valueOf(ver));
    }
}

