/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.util.Map;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.types.UnsignedIntegerFourBytes;

public class PositionInfo {
    private UnsignedIntegerFourBytes track = new UnsignedIntegerFourBytes(0L);
    private String trackDuration = "00:00:00";
    private String trackMetaData = "NOT_IMPLEMENTED";
    private String trackURI = "";
    private String relTime = "00:00:00";
    private String absTime = "00:00:00";
    private int relCount = Integer.MAX_VALUE;
    private int absCount = Integer.MAX_VALUE;

    public PositionInfo() {
    }

    public PositionInfo(Map<String, ActionArgumentValue<?>> args) {
        this(((UnsignedIntegerFourBytes)args.get("Track").getValue()).getValue(), (String)args.get("TrackDuration").getValue(), (String)args.get("TrackMetaData").getValue(), (String)args.get("TrackURI").getValue(), (String)args.get("RelTime").getValue(), (String)args.get("AbsTime").getValue(), (Integer)args.get("RelCount").getValue(), (Integer)args.get("AbsCount").getValue());
    }

    public PositionInfo(PositionInfo copy, String relTime, String absTime) {
        this.track = copy.track;
        this.trackDuration = copy.trackDuration;
        this.trackMetaData = copy.trackMetaData;
        this.trackURI = copy.trackURI;
        this.relTime = relTime;
        this.absTime = absTime;
        this.relCount = copy.relCount;
        this.absCount = copy.absCount;
    }

    public PositionInfo(PositionInfo copy, long relTimeSeconds, long absTimeSeconds) {
        this.track = copy.track;
        this.trackDuration = copy.trackDuration;
        this.trackMetaData = copy.trackMetaData;
        this.trackURI = copy.trackURI;
        this.relTime = ModelUtil.toTimeString((long)relTimeSeconds);
        this.absTime = ModelUtil.toTimeString((long)absTimeSeconds);
        this.relCount = copy.relCount;
        this.absCount = copy.absCount;
    }

    public PositionInfo(long track, String trackDuration, String trackURI, String relTime, String absTime) {
        this.track = new UnsignedIntegerFourBytes(track);
        this.trackDuration = trackDuration;
        this.trackURI = trackURI;
        this.relTime = relTime;
        this.absTime = absTime;
    }

    public PositionInfo(long track, String trackDuration, String trackMetaData, String trackURI, String relTime, String absTime, int relCount, int absCount) {
        this.track = new UnsignedIntegerFourBytes(track);
        this.trackDuration = trackDuration;
        this.trackMetaData = trackMetaData;
        this.trackURI = trackURI;
        this.relTime = relTime;
        this.absTime = absTime;
        this.relCount = relCount;
        this.absCount = absCount;
    }

    public PositionInfo(long track, String trackMetaData, String trackURI) {
        this.track = new UnsignedIntegerFourBytes(track);
        this.trackMetaData = trackMetaData;
        this.trackURI = trackURI;
    }

    public UnsignedIntegerFourBytes getTrack() {
        return this.track;
    }

    public String getTrackDuration() {
        return this.trackDuration;
    }

    public String getTrackMetaData() {
        return this.trackMetaData;
    }

    public String getTrackURI() {
        return this.trackURI;
    }

    public String getRelTime() {
        return this.relTime;
    }

    public String getAbsTime() {
        return this.absTime;
    }

    public int getRelCount() {
        return this.relCount;
    }

    public int getAbsCount() {
        return this.absCount;
    }

    public void setTrackDuration(String trackDuration) {
        this.trackDuration = trackDuration;
    }

    public void setRelTime(String relTime) {
        this.relTime = relTime;
    }

    public long getTrackDurationSeconds() {
        return this.getTrackDuration() == null ? 0L : ModelUtil.fromTimeString((String)this.getTrackDuration());
    }

    public long getTrackElapsedSeconds() {
        return this.getRelTime() == null || this.getRelTime().equals("NOT_IMPLEMENTED") ? 0L : ModelUtil.fromTimeString((String)this.getRelTime());
    }

    public long getTrackRemainingSeconds() {
        return this.getTrackDurationSeconds() - this.getTrackElapsedSeconds();
    }

    public int getElapsedPercent() {
        long elapsed = this.getTrackElapsedSeconds();
        long total = this.getTrackDurationSeconds();
        if (elapsed == 0L || total == 0L) {
            return 0;
        }
        return Double.valueOf((double)elapsed / ((double)total / 100.0)).intValue();
    }

    public String toString() {
        return "(PositionInfo) Track: " + String.valueOf(this.getTrack()) + " RelTime: " + this.getRelTime() + " Duration: " + this.getTrackDuration() + " Percent: " + this.getElapsedPercent();
    }
}

