/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.container;

import java.net.URI;
import java.util.List;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.container.Container;

public class Album
extends Container {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.container.album");

    public Album() {
        this.setClazz(CLASS);
    }

    public Album(Container other) {
        super(other);
    }

    public Album(String id, Container parent, String title, String creator, Integer childCount) {
        this(id, parent.getId(), title, creator, childCount);
    }

    public Album(String id, String parentID, String title, String creator, Integer childCount) {
        super(id, parentID, title, creator, CLASS, childCount);
    }

    public String getDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DESCRIPTION.class);
    }

    public Album setDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DESCRIPTION(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.LONG_DESCRIPTION.class);
    }

    public Album setLongDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(description));
        return this;
    }

    public StorageMedium getStorageMedium() {
        return (StorageMedium)((Object)this.getFirstPropertyValue(DIDLObject.Property.UPNP.STORAGE_MEDIUM.class));
    }

    public Album setStorageMedium(StorageMedium storageMedium) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(storageMedium));
        return this;
    }

    public String getDate() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DATE.class);
    }

    public Album setDate(String date) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DATE(date));
        return this;
    }

    public URI getFirstRelation() {
        return (URI)this.getFirstPropertyValue(DIDLObject.Property.DC.RELATION.class);
    }

    public URI[] getRelations() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RELATION.class);
        return list.toArray(new URI[list.size()]);
    }

    public Album setRelations(URI[] relations) {
        this.removeProperties(DIDLObject.Property.DC.RELATION.class);
        for (URI relation : relations) {
            this.addProperty(new DIDLObject.Property.DC.RELATION(relation));
        }
        return this;
    }

    public String getFirstRights() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.RIGHTS.class);
    }

    public String[] getRights() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RIGHTS.class);
        return list.toArray(new String[list.size()]);
    }

    public Album setRights(String[] rights) {
        this.removeProperties(DIDLObject.Property.DC.RIGHTS.class);
        for (String right : rights) {
            this.addProperty(new DIDLObject.Property.DC.RIGHTS(right));
        }
        return this;
    }

    public Person getFirstContributor() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.CONTRIBUTOR.class);
    }

    public Person[] getContributors() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.CONTRIBUTOR.class);
        return list.toArray(new Person[list.size()]);
    }

    public Album setContributors(Person[] contributors) {
        this.removeProperties(DIDLObject.Property.DC.CONTRIBUTOR.class);
        for (Person p : contributors) {
            this.addProperty(new DIDLObject.Property.DC.CONTRIBUTOR(p));
        }
        return this;
    }

    public Person getFirstPublisher() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.PUBLISHER.class);
    }

    public Person[] getPublishers() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.PUBLISHER.class);
        return list.toArray(new Person[list.size()]);
    }

    public Album setPublishers(Person[] publishers) {
        this.removeProperties(DIDLObject.Property.DC.PUBLISHER.class);
        for (Person publisher : publishers) {
            this.addProperty(new DIDLObject.Property.DC.PUBLISHER(publisher));
        }
        return this;
    }
}

