/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.filenaming;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.ITvShowSeasonFileNaming;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TvShowSeasonFanartNaming implements ITvShowSeasonFileNaming
{
    SEASON_FANART{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            Object filename = tvShowSeason.getSeason() == -1 ? "season-all-fanart." + extension : (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason() ? "season-specials-fanart." + extension : (tvShowSeason.getSeason() > -1 ? String.format("season%02d-fanart.%s", tvShowSeason.getSeason(), extension) : ""));
            return filename;
        }
    }
    ,
    SEASON_FOLDER{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_FANART.getFilename(tvShowSeason, extension, forRenamer);
            }
            Object filename = String.format("season%02d-fanart.%s", tvShowSeason.getSeason(), extension);
            if (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                filename = "season-specials-fanart." + extension;
            }
            return seasonFoldername + File.separator + (String)filename;
        }
    };

}

