/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;

public class TvShowReloadMediaInformationTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowReloadMediaInformationTask.class);
    private final Collection<TvShow> tvShows;
    private final Collection<TvShowEpisode> episodes;

    public TvShowReloadMediaInformationTask(Collection<TvShow> tvShows, Collection<TvShowEpisode> episodes) {
        super(TmmResourceBundle.getString("tvshow.updatemediainfo"));
        this.tvShows = new ArrayList<TvShow>(tvShows);
        this.episodes = new ArrayList<TvShowEpisode>(episodes);
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                if (this.episodes.contains(episode)) continue;
                this.episodes.add(episode);
            }
        }
    }

    @Override
    protected void doInBackground() {
        try {
            LOGGER.info("Getting MediaInfo for '{}' movies", (Object)this.tvShows.size());
            this.initThreadPool(1, "reloadMI");
            for (final TvShow show : this.tvShows) {
                if (this.cancel) break;
                for (MediaFile mf : show.getMediaFiles()) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, show, true){

                        @Override
                        public void callbackForGatheredMediainformation() {
                            super.callbackForGatheredMediainformation();
                            show.writeNFO();
                        }
                    });
                }
                for (TvShowSeason season : show.getSeasons()) {
                    for (MediaFile mf : season.getMediaFiles()) {
                        this.submitTask(new MediaFileInformationFetcherTask(mf, season, true));
                    }
                }
            }
            for (final TvShowEpisode episode : this.episodes) {
                if (this.cancel) break;
                for (MediaFile mf : episode.getMediaFiles()) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, episode, true){

                        @Override
                        public void callbackForGatheredMediainformation() {
                            super.callbackForGatheredMediainformation();
                            episode.writeNFO();
                        }
                    });
                }
            }
            this.waitForCompletionOrCancel();
            LOGGER.info("Finished getting MediaInfo - took {} ms", (Object)this.getRuntime());
        }
        catch (Exception e) {
            LOGGER.error("Could not get MediaInfo - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "MediaInfo", "message.mediainfo.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }
}

