/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.MovieSetConnectors;
import org.tinymediamanager.core.movie.filenaming.MovieSetNfoNaming;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;

public class MovieSetSettingsPanel
extends JPanel {
    private static final int COL_COUNT = 7;
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private JCheckBox chckbxShowMissingMovies;
    private JCheckBox chckbxTvShowTableTooltips;
    private JCheckBox chckbxDisplayAllMissingMetadata;
    private JCheckBox chckbxDisplayAllMissingArtwork;
    private JTextField tfMovieSetArtworkFolder;
    private JButton btnSelectFolder;
    private JComboBox cbNfoFormat;
    private JCheckBox cbMovieNfoFilename1;
    private JCheckBox cbMovieNfoFilename2;
    private JCheckBox cbMovieNfoFilename3;
    private JCheckBox cbMovieNfoFilename4;
    private JCheckBox chckbxStoreFilter;
    private final Map<MovieSetScraperMetadataConfig, JCheckBox> metadataCheckBoxes = new LinkedHashMap<MovieSetScraperMetadataConfig, JCheckBox>();
    private final Map<MovieSetScraperMetadataConfig, JCheckBox> artworkCheckBoxes = new LinkedHashMap<MovieSetScraperMetadataConfig, JCheckBox>();
    private final ItemListener checkBoxListener = e -> this.checkChanges();

    public MovieSetSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnSelectFolder.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("movieset.folderchooser.path");
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("Settings.movieset.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.tfMovieSetArtworkFolder.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("movieset.folderchooser.path", file.toAbsolutePath().toString());
            }
        });
        this.buildCheckBoxes();
    }

    private void checkChanges() {
        JCheckBox value;
        MovieSetScraperMetadataConfig key;
        this.settings.clearMovieSetCheckMetadata();
        for (Map.Entry<MovieSetScraperMetadataConfig, JCheckBox> entry : this.metadataCheckBoxes.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addMovieSetCheckMetadata(key);
        }
        this.settings.clearMovieSetCheckArtwork();
        for (Map.Entry<MovieSetScraperMetadataConfig, JCheckBox> entry : this.artworkCheckBoxes.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addMovieSetCheckArtwork(key);
        }
        this.settings.clearMovieSetNfoFilenames();
        if (this.cbMovieNfoFilename1.isSelected()) {
            this.settings.addMovieSetNfoFilename(MovieSetNfoNaming.KODI_NFO);
        }
        if (this.cbMovieNfoFilename2.isSelected()) {
            this.settings.addMovieSetNfoFilename(MovieSetNfoNaming.AUTOMATOR_NFO);
        }
        if (this.cbMovieNfoFilename3.isSelected()) {
            this.settings.addMovieSetNfoFilename(MovieSetNfoNaming.EMBY_NFO);
        }
        if (this.cbMovieNfoFilename4.isSelected()) {
            this.settings.addMovieSetNfoFilename(MovieSetNfoNaming.KODI2_NFO);
        }
    }

    private void buildCheckBoxes() {
        JCheckBox checkBox;
        List<MovieSetNfoNaming> movieSetNfoFilenames = this.settings.getMovieSetNfoFilenames();
        if (movieSetNfoFilenames.contains(MovieSetNfoNaming.KODI_NFO)) {
            this.cbMovieNfoFilename1.setSelected(true);
        }
        if (movieSetNfoFilenames.contains(MovieSetNfoNaming.AUTOMATOR_NFO)) {
            this.cbMovieNfoFilename2.setSelected(true);
        }
        if (movieSetNfoFilenames.contains(MovieSetNfoNaming.EMBY_NFO)) {
            this.cbMovieNfoFilename3.setSelected(true);
        }
        if (movieSetNfoFilenames.contains(MovieSetNfoNaming.KODI2_NFO)) {
            this.cbMovieNfoFilename4.setSelected(true);
        }
        this.cbMovieNfoFilename1.addItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename2.addItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename3.addItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename4.addItemListener(this.checkBoxListener);
        for (MovieSetScraperMetadataConfig value : this.settings.getMovieSetCheckMetadata()) {
            checkBox = this.metadataCheckBoxes.get(value);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox checkBox2 : this.metadataCheckBoxes.values()) {
            checkBox2.addItemListener(this.checkBoxListener);
        }
        for (MovieSetScraperMetadataConfig value : this.settings.getMovieSetCheckArtwork()) {
            checkBox = this.artworkCheckBoxes.get(value);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox checkBox2 : this.artworkCheckBoxes.values()) {
            checkBox2.addItemListener(this.checkBoxListener);
        }
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkbox : checkBoxes) {
            checkbox.setSelected(false);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][15lp!][][15lp!][]"));
        JPanel panelUiSettings = new JPanel();
        panelUiSettings.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][]"));
        TmmLabel lblUiSettings = new TmmLabel(TmmResourceBundle.getString("Settings.ui"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelUiSettings, lblUiSettings, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#ui-settings"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        this.chckbxStoreFilter = new JCheckBox(TmmResourceBundle.getString("Settings.movie.persistuifilter"));
        panelUiSettings.add((Component)this.chckbxStoreFilter, "cell 1 0 2 1");
        this.chckbxShowMissingMovies = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.showmissingmovies"));
        panelUiSettings.add((Component)this.chckbxShowMissingMovies, "cell 1 1 2 1");
        this.chckbxTvShowTableTooltips = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.showtabletooltips"));
        panelUiSettings.add((Component)this.chckbxTvShowTableTooltips, "cell 1 2 2 1");
        JPanel panelData = new JPanel();
        panelData.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!,grow][grow]", "[][grow][10lp!][][grow]"));
        TmmLabel lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.data"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelData, lblMiscT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        TmmLabel lblFoldername = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.datafolder"));
        panelData.add((Component)lblFoldername, "cell 1 0 2 1");
        this.tfMovieSetArtworkFolder = new JTextField();
        panelData.add((Component)this.tfMovieSetArtworkFolder, "cell 1 0 2 1");
        this.tfMovieSetArtworkFolder.setColumns(40);
        this.btnSelectFolder = new JButton(TmmResourceBundle.getString("Settings.movieset.buttonselect"));
        panelData.add((Component)this.btnSelectFolder, "cell 1 0 2 1");
        ReadOnlyTextArea taHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.movieset.datafolder.hint"));
        panelData.add((Component)taHint, "cell 1 1 2 1,grow, wmin 0");
        JLabel lblNfoFormat = new JLabel(TmmResourceBundle.getString("Settings.nfoFormat"));
        panelData.add((Component)lblNfoFormat, "flowx,cell 1 3 2 1");
        this.cbNfoFormat = new JComboBox<MovieSetConnectors>(MovieSetConnectors.values());
        panelData.add((Component)this.cbNfoFormat, "cell 1 3 2 1");
        JPanel panelNfoFilenames = new JPanel();
        panelData.add((Component)panelNfoFilenames, "cell 1 4 2 1,grow");
        panelNfoFilenames.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][][][]"));
        JLabel lblNewLabel = new JLabel(TmmResourceBundle.getString("Settings.nofFileNaming"));
        panelNfoFilenames.add((Component)lblNewLabel, "cell 0 0");
        this.cbMovieNfoFilename4 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/set.nfo");
        panelNfoFilenames.add((Component)this.cbMovieNfoFilename4, "cell 1 0");
        this.cbMovieNfoFilename1 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/" + TmmResourceBundle.getString("Settings.movieset.moviesetname") + ".nfo");
        panelNfoFilenames.add((Component)this.cbMovieNfoFilename1, "cell 1 1");
        this.cbMovieNfoFilename2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + ".nfo");
        panelNfoFilenames.add((Component)this.cbMovieNfoFilename2, "cell 1 2");
        this.cbMovieNfoFilename3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/collection.nfo");
        panelNfoFilenames.add((Component)this.cbMovieNfoFilename3, "cell 1 3");
        JPanel panelMisc = new JPanel();
        panelMisc.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][]"));
        lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.misc"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        JLabel lblCheckMetadata = new JLabel(TmmResourceBundle.getString("Settings.checkmetadata"));
        panelMisc.add((Component)lblCheckMetadata, "cell 1 0 2 1");
        JPanel panelCheckMetadata = new JPanel();
        panelCheckMetadata.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 10;
        for (MovieSetScraperMetadataConfig value : MovieSetScraperMetadataConfig.values()) {
            if (!value.isMetaData()) continue;
            this.addMetadataCheckbox(panelCheckMetadata, value, this.metadataCheckBoxes, gbc);
        }
        panelMisc.add((Component)panelCheckMetadata, "cell 2 1");
        this.chckbxDisplayAllMissingMetadata = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkmetadata.displayall"));
        this.chckbxDisplayAllMissingMetadata.setToolTipText(TmmResourceBundle.getString("Settings.checkmetadata.displayall.desc"));
        panelMisc.add((Component)this.chckbxDisplayAllMissingMetadata, "cell 2 2");
        JLabel lblCheckImages = new JLabel(TmmResourceBundle.getString("Settings.checkimages"));
        panelMisc.add((Component)lblCheckImages, "cell 1 4 2 1");
        JPanel panelCheckImages = new JPanel();
        panelCheckImages.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 10;
        for (MovieSetScraperMetadataConfig value : MovieSetScraperMetadataConfig.values()) {
            if (!value.isArtwork()) continue;
            this.addMetadataCheckbox(panelCheckImages, value, this.artworkCheckBoxes, gbc);
        }
        panelMisc.add((Component)panelCheckImages, "cell 2 5");
        this.chckbxDisplayAllMissingArtwork = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkimages.displayall"));
        this.chckbxDisplayAllMissingArtwork.setToolTipText(TmmResourceBundle.getString("Settings.checkimages.displayall.desc"));
        panelMisc.add((Component)this.chckbxDisplayAllMissingArtwork, "cell 2 6");
    }

    private void addMetadataCheckbox(JPanel panel, MovieSetScraperMetadataConfig config, Map<MovieSetScraperMetadataConfig, JCheckBox> map, GridBagConstraints gbc) {
        JCheckBox checkBox;
        if (StringUtils.isNotBlank((CharSequence)config.getToolTip())) {
            checkBox = new JHintCheckBox(config.getDescription());
            checkBox.setToolTipText(config.getToolTip());
            ((JHintCheckBox)checkBox).setHintIcon(IconManager.HINT);
        } else {
            checkBox = new JCheckBox(config.getDescription());
        }
        map.put(config, checkBox);
        if (gbc.gridx >= 7) {
            gbc.gridx = 0;
            ++gbc.gridy;
        }
        panel.add((Component)checkBox, gbc);
        ++gbc.gridx;
    }

    protected void initDataBindings() {
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"displayMovieSetMissingMovies");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxShowMissingMovies, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"showMovieSetTableTooltips");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, (Object)this.chckbxTvShowTableTooltips, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"storeMovieSetUiFilters");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxStoreFilter, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"movieSetDataFolder");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.tfMovieSetArtworkFolder, (Property)jTextFieldBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"movieSetConnector");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, (Object)this.cbNfoFormat, (Property)jComboBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty movieSettingsBeanProperty_5 = BeanProperty.create((String)"movieSetDisplayAllMissingMetadata");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_5, (Object)this.chckbxDisplayAllMissingMetadata, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSettingsBeanProperty_6 = BeanProperty.create((String)"movieSetDisplayAllMissingArtwork");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_6, (Object)this.chckbxDisplayAllMissingArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
    }
}

