/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Service;
import org.jupnp.util.SpecificationViolationReporter;

public class Action<S extends Service>
implements Validatable {
    private final String name;
    private final ActionArgument[] arguments;
    private final ActionArgument[] inputArguments;
    private final ActionArgument[] outputArguments;
    private S service;

    public Action(String name, ActionArgument[] arguments) {
        this.name = name;
        if (arguments != null) {
            ArrayList<ActionArgument> inputList = new ArrayList<ActionArgument>();
            ArrayList<ActionArgument> outputList = new ArrayList<ActionArgument>();
            ActionArgument[] actionArgumentArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                ActionArgument argument = actionArgumentArray[n2];
                argument.setAction(this);
                if (argument.getDirection().equals((Object)ActionArgument.Direction.IN)) {
                    inputList.add(argument);
                }
                if (argument.getDirection().equals((Object)ActionArgument.Direction.OUT)) {
                    outputList.add(argument);
                }
                ++n2;
            }
            this.arguments = arguments;
            this.inputArguments = inputList.toArray(new ActionArgument[inputList.size()]);
            this.outputArguments = outputList.toArray(new ActionArgument[outputList.size()]);
        } else {
            this.arguments = new ActionArgument[0];
            this.inputArguments = new ActionArgument[0];
            this.outputArguments = new ActionArgument[0];
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasArguments() {
        return this.getArguments() != null && this.getArguments().length > 0;
    }

    public ActionArgument[] getArguments() {
        return this.arguments;
    }

    public S getService() {
        return this.service;
    }

    void setService(S service) {
        if (this.service != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.service = service;
    }

    public ActionArgument<S> getFirstInputArgument() {
        if (!this.hasInputArguments()) {
            throw new IllegalStateException("No input arguments: " + String.valueOf(this));
        }
        return this.getInputArguments()[0];
    }

    public ActionArgument<S> getFirstOutputArgument() {
        if (!this.hasOutputArguments()) {
            throw new IllegalStateException("No output arguments: " + String.valueOf(this));
        }
        return this.getOutputArguments()[0];
    }

    public ActionArgument<S>[] getInputArguments() {
        return this.inputArguments;
    }

    public ActionArgument<S> getInputArgument(String name) {
        ActionArgument<S>[] actionArgumentArray = this.getInputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument<S> arg = actionArgumentArray[n2];
            if (arg.isNameOrAlias(name)) {
                return arg;
            }
            ++n2;
        }
        return null;
    }

    public ActionArgument<S>[] getOutputArguments() {
        return this.outputArguments;
    }

    public ActionArgument<S> getOutputArgument(String name) {
        ActionArgument<S>[] actionArgumentArray = this.getOutputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument<S> arg = actionArgumentArray[n2];
            if (arg.getName().equals(name)) {
                return arg;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasInputArguments() {
        return this.getInputArguments() != null && this.getInputArguments().length > 0;
    }

    public boolean hasOutputArguments() {
        return this.getOutputArguments() != null && this.getOutputArguments().length > 0;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ", Arguments: " + String.valueOf(this.getArguments() != null ? Integer.valueOf(this.getArguments().length) : "NO ARGS") + ") " + this.getName();
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getName() == null || this.getName().isEmpty()) {
            errors.add(new ValidationError(this.getClass(), "name", "Action without name of: " + String.valueOf(this.getService())));
        } else if (!ModelUtil.isValidUDAName(this.getName())) {
            SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Invalid action name: {}", new Object[]{this});
        }
        ActionArgument[] actionArgumentArray = this.getArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument actionArgument = actionArgumentArray[n2];
            if (((Service)this.getService()).getStateVariable(actionArgument.getRelatedStateVariableName()) == null) {
                errors.add(new ValidationError(this.getClass(), "arguments", "Action argument references an unknown state variable: " + actionArgument.getRelatedStateVariableName()));
            }
            ++n2;
        }
        ActionArgument retValueArgument = null;
        int retValueArgumentIndex = 0;
        int i = 0;
        ActionArgument[] actionArgumentArray2 = this.getArguments();
        int n3 = actionArgumentArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            ActionArgument actionArgument = actionArgumentArray2[n4];
            if (actionArgument.isReturnValue()) {
                if (actionArgument.getDirection() == ActionArgument.Direction.IN) {
                    SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Input argument can not have <retval/>", new Object[0]);
                } else {
                    if (retValueArgument != null) {
                        SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Only one argument of action '{}' can be <retval/>", new Object[]{this.getName()});
                    }
                    retValueArgument = actionArgument;
                    retValueArgumentIndex = i;
                }
            }
            ++i;
            ++n4;
        }
        if (retValueArgument != null) {
            int j = 0;
            while (j < retValueArgumentIndex) {
                ActionArgument a = this.getArguments()[j];
                if (a.getDirection() == ActionArgument.Direction.OUT) {
                    SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Argument '{}' of action '{}' is <retval/> but not the first OUT argument", new Object[]{retValueArgument.getName(), this.getName()});
                }
                ++j;
            }
        }
        actionArgumentArray2 = this.arguments;
        n3 = this.arguments.length;
        int n5 = 0;
        while (n5 < n3) {
            ActionArgument argument = actionArgumentArray2[n5];
            errors.addAll(argument.validate());
            ++n5;
        }
        return errors;
    }

    public Action<S> deepCopy() {
        ActionArgument[] actionArgumentsDupe = new ActionArgument[this.getArguments().length];
        int i = 0;
        while (i < this.getArguments().length) {
            ActionArgument arg = this.getArguments()[i];
            actionArgumentsDupe[i] = arg.deepCopy();
            ++i;
        }
        return new Action<S>(this.getName(), actionArgumentsDupe);
    }
}

