/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMap;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class PartitionMapType2
extends PartitionMap {
    public RegId partitionTypeIdentifier;
    public int volumeSequenceNumber;
    public int partitionNumber;
    public static final int LENGTH = 64;

    public PartitionMapType2(byte[] byArray) throws InvalidDescriptor {
        super(byArray);
        this.deserialize(byArray);
    }

    private void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 64) {
            throw new InvalidDescriptor("Partition map type 2 too short");
        }
        this.partitionTypeIdentifier = new RegId(UDFUtil.getBytes(byArray, 4, 32));
        this.volumeSequenceNumber = UDFUtil.getUInt16(byArray, 36);
        this.partitionNumber = UDFUtil.getUInt16(byArray, 38);
    }

    @Override
    public String toString() {
        return "PartitionMapType2 [partitionTypeIdentifier=" + this.partitionTypeIdentifier + ", volumeSequenceNumber=" + this.volumeSequenceNumber + ", partitionNumber=" + this.partitionNumber + ", " + super.toString() + "]";
    }
}

