/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowSeasonNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.thesportsdb.TheSportsDbHelper;
import org.tinymediamanager.scraper.thesportsdb.entities.League;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.VSMeta;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;

public class TvShowUpdateDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowUpdateDatasourceTask.class);
    private static final List<String> SKIP_FOLDERS = Arrays.asList(".", "..", "CERTIFICATE", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR", "ADV_OBJ", "EXTRATHUMB", "PLEX VERSIONS");
    private static final String SKIP_REGEX = "^[.][\\w@]+.*";
    private static long preDir = 0L;
    private static long postDir = 0L;
    private static long visFile = 0L;
    private final List<String> dataSources = new ArrayList<String>();
    private final List<Pattern> skipFolders = new ArrayList<Pattern>();
    private final List<TvShow> showsToUpdate = new ArrayList<TvShow>();
    private final TvShowList tvShowList;
    private final Set<Path> filesFound = new HashSet<Path>();
    private final Map<Path, BasicFileAttributes> fileAttributes = new HashMap<Path, BasicFileAttributes>();
    private final ReentrantReadWriteLock fileLock = new ReentrantReadWriteLock();

    public TvShowUpdateDatasourceTask() {
        super(TmmResourceBundle.getString("update.datasource"));
        this.tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        this.dataSources.addAll(TvShowModuleManager.getInstance().getSettings().getTvShowDataSource());
        this.init();
    }

    public TvShowUpdateDatasourceTask(String datasource) {
        super(TmmResourceBundle.getString("update.datasource") + " (" + datasource + ")");
        this.tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        this.dataSources.add(datasource);
        this.init();
    }

    public TvShowUpdateDatasourceTask(Collection<String> datasources) {
        this(datasources, Collections.emptyList());
    }

    public TvShowUpdateDatasourceTask(List<TvShow> tvShowFolders) {
        this(Collections.emptyList(), tvShowFolders);
    }

    private TvShowUpdateDatasourceTask(Collection<String> dataSources, List<TvShow> tvShowFolders) {
        super(TmmResourceBundle.getString("update.datasource"));
        this.tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        this.dataSources.addAll(dataSources);
        this.showsToUpdate.addAll(tvShowFolders);
        this.init();
    }

    private void init() {
        for (String skipFolder : TvShowModuleManager.getInstance().getSettings().getSkipFolder()) {
            try {
                Pattern pattern = Pattern.compile(skipFolder);
                this.skipFolders.add(pattern);
            }
            catch (Exception e) {
                try {
                    LOGGER.debug("no valid skip pattern - '{}'", (Object)skipFolder);
                    Pattern pattern = Pattern.compile(Pattern.quote(skipFolder));
                    this.skipFolders.add(pattern);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.showsToUpdate.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        TvShowUpdateDatasourceTask.resetCounters();
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.start();
            if (this.showsToUpdate.isEmpty()) {
                if (TvShowModuleManager.getInstance().getSettings().isResetNewFlagOnUds()) {
                    for (TvShow tvShow : this.tvShowList.getTvShows()) {
                        tvShow.setNewlyAdded(false);
                        for (TvShowEpisode episode : tvShow.getEpisodes()) {
                            episode.setNewlyAdded(false);
                        }
                    }
                }
                for (String ds : this.dataSources) {
                    Path dsAsPath = Paths.get(ds, new String[0]);
                    if (this.isInSkipFolder(dsAsPath)) {
                        LOGGER.debug("datasource '{}' is also a skipfolder - skipping", (Object)ds);
                        continue;
                    }
                    LOGGER.info("Starting \"update data sources\" on datasource: {}", (Object)ds);
                    this.initThreadPool(3, "update");
                    this.setTaskName(TmmResourceBundle.getString("update.datasource") + " '" + ds + "'");
                    this.publishState();
                    if (!Files.exists(dsAsPath, new LinkOption[0])) {
                        LOGGER.warn("Datasource '{}' not available/empty", (Object)ds);
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    this.publishState();
                    ArrayList<Path> foundTvShowDirs = new ArrayList<Path>();
                    List<Path> rootList = this.listFilesAndDirs(dsAsPath);
                    if (rootList.isEmpty() && !SystemUtils.IS_OS_WINDOWS) {
                        boolean isEmpty = true;
                        try {
                            isEmpty = Utils.isFolderEmpty(dsAsPath);
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Could not check folder '{}' for emptiness - '{}'", (Object)dsAsPath, (Object)exception.getMessage());
                        }
                        if (isEmpty) {
                            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                            continue;
                        }
                    }
                    for (Path path : rootList) {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (path.getFileName().toString().length() == 1) {
                                List<Path> subList = this.listFilesAndDirs(path);
                                for (Path sub : subList) {
                                    if (!Files.isDirectory(sub, new LinkOption[0])) continue;
                                    foundTvShowDirs.add(sub);
                                }
                                continue;
                            }
                            foundTvShowDirs.add(path);
                            continue;
                        }
                        String ext = FilenameUtils.getExtension((String)path.getFileName().toString()).toLowerCase(Locale.ROOT);
                        if (!Settings.getInstance().getVideoFileType().contains("." + ext)) continue;
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.episodeinroot", new String[]{path.getFileName().toString()}));
                    }
                    for (Path path : foundTvShowDirs) {
                        this.submitTask(new FindTvShowTask(path, dsAsPath.toAbsolutePath()));
                    }
                    this.waitForCompletionOrCancel();
                    LOGGER.info("Files found: {}", (Object)this.filesFound.size());
                    LOGGER.info("TV shows found: {}", (Object)this.tvShowList.getTvShowCount());
                    LOGGER.info("Episodes found: {}", (Object)this.tvShowList.getEpisodeCount());
                    LOGGER.debug("PreDir: {}", (Object)preDir);
                    LOGGER.debug("PostDir: {}", (Object)postDir);
                    LOGGER.debug("VisFile: {}", (Object)visFile);
                    if (!this.cancel) {
                        ArrayList<TvShow> toCleanup = new ArrayList<TvShow>();
                        for (TvShow tvShow : new ArrayList<TvShow>(this.tvShowList.getTvShows())) {
                            if (!Paths.get(tvShow.getDataSource(), new String[0]).toAbsolutePath().equals(dsAsPath.toAbsolutePath()) || this.filesFound.contains(tvShow.getPathNIO().toAbsolutePath())) continue;
                            toCleanup.add(tvShow);
                        }
                        this.cleanup(toCleanup);
                        this.waitForCompletionOrCancel();
                        if (!this.cancel) continue;
                    }
                    break;
                }
            } else {
                LOGGER.info("Start \"update data sources\" for selected TV shows");
                this.initThreadPool(3, "update");
                HashSet showDatasources = new HashSet();
                this.showsToUpdate.stream().filter(show -> !show.isLocked()).forEach(show -> showDatasources.add(show.getDataSource()));
                ArrayList<TvShow> showsToCleanup = new ArrayList<TvShow>();
                for (String ds : showDatasources) {
                    Path dsAsPath = Paths.get(ds, new String[0]);
                    if (!Files.exists(dsAsPath, new LinkOption[0])) {
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    List<Path> rootList = this.listFilesAndDirs(dsAsPath);
                    if (rootList.isEmpty() && !SystemUtils.IS_OS_WINDOWS) {
                        boolean bl;
                        boolean bl2 = true;
                        try {
                            bl = Utils.isFolderEmpty(dsAsPath);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not check folder '{}' for emptiness - '{}'", (Object)dsAsPath, (Object)e.getMessage());
                        }
                        if (bl) {
                            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                            continue;
                        }
                    }
                    for (TvShow show2 : this.showsToUpdate) {
                        if (!show2.getDataSource().equals(ds)) continue;
                        showsToCleanup.add(show2);
                        this.submitTask(new FindTvShowTask(show2.getPathNIO(), Paths.get(ds, new String[0])));
                    }
                }
                this.waitForCompletionOrCancel();
                LOGGER.info("Files found: {}", (Object)this.filesFound.size());
                LOGGER.info("TV shows found: {}", (Object)this.tvShowList.getTvShowCount());
                LOGGER.info("Episodes found: {}", (Object)this.tvShowList.getEpisodeCount());
                LOGGER.debug("PreDir: {}", (Object)preDir);
                LOGGER.debug("PostDir: {}", (Object)postDir);
                LOGGER.debug("VisFile: {}", (Object)visFile);
                if (!this.cancel) {
                    this.cleanup(showsToCleanup);
                    this.waitForCompletionOrCancel();
                }
            }
            if (this.cancel) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getKodiHost())) {
                TmmTaskManager.getInstance().addUnnamedTask(() -> KodiRPC.getInstance().updateTvShowMappings());
            }
            LOGGER.info("Getting Mediainfo...");
            this.initThreadPool(2, "mediainfo");
            this.setTaskName(TmmResourceBundle.getString("update.mediainfo"));
            this.setTaskDescription(null);
            this.setWorkUnits(0);
            this.setProgressDone(0);
            this.publishState();
            if (!this.cancel) {
                if (this.showsToUpdate.isEmpty()) {
                    for (i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                        tvShow = this.tvShowList.getTvShows().get(i);
                        if (tvShow.isLocked() || !this.dataSources.contains(tvShow.getDataSource())) continue;
                        this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
                    }
                } else {
                    for (i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                        tvShow = this.tvShowList.getTvShows().get(i);
                        if (tvShow.isLocked() || !this.showsToUpdate.contains(tvShow)) continue;
                        this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
                    }
                }
                this.waitForCompletionOrCancel();
            }
            if (this.cancel) {
                return;
            }
            if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
                TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
                task.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
                task.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            stopWatch.stop();
            LOGGER.info("Finished updating data sources :) - took {} ms", (Object)stopWatch);
            TvShowUpdateDatasourceTask.resetCounters();
        }
        catch (Exception e) {
            LOGGER.error("Could not update data sources for TV shows - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    private void cleanup(List<TvShow> shows) {
        this.setTaskName(TmmResourceBundle.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        int showCount = shows.size();
        this.setWorkUnits(showCount);
        this.publishState();
        LOGGER.info("Removing orphaned TV shows/episodes/files...");
        for (int i = showCount - 1; i >= 0 && !this.cancel; --i) {
            this.publishState(showCount - i);
            TvShow tvShow = shows.get(i);
            if (tvShow.isLocked()) continue;
            if (!Files.exists(tvShow.getPathNIO(), new LinkOption[0])) {
                this.tvShowList.removeTvShow(tvShow);
                continue;
            }
            this.cleanup(tvShow);
        }
    }

    private void cleanup(TvShow tvShow) {
        boolean dirty = false;
        if (!tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes()) {
            boolean fileFound;
            for (MediaFile mf : tvShow.getMediaFiles()) {
                boolean fileFound2 = this.filesFound.contains(mf.getFileAsPath());
                if (fileFound2) continue;
                LOGGER.debug("removing orphaned file: {}", (Object)mf.getFileAsPath());
                tvShow.removeFromMediaFiles(mf);
                if (mf.isGraphic()) {
                    ImageCache.invalidateCachedImage(mf);
                }
                dirty = true;
            }
            for (TvShowSeason season : tvShow.getSeasons()) {
                for (MediaFile mf : season.getMediaFiles()) {
                    fileFound = this.filesFound.contains(mf.getFileAsPath());
                    if (fileFound) continue;
                    LOGGER.debug("removing orphaned file: {}", (Object)mf.getFileAsPath());
                    season.removeFromMediaFiles(mf);
                    if (mf.isGraphic()) {
                        ImageCache.invalidateCachedImage(mf);
                    }
                    dirty = true;
                }
            }
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                for (MediaFile mf : episode.getMediaFiles()) {
                    fileFound = this.filesFound.contains(mf.getFileAsPath());
                    if (fileFound) continue;
                    LOGGER.debug("removing orphaned file: {}", (Object)mf.getFileAsPath());
                    episode.removeFromMediaFiles(mf);
                    if (mf.isGraphic()) {
                        ImageCache.invalidateCachedImage(mf);
                    }
                    dirty = true;
                }
                List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                if (!mfs.isEmpty()) continue;
                tvShow.removeEpisode(episode);
                dirty = true;
            }
            List<MediaFile> episodeFiles = tvShow.getEpisodesMediaFiles();
            ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
            for (MediaFile showFile : tvShow.getMediaFiles()) {
                if (!episodeFiles.contains(showFile)) continue;
                cleanup.add(showFile);
                dirty = true;
            }
            for (MediaFile mf : cleanup) {
                tvShow.removeFromMediaFiles(mf);
                LOGGER.debug("Removed duplicate show file {}", (Object)mf);
            }
        }
        if (dirty) {
            tvShow.saveToDb();
        }
    }

    private void gatherMediaInformationForUngatheredMediaFiles(TvShow tvShow) {
        Consumer<MediaFile> processMediaFile = mf -> {
            if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                this.submitTask(new TvShowMediaFileInformationFetcherTask((MediaFile)mf, tvShow, false));
            } else if (MediaFileHelper.gatherBasicFileInformation(mf, this.fileAttributes.get(mf.getFileAsPath()))) {
                if (mf.getType() == MediaFileType.VIDEO) {
                    tvShow.getMediaFiles(MediaFileType.MEDIAINFO).forEach(mediaFile -> {
                        Utils.deleteFileSafely(mediaFile.getFileAsPath());
                        tvShow.removeFromMediaFiles((MediaFile)mediaFile);
                    });
                }
                this.submitTask(new TvShowMediaFileInformationFetcherTask((MediaFile)mf, tvShow, true));
            }
        };
        tvShow.getMediaFiles().forEach(processMediaFile);
        for (TvShowSeason season : new ArrayList<TvShowSeason>(tvShow.getSeasons())) {
            season.getMediaFiles().forEach(processMediaFile);
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
            episode.getMediaFiles().forEach(processMediaFile);
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private List<Path> listFilesAndDirs(Path directory) {
        List<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                if (this.isInSkipFolder(path)) {
                    LOGGER.debug("Skipping: {}", (Object)path);
                    continue;
                }
                fileNames.add(path.toAbsolutePath());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while getting a file listing of '{}' - '{}'", (Object)directory, (Object)e.getMessage());
            LOGGER.debug("could not list files in normal way", (Throwable)e);
            fileNames = this.listFilesAndDirs2(directory);
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    private boolean isInSkipFolder(Path dir) {
        if (dir == null || dir.getFileName() == null) {
            return false;
        }
        String dirName = dir.getFileName().toString();
        String dirNameUppercase = dirName.toUpperCase(Locale.ROOT);
        String fullPath = dir.toAbsolutePath().toString();
        if (SKIP_FOLDERS.contains(dirNameUppercase) || dirName.matches(SKIP_REGEX)) {
            return true;
        }
        for (Pattern pattern : this.skipFolders) {
            Matcher matcher = pattern.matcher(dirName);
            if (matcher.matches()) {
                return true;
            }
            if (!pattern.toString().replace("\\Q", "").replace("\\E", "").equals(fullPath)) continue;
            return true;
        }
        return false;
    }

    private List<Path> listFilesAndDirs2(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (Stream<Path> directoryStream = Files.walk(directory, 1, FileVisitOption.FOLLOW_LINKS);){
            List<Path> allElements = directoryStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList();
            for (Path path : allElements) {
                if (directory.toAbsolutePath().equals(path.toAbsolutePath())) continue;
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(SKIP_FOLDERS.contains(fn) || fn.matches(SKIP_REGEX) || this.isInSkipFolder(path))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: {}", (Object)path);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while getting a file listing of '{}' (alternate way) - '{}'", (Object)directory, (Object)e.getMessage());
            LOGGER.debug("could not list files in alternate way", (Throwable)e);
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    private static void resetCounters() {
        visFile = 0L;
        preDir = 0L;
        postDir = 0L;
    }

    private static synchronized void incVisFile() {
        ++visFile;
    }

    private static synchronized void incPreDir() {
        ++preDir;
    }

    private static synchronized void incPostDir() {
        ++postDir;
    }

    private class FindTvShowTask
    implements Callable<Object> {
        private final Path showDir;
        private final Path datasource;
        private final long uniqueId;
        private final List<Pattern> extraMfFiletypePatterns;

        public FindTvShowTask(Path showDir, Path datasource) {
            this.showDir = showDir;
            this.datasource = datasource;
            this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
            this.extraMfFiletypePatterns = new ArrayList<Pattern>();
            for (String extr : MediaFileHelper.EXTRA_FOLDERS) {
                this.extraMfFiletypePatterns.add(Pattern.compile("(?i)[_.-]" + extr + "\\d?[.].{2,4}"));
            }
        }

        @Override
        public String call() throws Exception {
            Object name = Thread.currentThread().getName();
            if (!((String)name).contains("-G")) {
                name = (String)name + "-G0";
            }
            name = ((String)name).replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName((String)name);
            if (this.showDir.getFileName().toString().matches(TvShowUpdateDatasourceTask.SKIP_REGEX)) {
                LOGGER.debug("Skipping dir: {}", (Object)this.showDir);
                return "";
            }
            TvShow tvShow = TvShowUpdateDatasourceTask.this.tvShowList.getTvShowByPath(this.showDir);
            if (tvShow != null && tvShow.isLocked()) {
                LOGGER.warn("TV show '{}' found in \"update data source\", but is locked", (Object)tvShow.getPath());
                return "";
            }
            Set<Path> allFiles = this.getAllFilesRecursive(this.showDir);
            if (allFiles.isEmpty()) {
                LOGGER.debug("Skip empty directory: {}", (Object)this.showDir);
                return "";
            }
            if (TvShowUpdateDatasourceTask.this.cancel) {
                return null;
            }
            LOGGER.debug("start parsing {}", (Object)this.showDir);
            TvShowUpdateDatasourceTask.this.publishState(this.showDir.toString());
            TvShowUpdateDatasourceTask.this.fileLock.writeLock().lock();
            TvShowUpdateDatasourceTask.this.filesFound.add(this.showDir.toAbsolutePath());
            TvShowUpdateDatasourceTask.this.filesFound.addAll(allFiles);
            TvShowUpdateDatasourceTask.this.fileLock.writeLock().unlock();
            ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
            for (Path file : allFiles) {
                if (file.getFileName().toString().matches(TvShowUpdateDatasourceTask.SKIP_REGEX)) continue;
                MediaFile mediaFile2 = new MediaFile(file);
                mfs.add(mediaFile2);
            }
            allFiles.clear();
            Collections.sort(mfs);
            if (this.getMediaFiles(mfs, MediaFileType.VIDEO).isEmpty()) {
                LOGGER.debug("no video file found in directory {}", (Object)this.showDir);
                return "";
            }
            MediaFile showNFO = new MediaFile(this.showDir.resolve("tvshow.nfo"), MediaFileType.NFO);
            if (tvShow == null) {
                if (Files.exists(showNFO.getFileAsPath(), new LinkOption[0])) {
                    try {
                        TvShowNfoParser parser = TvShowNfoParser.parseNfo(showNFO.getFileAsPath());
                        tvShow = parser.toTvShow();
                    }
                    catch (Exception e) {
                        LOGGER.debug("problem parsing NFO: {}", (Object)e.getMessage());
                    }
                }
                if (tvShow == null) {
                    tvShow = new TvShow();
                }
                if (StringUtils.isBlank((CharSequence)tvShow.getTitle()) || tvShow.getYear() <= 0) {
                    String[] ty = ParserUtils.detectCleanTitleAndYear(this.showDir.getFileName().toString(), TvShowModuleManager.getInstance().getSettings().getBadWord());
                    if (StringUtils.isBlank((CharSequence)tvShow.getTitle()) && StringUtils.isNotBlank((CharSequence)ty[0])) {
                        tvShow.setTitle(ty[0]);
                    }
                    if (tvShow.getYear() <= 0 && !ty[1].isEmpty()) {
                        try {
                            tvShow.setYear(Integer.parseInt(ty[1]));
                        }
                        catch (Exception exception) {
                            LOGGER.trace("could not parse int: {}", (Object)exception.getMessage());
                        }
                    }
                }
                if ((tvShow.getImdbId().isEmpty() || tvShow.getTmdbId() == 0) && Files.exists(showNFO.getFileAsPath(), new LinkOption[0])) {
                    try {
                        String content = Utils.readFileToString(showNFO.getFileAsPath());
                        String string = ParserUtils.detectImdbId(content);
                        if (!string.isEmpty()) {
                            LOGGER.debug("| Found IMDB id: {}", (Object)string);
                            tvShow.setImdbId(string);
                        }
                        String tmdb = StrgUtils.substr(content, "themoviedb\\.org\\/tv\\/(\\d+)");
                        if (tvShow.getTmdbId() == 0 && !tmdb.isEmpty()) {
                            LOGGER.debug("| Found TMDB id: {}", (Object)tmdb);
                            tvShow.setTmdbId(MetadataUtil.parseInt(tmdb, 0));
                        }
                        String tvdb = StrgUtils.substr(content, "thetvdb\\.com\\/series\\/(\\d+)");
                        if (tvShow.getTvdbId().isEmpty() && !tvdb.isEmpty()) {
                            LOGGER.debug("| Found TVDB id: {}", (Object)tmdb);
                            tvShow.setTvdbId(tvdb);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.debug("| couldn't read NFO {}", (Object)showNFO);
                    }
                }
                tvShow.setPath(this.showDir.toAbsolutePath().toString());
                tvShow.setDataSource(this.datasource.toString());
                tvShow.setNewlyAdded(true);
                TvShowUpdateDatasourceTask.this.tvShowList.addTvShow(tvShow);
            }
            if (!MediaIdUtil.isValidImdbId(tvShow.getImdbId())) {
                tvShow.setId("imdb", ParserUtils.detectImdbId(this.showDir.getFileName().toString()));
            }
            if (tvShow.getTmdbId() == 0) {
                tvShow.setId("tmdb", ParserUtils.detectTmdbId(this.showDir.getFileName().toString()));
            }
            if (tvShow.getTvdbId().isEmpty()) {
                tvShow.setId("tvdb", ParserUtils.detectTvdbId(this.showDir.getFileName().toString()));
            }
            if (TheSportsDbHelper.SPORT_LEAGUES.containsKey(tvShow.getPathNIO().getFileName().toString())) {
                League l = TheSportsDbHelper.SPORT_LEAGUES.get(tvShow.getPathNIO().getFileName().toString());
                tvShow.setId("tsdb", l.idLeague);
            }
            for (MediaFile mediaFile3 : this.getMediaFiles(mfs, MediaFileType.NFO)) {
                Matcher matcher = Utils.SEASON_NFO_PATTERN.matcher(mediaFile3.getFilename());
                if (!matcher.matches()) continue;
                TvShowSeasonNfoParser parser = TvShowSeasonNfoParser.parseNfo(mediaFile3.getFileAsPath());
                if (parser.season <= -1) continue;
                TvShowSeason tvShowSeason2 = tvShow.getOrCreateSeason(parser.season);
                tvShowSeason2.merge(parser.toTvShowSeason());
                tvShowSeason2.addToMediaFiles(mediaFile3);
            }
            HashSet<Path> discFolders = new HashSet<Path>();
            for (MediaFile vid : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                List<TvShowEpisode> episodes;
                if (TvShowUpdateDatasourceTask.this.cancel) {
                    return null;
                }
                List<MediaFile> epFiles = new ArrayList<MediaFile>();
                if (vid.isDiscFile()) {
                    Path discRoot = vid.getFileAsPath().toAbsolutePath();
                    if (!discRoot.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                        discRoot = discRoot.getParent();
                    }
                    if (discFolders.contains(discRoot)) continue;
                    discFolders.add(discRoot);
                    for (MediaFile em : mfs) {
                        if (!em.getFileAsPath().startsWith(discRoot) || em.getType() == MediaFileType.UNKNOWN) continue;
                        epFiles.add(em);
                    }
                } else {
                    Object vidBasename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(vid.getFilename()));
                    vidBasename = this.showDir.relativize(vid.getFileAsPath().getParent()) + "/" + (String)vidBasename;
                    LOGGER.trace("UDS: video basename {} - {}", vidBasename, (Object)vid.getFile());
                    for (MediaFile other : mfs) {
                        Object imgBasename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(this.getMediaFileNameWithoutType(other)));
                        imgBasename = this.showDir.relativize(other.getFileAsPath().getParent()) + "/" + (String)imgBasename;
                        if (!((String)vidBasename).equalsIgnoreCase((String)imgBasename)) continue;
                        if (other.getType() == MediaFileType.POSTER || other.getType() == MediaFileType.GRAPHIC) {
                            other.setType(MediaFileType.THUMB);
                        }
                        epFiles.add(other);
                        LOGGER.trace("UDS: found matching {} - {}", imgBasename, (Object)other.getFile());
                    }
                }
                if ((episodes = TvShowList.getTvEpisodesByFile(tvShow, vid.getFile())).isEmpty()) {
                    List<TvShowEpisode> eps;
                    Path discRoot;
                    MediaFile meta = this.getMediaFile(epFiles, MediaFileType.VSMETA);
                    TvShowEpisode vsMetaEP = null;
                    if (meta != null) {
                        VSMeta vsmeta = new VSMeta(meta.getFileAsPath());
                        vsmeta.parseFile();
                        vsMetaEP = vsmeta.getTvShowEpisode();
                    }
                    Object xmlEP = null;
                    for (MediaFile xmlMf : epFiles) {
                        if (!"xml".equalsIgnoreCase(xmlMf.getExtension()) || xmlMf.getFilename().endsWith("mediainfo.xml")) continue;
                        try {
                            TvShowEpisodeNfoParser nfoParser = TvShowEpisodeNfoParser.parseNfo(xmlMf.getFileAsPath());
                            List<TvShowEpisode> epsInXml = nfoParser.toTvShowEpisodes();
                            if (epsInXml.isEmpty()) continue;
                            xmlEP = epsInXml.get(0);
                        }
                        catch (Exception nfoParser) {}
                    }
                    MediaFile epNfo = this.getMediaFile(epFiles = epFiles.stream().filter(mediaFile -> mediaFile.getType() != MediaFileType.UNKNOWN).collect(Collectors.toList()), MediaFileType.NFO);
                    if (epNfo != null) {
                        LOGGER.debug("found episode NFO - try to parse '{}'", (Object)this.showDir.relativize(epNfo.getFileAsPath()));
                        ArrayList<TvShowEpisode> episodesInNfo = new ArrayList<TvShowEpisode>();
                        try {
                            boolean allUnknown;
                            TvShowEpisodeNfoParser parser = TvShowEpisodeNfoParser.parseNfo(epNfo.getFileAsPath());
                            boolean bl = allUnknown = !parser.episodes.isEmpty() && parser.episodes.stream().allMatch(ep -> ep.episode == -1);
                            if (allUnknown) {
                                TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilename(this.showDir.relativize(epNfo.getFileAsPath()).toString(), tvShow.getTitle());
                                if (parser.episodes.size() == result.episodes.size()) {
                                    int i = 0;
                                    for (TvShowEpisodeNfoParser.Episode ep2 : parser.episodes) {
                                        ep2.episode = result.episodes.get(i);
                                        ep2.season = result.season;
                                        ++i;
                                    }
                                }
                            }
                            if (parser.isValidNfo()) {
                                episodesInNfo.addAll(parser.toTvShowEpisodes());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("could not parse episode NFO: {}", (Object)e.getMessage());
                        }
                        if (!episodesInNfo.isEmpty()) {
                            for (TvShowEpisode episode : episodesInNfo) {
                                episode.setPath(vid.getPath());
                                episode.setTvShow(tvShow);
                                if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                                    episode.setMediaSource(MediaSource.parseMediaSource(vid.getBasename()));
                                }
                                episode.setNewlyAdded(true);
                                if (StringUtils.isBlank((CharSequence)episode.getOriginalFilename())) {
                                    episode.setOriginalFilename(vid.getFilename());
                                }
                                episode.addToMediaFiles(vid);
                                for (MediaFile mediaFile2 : epFiles) {
                                    if (mediaFile2.getType() == MediaFileType.VIDEO && mediaFile2.getBasename().equals(vid.getBasename())) continue;
                                    episode.addToMediaFiles(mediaFile2);
                                }
                                if (vid.isDiscFile()) {
                                    episode.setDisc(true);
                                    discRoot = vid.getFileAsPath().toAbsolutePath();
                                    if (discRoot.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                                        discRoot = discRoot.getParent();
                                        episode.setPath(discRoot.toString());
                                    } else if (discRoot.getParent().getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                                        discRoot = discRoot.getParent();
                                        episode.setPath(discRoot.toString());
                                    }
                                }
                                if (episodesInNfo.size() > 1) {
                                    episode.setMultiEpisode(true);
                                } else {
                                    episode.setMultiEpisode(false);
                                }
                                episode.merge(vsMetaEP);
                                episode.merge((TvShowEpisode)xmlEP);
                                episode.saveToDb();
                                tvShow.addEpisode(episode);
                            }
                            continue;
                        }
                    }
                    String relativePath = this.showDir.relativize(vid.getFileAsPath()).toString();
                    TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilename(relativePath, tvShow.getTitle());
                    if (result.episodes.size() == 1 && result.season > -1 && result.stackingMarkerFound && !(eps = tvShow.getEpisode(result.season, result.episodes.get(0))).isEmpty()) {
                        boolean found = false;
                        for (TvShowEpisode ep3 : eps) {
                            String mfBasenameWoStackingMarker;
                            String episodeBasenameWoStackingMarker = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(ep3.getMainVideoFile().getFilename()));
                            if (!episodeBasenameWoStackingMarker.equals(mfBasenameWoStackingMarker = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(vid.getFilename())))) continue;
                            if (ep3.getMediaSource() == MediaSource.UNKNOWN) {
                                ep3.setMediaSource(MediaSource.parseMediaSource(ep3.getMainVideoFile().getBasename()));
                            }
                            ep3.setNewlyAdded(true);
                            if (StringUtils.isBlank((CharSequence)ep3.getOriginalFilename())) {
                                ep3.setOriginalFilename(vid.getFilename());
                            }
                            ep3.addToMediaFiles(vid);
                            found = true;
                            break;
                        }
                        if (found) continue;
                    }
                    if (!result.episodes.isEmpty()) {
                        for (int ep4 : result.episodes) {
                            TvShowEpisode episode = new TvShowEpisode();
                            if (tvShow.getEpisodeGroup() != null) {
                                episode.setEpisode(new MediaEpisodeNumber(tvShow.getEpisodeGroup(), result.season, ep4));
                            } else {
                                episode.setEpisode(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, result.season, ep4));
                            }
                            episode.setFirstAired(result.date);
                            if (result.name.isEmpty()) {
                                result.name = FilenameUtils.getBaseName((String)vid.getFilename());
                            }
                            episode.setTitle(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(result.name, tvShow.getTitle()));
                            episode.setPath(vid.getPath());
                            episode.setTvShow(tvShow);
                            episode.addToMediaFiles(epFiles);
                            if (!MediaIdUtil.isValidImdbId(episode.getImdbId())) {
                                episode.setId("imdb", ParserUtils.detectImdbId(Utils.relPath(this.showDir, vid.getFileAsPath())));
                            }
                            if (episode.getTmdbId().isEmpty()) {
                                episode.setId("tmdb", ParserUtils.detectTmdbId(Utils.relPath(this.showDir, vid.getFileAsPath())));
                            }
                            if (episode.getTvdbId().isEmpty()) {
                                episode.setId("tvdb", ParserUtils.detectTvdbId(Utils.relPath(this.showDir, vid.getFileAsPath())));
                            }
                            if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                                episode.setMediaSource(MediaSource.parseMediaSource(vid.getBasename()));
                            }
                            episode.setNewlyAdded(true);
                            if (StringUtils.isBlank((CharSequence)episode.getOriginalFilename())) {
                                episode.setOriginalFilename(vid.getFilename());
                            }
                            if (vid.isDiscFile()) {
                                episode.setDisc(true);
                                Path discRoot2 = vid.getFileAsPath().toAbsolutePath();
                                if (discRoot2.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                                    discRoot2 = discRoot2.getParent();
                                    episode.setPath(discRoot2.toString());
                                } else if (discRoot2.getParent().getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                                    discRoot2 = discRoot2.getParent();
                                    episode.setPath(discRoot2.toString());
                                }
                            }
                            if (result.episodes.size() > 1) {
                                episode.setMultiEpisode(true);
                            } else {
                                episode.setMultiEpisode(false);
                            }
                            episode.merge(vsMetaEP);
                            if (xmlEP != null && StringUtils.isNotBlank((CharSequence)((MediaEntity)xmlEP).getTitle())) {
                                episode.merge((TvShowEpisode)xmlEP);
                                episode.setTitle(((MediaEntity)xmlEP).getTitle());
                            }
                            episode.saveToDb();
                            tvShow.addEpisode(episode);
                        }
                        continue;
                    }
                    TvShowEpisode episode = new TvShowEpisode();
                    episode.setPath(vid.getPath());
                    if (vid.isDiscFile()) {
                        episode.setDisc(true);
                        discRoot = vid.getFileAsPath().toAbsolutePath();
                        if (discRoot.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                            discRoot = discRoot.getParent();
                            episode.setPath(discRoot.toString());
                        } else if (discRoot.getParent().getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                            discRoot = discRoot.getParent();
                            episode.setPath(discRoot.toString());
                        }
                    }
                    episode.setTitle(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(FilenameUtils.getBaseName((String)vid.getFilename()), tvShow.getTitle()));
                    episode.setTvShow(tvShow);
                    if (result.date != null) {
                        episode.setFirstAired(result.date);
                        episode.setEpisode(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, result.season, -1));
                    }
                    episode.addToMediaFiles(epFiles);
                    if (!MediaIdUtil.isValidImdbId(episode.getImdbId())) {
                        episode.setId("imdb", ParserUtils.detectImdbId(Utils.relPath(this.showDir, vid.getFileAsPath())));
                    }
                    if (episode.getTmdbId().isEmpty()) {
                        episode.setId("tmdb", ParserUtils.detectTmdbId(Utils.relPath(this.showDir, vid.getFileAsPath())));
                    }
                    if (episode.getTvdbId().isEmpty()) {
                        episode.setId("tvdb", ParserUtils.detectTvdbId(Utils.relPath(this.showDir, vid.getFileAsPath())));
                    }
                    if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                        episode.setMediaSource(MediaSource.parseMediaSource(vid.getBasename()));
                    }
                    episode.setNewlyAdded(true);
                    if (StringUtils.isBlank((CharSequence)episode.getOriginalFilename())) {
                        episode.setOriginalFilename(vid.getFilename());
                    }
                    episode.merge(vsMetaEP);
                    if (xmlEP != null && StringUtils.isNotBlank((CharSequence)((MediaEntity)xmlEP).getTitle())) {
                        episode.merge((TvShowEpisode)xmlEP);
                        episode.setTitle(((MediaEntity)xmlEP).getTitle());
                    }
                    episode.saveToDb();
                    tvShow.addEpisode(episode);
                    continue;
                }
                for (TvShowEpisode episode : episodes) {
                    for (MediaFile mf : epFiles) {
                        if (mf.getType() == MediaFileType.VIDEO && mf.getBasename().equals(vid.getBasename())) continue;
                        episode.addToMediaFiles(mf);
                    }
                    episode.setDisc(vid.isDiscFile());
                    if (episodes.size() > 1) {
                        episode.setMultiEpisode(true);
                    } else {
                        episode.setMultiEpisode(false);
                    }
                    episode.saveToDb();
                }
            }
            mfs.removeAll(tvShow.getEpisodesMediaFiles());
            for (TvShowSeason season : tvShow.getSeasons()) {
                mfs.removeAll(season.getMediaFiles());
            }
            for (MediaFile mf : mfs) {
                Object tvShowSeason3;
                if (mf.getType() == MediaFileType.POSTER && !mf.getPath().equals(tvShow.getPath())) {
                    mf.setType(MediaFileType.SEASON_POSTER);
                }
                if (mf.getType() == MediaFileType.SEASON_POSTER || mf.getType() == MediaFileType.SEASON_FANART || mf.getType() == MediaFileType.SEASON_BANNER || mf.getType() == MediaFileType.SEASON_THUMB) {
                    String foldername = tvShow.getPathNIO().relativize(mf.getFileAsPath().getParent()).toString();
                    int season = TvShowHelpers.detectSeasonFromFileAndFolder(mf.getFilename(), foldername);
                    if (season == Integer.MIN_VALUE) continue;
                    tvShowSeason3 = tvShow.getOrCreateSeason(season);
                    ((MediaEntity)tvShowSeason3).addToMediaFiles(mf);
                    continue;
                }
                String relativePath = this.showDir.relativize(mf.getFileAsPath()).toString();
                TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilename(relativePath, tvShow.getTitle());
                if (result.season <= -1 || result.episodes.isEmpty()) continue;
                tvShowSeason3 = result.episodes.iterator();
                block25: while (tvShowSeason3.hasNext()) {
                    int epnr = (Integer)tvShowSeason3.next();
                    List<TvShowEpisode> eps = tvShow.getEpisode(result.season, epnr);
                    if (eps.size() == 1) {
                        eps.get(0).addToMediaFiles(mf);
                        continue;
                    }
                    if (eps.size() <= 1) continue;
                    for (TvShowEpisode ep5 : eps) {
                        String episodeBasenameWoStackingMarker = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(ep5.getMainVideoFile().getFilename()));
                        if (FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename())).startsWith(episodeBasenameWoStackingMarker)) {
                            ep5.addToMediaFiles(mf);
                            continue block25;
                        }
                        if (!episodeBasenameWoStackingMarker.equals(mf.getFileAsPath().getParent().getFileName().toString())) continue;
                        ep5.addToMediaFiles(mf);
                        continue block25;
                    }
                }
            }
            mfs.removeAll(tvShow.getEpisodesMediaFiles());
            tvShow.getSeasons().forEach(tvShowSeason -> mfs.removeAll(tvShowSeason.getMediaFiles()));
            tvShow.addToMediaFiles(mfs);
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.reEvaluateDiscfolder();
                episode.reEvaluateStacking();
                episode.saveToDb();
            }
            if (!TvShowModuleManager.getInstance().getSettings().isExtractArtworkFromVsmeta()) {
                boolean bl = tvShow.getMediaFiles(MediaFileType.POSTER).isEmpty();
                boolean missingTvShowFanarts = tvShow.getMediaFiles(MediaFileType.FANART).isEmpty();
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    boolean bl2;
                    boolean ok;
                    List<MediaFile> episodeVsmetas = episode.getMediaFiles(MediaFileType.VSMETA);
                    if (episodeVsmetas.isEmpty()) continue;
                    if (episode.getMediaFiles(MediaFileType.THUMB).isEmpty() && !TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames().isEmpty()) {
                        LOGGER.debug("extracting episode THUMBs from VSMETA for {}", (Object)episode.getMainFile().getFileAsPath());
                        ok = TvShowArtworkHelper.extractArtworkFromVsmeta(episode, episodeVsmetas.get(0), MediaArtwork.MediaArtworkType.THUMB);
                        if (ok) {
                            episode.saveToDb();
                        }
                    }
                    if (missingTvShowFanarts && !TvShowModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                        LOGGER.debug("extracting TV show FANARTs from VSMETA for {}", (Object)episode.getMainFile().getFileAsPath());
                        ok = TvShowArtworkHelper.extractArtworkFromVsmeta(tvShow, episodeVsmetas.get(0), MediaArtwork.MediaArtworkType.BACKGROUND);
                        if (ok) {
                            missingTvShowFanarts = false;
                        }
                    }
                    if (!bl2 || TvShowModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) continue;
                    LOGGER.debug("extracting TV show POSTERs from VSMETA for {}", (Object)episode.getMainFile().getFileAsPath());
                    ok = TvShowArtworkHelper.extractArtworkFromVsmeta(tvShow, episodeVsmetas.get(0), MediaArtwork.MediaArtworkType.POSTER);
                    if (!ok) continue;
                    bl2 = false;
                }
            }
            tvShow.saveToDb();
            TvShowUpdateDatasourceTask.this.cleanup(tvShow);
            return this.showDir.getFileName().toString();
        }

        private String getMediaFileNameWithoutType(MediaFile mf) {
            String ret = mf.getFilename();
            String ext = mf.getExtension();
            ret = Strings.CI.replace(ret, "-" + mf.getType() + "." + ext, "." + ext);
            ret = Strings.CI.replace(ret, "." + mf.getType() + "." + ext, "." + ext);
            ret = Strings.CI.replace(ret, "_" + mf.getType() + "." + ext, "." + ext);
            for (Pattern pattern : this.extraMfFiletypePatterns) {
                ret = pattern.matcher(ret).replaceFirst("." + ext);
            }
            return ret;
        }

        private MediaFile getMediaFile(List<MediaFile> mfs, MediaFileType ... types) {
            MediaFile mf = null;
            for (MediaFile mediaFile : mfs) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                mf = new MediaFile(mediaFile);
            }
            return mf;
        }

        private List<MediaFile> getMediaFiles(List<MediaFile> mfs, MediaFileType ... types) {
            ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
            for (MediaFile mediaFile : mfs) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                mf.add(new MediaFile(mediaFile));
            }
            return mf;
        }

        private Set<Path> getAllFilesRecursive(Path path) {
            Path folder = path.toAbsolutePath();
            AllFilesRecursive visitor = new AllFilesRecursive();
            try {
                Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ArrayList filesFound = new ArrayList();
            visitor.filesPerDir.forEach((key, value) -> filesFound.addAll(value));
            return new TreeSet<Path>(filesFound);
        }
    }

    private class TvShowMediaFileInformationFetcherTask
    extends MediaFileInformationFetcherTask {
        public TvShowMediaFileInformationFetcherTask(MediaFile mediaFile, MediaEntity mediaEntity, boolean forceUpdate) {
            super(mediaFile, mediaEntity, forceUpdate);
        }

        @Override
        public void run() {
            TvShowUpdateDatasourceTask.this.publishState(this.mediaEntity.getTitle() + " - " + this.mediaFile.getFilename());
            super.run();
        }
    }

    private class AllFilesRecursive
    extends AbstractFileVisitor {
        private final List<String> skipFiles;
        final Map<Path, List<Path>> filesPerDir = new HashMap<Path, List<Path>>();

        public AllFilesRecursive() {
            this.skipFiles = new ArrayList<String>(Utils.SKIP_FILES);
            if (!TvShowModuleManager.getInstance().getSettings().isSkipFoldersWithNomedia()) {
                this.skipFiles.remove(".nomedia");
            }
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attr) {
            if (TvShowUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            if (file.getFileName() == null) {
                return FileVisitResult.CONTINUE;
            }
            TvShowUpdateDatasourceTask.this.fileLock.writeLock().lock();
            TvShowUpdateDatasourceTask.this.fileAttributes.put(file, attr);
            TvShowUpdateDatasourceTask.this.fileLock.writeLock().unlock();
            try {
                String filename = file.getFileName().toString();
                Path parent = file.getParent();
                List<Path> filesInCurrentDir = this.filesPerDir.get(parent);
                if (this.skipFiles.contains(filename)) {
                    filesInCurrentDir.add(file.toAbsolutePath());
                    return FileVisitResult.SKIP_SIBLINGS;
                }
                TvShowUpdateDatasourceTask.incVisFile();
                String path = "";
                if (parent != null && parent.getFileName() != null) {
                    path = parent.getFileName().toString();
                }
                if (Utils.isRegularFile(attr) && path.matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                    if (FilenameUtils.getExtension((String)filename).equalsIgnoreCase("nfo")) {
                        filesInCurrentDir.add(file.toAbsolutePath());
                    }
                    return FileVisitResult.CONTINUE;
                }
                if (MediaFileHelper.isMainDiscIdentifierFile(filename)) {
                    filesInCurrentDir.add(file.toAbsolutePath());
                    return FileVisitResult.CONTINUE;
                }
                if (Utils.isRegularFile(attr) && !filename.matches(TvShowUpdateDatasourceTask.SKIP_REGEX)) {
                    filesInCurrentDir.add(file.toAbsolutePath());
                    return FileVisitResult.CONTINUE;
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not analyze file '{}' - '{}'", (Object)file.toAbsolutePath(), (Object)e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
            if (TvShowUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            TvShowUpdateDatasourceTask.incPreDir();
            this.filesPerDir.put(dir, new ArrayList());
            try {
                if (dir.getFileName() != null && TvShowUpdateDatasourceTask.this.isInSkipFolder(dir)) {
                    LOGGER.debug("Skipping dir: {}", (Object)dir);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (dir.getFileName() != null && dir.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                    this.filesPerDir.get(dir).add(dir);
                    return FileVisitResult.CONTINUE;
                }
                if (dir.getParent() != null && dir.getParent().getFileName() != null && dir.getParent().getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not analyze folder '{}' - '{}'", (Object)dir.toAbsolutePath(), (Object)e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (TvShowUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            List<Path> filesInCurrentDir = this.filesPerDir.get(dir);
            boolean skipFound = false;
            for (Path file : ListUtils.nullSafe(filesInCurrentDir)) {
                if (!this.skipFiles.contains(file.getFileName().toString())) continue;
                skipFound = true;
                break;
            }
            if (skipFound) {
                TreeSet<Path> keys = new TreeSet<Path>(this.filesPerDir.keySet());
                for (Path key : keys) {
                    if (!key.startsWith(dir)) continue;
                    this.filesPerDir.remove(key);
                }
            }
            TvShowUpdateDatasourceTask.incPostDir();
            return FileVisitResult.CONTINUE;
        }
    }
}

