/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mpdbtv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mpdbtv.MpdbMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.entities.DiscArt;
import org.tinymediamanager.scraper.mpdbtv.entities.Fanart;
import org.tinymediamanager.scraper.mpdbtv.entities.HDClearArt;
import org.tinymediamanager.scraper.mpdbtv.entities.HDLogo;
import org.tinymediamanager.scraper.mpdbtv.entities.Languages;
import org.tinymediamanager.scraper.mpdbtv.entities.MovieEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.Poster;
import org.tinymediamanager.scraper.mpdbtv.services.MpdbController;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import retrofit2.Response;

public class MpdbMovieArtworkMetadataProvider
extends MpdbMetadataProvider
implements IMovieArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpdbMovieArtworkMetadataProvider.class);
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    public MpdbMovieArtworkMetadataProvider() {
        this.controller = new MpdbController();
    }

    @Override
    protected String getSubId() {
        return "movie_artwork";
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        Languages language;
        MediaArtwork mediaArtwork;
        this.initAPI();
        MovieEntity scrapeResult = null;
        ArrayList<MediaArtwork> ma = new ArrayList<MediaArtwork>();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getAboKey(), this.getUserName()})) {
            return Collections.emptyList();
        }
        options.setLanguage(MediaLanguages.fr);
        int id = options.getIdAsIntOrDefault(this.providerInfo.getId(), 0);
        if (id == 0) {
            return Collections.emptyList();
        }
        LOGGER.debug("========= BEGIN MPDB.tv artwork scraping");
        try {
            Response<MovieEntity> response = this.controller.getScrapeInformation(this.getEncodedUserName(), this.getSubscriptionKey(), id, options.getLanguage().toLocale(), null, "json");
            if (!response.isSuccessful()) {
                String message = "";
                try {
                    message = response.errorBody().string();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOGGER.debug("request was not successful: HTTP/{} - {}", (Object)response.code(), (Object)message);
                throw new HttpException(response.code(), response.message());
            }
            if (response.isSuccessful()) {
                scrapeResult = (MovieEntity)response.body();
            }
        }
        catch (HttpException e) {
            LOGGER.debug("nothing found");
            if (e.getStatusCode() == 404) {
                return Collections.emptyList();
            }
            throw new ScrapeException(e);
        }
        catch (Exception e) {
            LOGGER.debug("error searching: {} ", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (scrapeResult == null) {
            LOGGER.debug("no result from MPDB.tv");
            return Collections.emptyList();
        }
        for (Poster poster : ListUtils.nullSafe(scrapeResult.posters)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            mediaArtwork.setPreviewUrl(poster.preview);
            mediaArtwork.setOriginalUrl(poster.original);
            mediaArtwork.setLikes(poster.votes);
            mediaArtwork.addImageSize(poster.width, poster.height, poster.original, MediaArtwork.PosterSizes.getSizeOrder(poster.width));
            if (!poster.languages.isEmpty()) {
                language = poster.languages.get(0);
                mediaArtwork.setLanguage(LanguageUtils.getIso2LanguageFromLocalizedString(language.language));
            }
            ma.add(mediaArtwork);
        }
        for (Fanart fanart : ListUtils.nullSafe(scrapeResult.fanarts)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
            mediaArtwork.setPreviewUrl(fanart.preview);
            mediaArtwork.setOriginalUrl(fanart.original);
            mediaArtwork.setLikes(fanart.votes);
            mediaArtwork.addImageSize(fanart.width, fanart.height, fanart.original, MediaArtwork.FanartSizes.getSizeOrder(fanart.width));
            if (!fanart.languages.isEmpty()) {
                language = fanart.languages.get(0);
                mediaArtwork.setLanguage(LanguageUtils.getIso2LanguageFromLocalizedString(language.language));
            }
            ma.add(mediaArtwork);
        }
        for (DiscArt discArt : ListUtils.nullSafe(scrapeResult.discarts)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.DISC);
            mediaArtwork.setPreviewUrl(discArt.preview);
            mediaArtwork.setOriginalUrl(discArt.original);
            mediaArtwork.setLikes(discArt.votes);
            mediaArtwork.addImageSize(discArt.width, discArt.height, discArt.original, 0);
            if (!discArt.languages.isEmpty()) {
                language = discArt.languages.get(0);
                mediaArtwork.setLanguage(LanguageUtils.getIso2LanguageFromLocalizedString(language.language));
            }
            ma.add(mediaArtwork);
        }
        for (HDClearArt hdClearArt : ListUtils.nullSafe(scrapeResult.hdcleararts)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.CLEARART);
            mediaArtwork.setPreviewUrl(hdClearArt.preview);
            mediaArtwork.setOriginalUrl(hdClearArt.original);
            mediaArtwork.setLikes(hdClearArt.votes);
            mediaArtwork.addImageSize(hdClearArt.width, hdClearArt.height, hdClearArt.original, 0);
            if (!hdClearArt.languages.isEmpty()) {
                language = hdClearArt.languages.get(0);
                mediaArtwork.setLanguage(LanguageUtils.getIso2LanguageFromLocalizedString(language.language));
            }
            ma.add(mediaArtwork);
        }
        for (HDLogo hdLogo : ListUtils.nullSafe(scrapeResult.hdlogos)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.CLEARLOGO);
            mediaArtwork.setPreviewUrl(hdLogo.preview);
            mediaArtwork.setOriginalUrl(hdLogo.original);
            mediaArtwork.setLikes(hdLogo.votes);
            mediaArtwork.addImageSize(hdLogo.width, hdLogo.height, hdLogo.original, 0);
            if (!hdLogo.languages.isEmpty()) {
                language = hdLogo.languages.get(0);
                mediaArtwork.setLanguage(LanguageUtils.getIso2LanguageFromLocalizedString(language.language));
            }
            ma.add(mediaArtwork);
        }
        return ma;
    }
}

