/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficstats;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.trafficstats.NetworkActivityDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Network traffic usage in limited time period")
@Generated(from="NetworkActivityDto", generator="Immutables")
public final class ImmutableNetworkActivityDto
extends NetworkActivityDto {
    private final long startTimestamp;
    private final long endTimestamp;
    private final long receivedBytes;
    private final long transmittedBytes;
    @Nullable
    private final Long clientCount;

    private ImmutableNetworkActivityDto(Builder builder) {
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.receivedBytes = builder.receivedBytes;
        this.transmittedBytes = builder.transmittedBytes;
        this.clientCount = builder.clientCount;
    }

    @Override
    @JsonProperty(value="start_timestamp")
    @Schema(name="Start time of network activity", example="1629708300")
    public long startTimestamp() {
        return this.startTimestamp;
    }

    @Override
    @JsonProperty(value="end_timestamp")
    @Schema(name="End time of network activity", example="1629708600")
    public long endTimestamp() {
        return this.endTimestamp;
    }

    @Override
    @JsonProperty(value="rx_bytes")
    @Schema(name="Total received bytes in time period", example="1251562")
    public long receivedBytes() {
        return this.receivedBytes;
    }

    @Override
    @JsonProperty(value="tx_bytes")
    @Schema(name="Total transmitted bytes in time period", example="3563633")
    public long transmittedBytes() {
        return this.transmittedBytes;
    }

    @Override
    @JsonProperty(value="client_count")
    @Schema(name="Total (unique) client count in time period", example="7", description="Only provided for site stats")
    public Optional<Long> clientCount() {
        return Optional.ofNullable(this.clientCount);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableNetworkActivityDto && this.\u00d200000(0, (ImmutableNetworkActivityDto)object);
    }

    private boolean \u00d200000(int n2, ImmutableNetworkActivityDto immutableNetworkActivityDto) {
        return this.startTimestamp == immutableNetworkActivityDto.startTimestamp && this.endTimestamp == immutableNetworkActivityDto.endTimestamp && this.receivedBytes == immutableNetworkActivityDto.receivedBytes && this.transmittedBytes == immutableNetworkActivityDto.transmittedBytes && Objects.equals(this.clientCount, immutableNetworkActivityDto.clientCount);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Long.hashCode(this.startTimestamp);
        n2 += (n2 << 5) + Long.hashCode(this.endTimestamp);
        n2 += (n2 << 5) + Long.hashCode(this.receivedBytes);
        n2 += (n2 << 5) + Long.hashCode(this.transmittedBytes);
        n2 += (n2 << 5) + Objects.hashCode(this.clientCount);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NetworkActivityDto{");
        stringBuilder.append("startTimestamp=").append(this.startTimestamp);
        stringBuilder.append(", ");
        stringBuilder.append("endTimestamp=").append(this.endTimestamp);
        stringBuilder.append(", ");
        stringBuilder.append("receivedBytes=").append(this.receivedBytes);
        stringBuilder.append(", ");
        stringBuilder.append("transmittedBytes=").append(this.transmittedBytes);
        if (this.clientCount != null) {
            stringBuilder.append(", ");
            stringBuilder.append("clientCount=").append(this.clientCount);
        }
        return stringBuilder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNetworkActivityDto o00000(_o _o2) {
        Builder builder = ImmutableNetworkActivityDto.builder();
        if (_o2.\u00d200000) {
            builder.startTimestamp(_o2.\u00d600000);
        }
        if (_o2.\u00d800000) {
            builder.endTimestamp(_o2.String);
        }
        if (_o2.\u00f500000) {
            builder.receivedBytes(_o2.null);
        }
        if (_o2.o00000) {
            builder.transmittedBytes(_o2.\u00d500000);
        }
        if (_o2.\u00d300000 != null) {
            builder.clientCount(_o2.\u00d300000);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NetworkActivityDto", generator="Immutables")
    public static final class Builder {
        private long startTimestamp;
        private long endTimestamp;
        private long receivedBytes;
        private long transmittedBytes;
        @Nullable
        private Long clientCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NetworkActivityDto networkActivityDto) {
            Objects.requireNonNull(networkActivityDto, "instance");
            this.startTimestamp(networkActivityDto.startTimestamp());
            this.endTimestamp(networkActivityDto.endTimestamp());
            this.receivedBytes(networkActivityDto.receivedBytes());
            this.transmittedBytes(networkActivityDto.transmittedBytes());
            Optional<Long> optional = networkActivityDto.clientCount();
            if (optional.isPresent()) {
                this.clientCount(optional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startTimestamp(long l2) {
            this.startTimestamp = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endTimestamp(long l2) {
            this.endTimestamp = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder receivedBytes(long l2) {
            this.receivedBytes = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transmittedBytes(long l2) {
            this.transmittedBytes = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientCount(@Nullable Long l2) {
            this.clientCount = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientCount(Optional<Long> optional) {
            this.clientCount = optional.orElse(null);
            return this;
        }

        public ImmutableNetworkActivityDto build() {
            return new ImmutableNetworkActivityDto(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NetworkActivityDto", generator="Immutables")
    static final class _o
    extends NetworkActivityDto {
        long \u00d600000;
        boolean \u00d200000;
        long String;
        boolean \u00d800000;
        long null;
        boolean \u00f500000;
        long \u00d500000;
        boolean o00000;
        @Nullable
        Optional<Long> \u00d300000 = Optional.empty();

        _o() {
        }

        @JsonProperty(value="start_timestamp")
        @Schema(name="Start time of network activity", example="1629708300")
        public void String(long l2) {
            this.\u00d600000 = l2;
            this.\u00d200000 = true;
        }

        @JsonProperty(value="end_timestamp")
        @Schema(name="End time of network activity", example="1629708600")
        public void \u00d800000(long l2) {
            this.String = l2;
            this.\u00d800000 = true;
        }

        @JsonProperty(value="rx_bytes")
        @Schema(name="Total received bytes in time period", example="1251562")
        public void \u00d500000(long l2) {
            this.null = l2;
            this.\u00f500000 = true;
        }

        @JsonProperty(value="tx_bytes")
        @Schema(name="Total transmitted bytes in time period", example="3563633")
        public void \u00d300000(long l2) {
            this.\u00d500000 = l2;
            this.o00000 = true;
        }

        @JsonProperty(value="client_count")
        @Schema(name="Total (unique) client count in time period", example="7", description="Only provided for site stats")
        public void \u00d600000(Optional<Long> optional) {
            this.\u00d300000 = optional;
        }

        @Override
        public long startTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long endTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long receivedBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transmittedBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> clientCount() {
            throw new UnsupportedOperationException();
        }
    }
}

