/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.floorplan.shape;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.model.api.floorplan.FloorPlanShapeType;
import com.ubnt.model.api.floorplan.shape.FloorPlanPositionDto;
import com.ubnt.model.api.floorplan.shape.FloorPlanShapeDto;
import com.ubnt.model.api.floorplan.shape.FloorPlanShapeRotationDto;
import com.ubnt.model.api.floorplan.shape.ImmutableFloorPlanDeviceDto;
import com.ubnt.return.F;
import com.ubnt.service.floorplan.FloorPlanDeviceDocumentPart;
import com.ubnt.service.floorplan.FloorPlanShapeDocument;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ImmutableFloorPlanDeviceDto.Builder.class)
@JsonTypeName(value="device")
@Value.Immutable
@F
public interface FloorPlanDeviceDto
extends FloorPlanShapeDto {
    @JsonProperty(value="mac")
    public String mac();

    @JsonProperty(value="position")
    @Size(min=1, max=1)
    public @Size(min=1, max=1) List<@Valid FloorPlanPositionDto> position();

    @JsonProperty(value="rotation")
    @NotNull
    public FloorPlanShapeRotationDto rotation();

    @Override
    default public FloorPlanShapeType type() {
        return FloorPlanShapeType.DEVICE;
    }

    @Override
    default public FloorPlanShapeDocument toDocument(String string, String string2) {
        return FloorPlanShapeDocument.builder().\u00f600000(string2).\u00d200000(string).super(this.planId()).int(this.status()).\u00d600000(this.uuid()).\u00f400000(this.type()).\u00d400000(FloorPlanDeviceDocumentPart.builder().\u00d400000(this.mac()).\u00d300000(this.position().stream().map(FloorPlanPositionDto::toDocument).toList()).\u00d600000(this.rotation().toDocument()).super()).class();
    }

    public static ImmutableFloorPlanDeviceDto.Builder builder() {
        return ImmutableFloorPlanDeviceDto.builder();
    }

    public static FloorPlanDeviceDto ofDocument(FloorPlanShapeDocument floorPlanShapeDocument) {
        return floorPlanShapeDocument.getDevice().map(floorPlanDeviceDocumentPart -> FloorPlanDeviceDto.builder().id(floorPlanShapeDocument.getId()).planId(floorPlanShapeDocument.getPlanId()).status(floorPlanShapeDocument.getStatus()).uuid(floorPlanShapeDocument.getUuid()).mac(floorPlanDeviceDocumentPart.getMac()).rotation(FloorPlanShapeRotationDto.ofDocument(floorPlanDeviceDocumentPart.getRotation())).position(floorPlanDeviceDocumentPart.getPosition().stream().map(FloorPlanPositionDto::ofDocument).toList()).build()).orElse(null);
    }
}

