/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;

enum FaasEnvironment {
    AWS_LAMBDA("aws.lambda"),
    AZURE_FUNC("azure.func"),
    GCP_FUNC("gcp.func"),
    VERCEL("vercel"),
    UNKNOWN(null);

    @Nullable
    private final String name;

    static FaasEnvironment getFaasEnvironment() {
        ArrayList<FaasEnvironment> result = new ArrayList<FaasEnvironment>();
        String awsExecutionEnv = System.getenv("AWS_EXECUTION_ENV");
        if (System.getenv("VERCEL") != null) {
            result.add(VERCEL);
        }
        if (awsExecutionEnv != null && awsExecutionEnv.startsWith("AWS_Lambda_") || System.getenv("AWS_LAMBDA_RUNTIME_API") != null) {
            result.add(AWS_LAMBDA);
        }
        if (System.getenv("FUNCTIONS_WORKER_RUNTIME") != null) {
            result.add(AZURE_FUNC);
        }
        if (System.getenv("K_SERVICE") != null || System.getenv("FUNCTION_NAME") != null) {
            result.add(GCP_FUNC);
        }
        if (result.equals(Arrays.asList(VERCEL, AWS_LAMBDA))) {
            return VERCEL;
        }
        if (result.size() != 1) {
            return UNKNOWN;
        }
        return (FaasEnvironment)((Object)result.get(0));
    }

    private FaasEnvironment(String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Integer getTimeoutSec() {
        switch (this) {
            case GCP_FUNC: {
                return FaasEnvironment.getEnvInteger("FUNCTION_TIMEOUT_SEC");
            }
        }
        return null;
    }

    @Nullable
    public Integer getMemoryMb() {
        switch (this) {
            case AWS_LAMBDA: {
                return FaasEnvironment.getEnvInteger("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
            }
            case GCP_FUNC: {
                return FaasEnvironment.getEnvInteger("FUNCTION_MEMORY_MB");
            }
        }
        return null;
    }

    @Nullable
    public String getRegion() {
        switch (this) {
            case AWS_LAMBDA: {
                return System.getenv("AWS_REGION");
            }
            case GCP_FUNC: {
                return System.getenv("FUNCTION_REGION");
            }
            case VERCEL: {
                return System.getenv("VERCEL_REGION");
            }
        }
        return null;
    }

    @Nullable
    private static Integer getEnvInteger(String name) {
        try {
            String value = System.getenv(name);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

