/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.organic;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Stack;

public class JGraphSelfOrganizingOrganicLayout
implements JGraphLayout {
    protected Rectangle2D bounds = null;
    protected int totalIterations = 0;
    protected int maxIterationsMultiple = 20;
    protected int iteration = 1;
    protected int radius = 0;
    protected int startRadius = 0;
    protected int minRadius = 1;
    protected double densityFactor = 0.0;
    protected int narrowingInterval = 0;
    protected double adaption = 0.0;
    protected double maxAdaption = 0.8;
    protected double minAdaption = 0.1;
    protected double coolingFactor = 1.0;
    protected Stack stack = null;
    protected int[][] neighbours;
    protected Object[] vertexArray;
    protected boolean[] vertexVisited;
    protected int[] vertexDistance;
    protected double[][] cellLocation;
    protected double randomX;
    protected double randomY;

    public void run(JGraphFacade jGraphFacade) {
        int n;
        boolean bl = jGraphFacade.isDirected();
        jGraphFacade.setDirected(false);
        this.vertexArray = jGraphFacade.getVertices().toArray();
        this.vertexVisited = new boolean[this.vertexArray.length];
        this.vertexDistance = new int[this.vertexArray.length];
        this.cellLocation = jGraphFacade.getLocations(this.vertexArray);
        this.neighbours = new int[this.vertexArray.length][];
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(this.vertexArray.length);
        this.bounds = jGraphFacade.getGraphBounds();
        if (this.densityFactor != 0.0 && this.bounds != null) {
            double d = this.bounds.getWidth() * this.bounds.getHeight();
            double d2 = this.densityFactor * (double)this.vertexArray.length;
            double d3 = Math.sqrt(d2 / d);
            this.bounds.setFrame(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth() * d3, this.bounds.getHeight() * d3);
        }
        for (n = 0; n < this.vertexArray.length; ++n) {
            hashtable.put(this.vertexArray[n], new Integer(n));
        }
        for (n = 0; n < this.vertexArray.length; ++n) {
            hashtable.put(this.vertexArray[n], new Integer(n));
            Object[] objectArray = jGraphFacade.getNeighbours(this.vertexArray[n], null, true).toArray();
            this.neighbours[n] = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                int n2;
                Integer n3 = (Integer)hashtable.get(objectArray[i]);
                this.neighbours[n][i] = n3 != null ? (n2 = n3.intValue()) : n;
            }
        }
        this.adaption = this.maxAdaption;
        if (this.startRadius == 0) {
            this.startRadius = 3;
        }
        this.radius = this.startRadius;
        this.totalIterations = this.vertexArray.length * this.maxIterationsMultiple;
        if (this.totalIterations < 100) {
            this.totalIterations = 100;
        }
        if (this.narrowingInterval == 0) {
            n = this.startRadius - this.minRadius + 1;
            if (n < 1) {
                n = 1;
            }
            this.narrowingInterval = this.totalIterations / n;
        }
        this.iteration = 1;
        while (this.iteration <= this.totalIterations) {
            this.updateToRandomNode();
            this.updateRadius();
            ++this.iteration;
        }
        jGraphFacade.setLocations(this.vertexArray, this.cellLocation);
        jGraphFacade.setDirected(bl);
    }

    protected void updateToRandomNode() {
        double d = Math.exp(-this.coolingFactor * (1.0 * (double)this.iteration / (double)this.totalIterations));
        this.adaption = Math.max(this.minAdaption, d * this.maxAdaption);
        this.randomX = Math.random() * this.bounds.getWidth();
        this.randomY = Math.random() * this.bounds.getHeight();
        int n = -1;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < this.vertexArray.length; ++i) {
            this.vertexDistance[i] = 0;
            this.vertexVisited[i] = false;
            double d3 = (this.randomX - this.cellLocation[i][0]) * (this.randomX - this.cellLocation[i][0]) + (this.randomY - this.cellLocation[i][1]) * (this.randomY - this.cellLocation[i][1]);
            if (!(d3 < d2)) continue;
            n = i;
            d2 = d3;
        }
        if (n > -1) {
            this.moveVertex(n);
        }
    }

    private void updateRadius() {
        if (this.radius > this.minRadius && this.iteration % this.narrowingInterval == 0) {
            --this.radius;
        }
    }

    private void moveVertex(int n) {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        this.vertexVisited[n] = true;
        this.stack.push(new Integer(n));
        while (!this.stack.isEmpty()) {
            int n2 = (Integer)this.stack.pop();
            double d = this.randomX - this.cellLocation[n2][0];
            double d2 = this.randomY - this.cellLocation[n2][1];
            double d3 = this.adaption / (double)(1 << this.vertexDistance[n2]);
            double[] dArray = this.cellLocation[n2];
            dArray[0] = dArray[0] + d3 * d;
            double[] dArray2 = this.cellLocation[n2];
            dArray2[1] = dArray2[1] + d3 * d2;
            if (this.vertexDistance[n2] >= this.radius) continue;
            for (int i = 0; i < this.neighbours[n].length; ++i) {
                int n3 = this.neighbours[n][i];
                if (n == n3 || this.vertexVisited[n3]) continue;
                this.vertexVisited[n3] = true;
                this.vertexDistance[n3] = this.vertexDistance[n2] + 1;
                this.stack.push(new Integer(n3));
            }
        }
    }

    public double getCoolingFactor() {
        return this.coolingFactor;
    }

    public void setCoolingFactor(double d) {
        this.coolingFactor = d;
    }

    public int getMaxIterationsMultiple() {
        return this.maxIterationsMultiple;
    }

    public void setMaxIterationsMultiple(int n) {
        this.maxIterationsMultiple = n;
    }

    public double getMinAdaption() {
        return this.minAdaption;
    }

    public void setMinAdaption(double d) {
        this.minAdaption = d;
    }

    public int getStartRadius() {
        return this.startRadius;
    }

    public void setStartRadius(int n) {
        this.startRadius = n;
    }

    public double getMaxAdaption() {
        return this.maxAdaption;
    }

    public void setMaxAdaption(double d) {
        this.maxAdaption = d;
    }

    public int getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(int n) {
        this.minRadius = n;
    }

    public double getDensityFactor() {
        return this.densityFactor;
    }

    public void setDensityFactor(double d) {
        this.densityFactor = d;
    }

    public String toString() {
        return "Self Organizing";
    }
}

