/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.BucketOperationSupport;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.util.Assert;

public class BucketOperation
extends BucketOperationSupport<BucketOperation, BucketOperationOutputBuilder>
implements FieldsExposingAggregationOperation {
    private final List<Object> boundaries;
    private final Object defaultBucket;

    public BucketOperation(Field groupByField) {
        super(groupByField);
        this.boundaries = Collections.emptyList();
        this.defaultBucket = null;
    }

    public BucketOperation(AggregationExpression groupByExpression) {
        super(groupByExpression);
        this.boundaries = Collections.emptyList();
        this.defaultBucket = null;
    }

    private BucketOperation(BucketOperation bucketOperation, BucketOperationSupport.Outputs outputs) {
        super(bucketOperation, outputs);
        this.boundaries = bucketOperation.boundaries;
        this.defaultBucket = bucketOperation.defaultBucket;
    }

    private BucketOperation(BucketOperation bucketOperation, List<Object> boundaries, Object defaultBucket) {
        super(bucketOperation);
        this.boundaries = new ArrayList<Object>(boundaries);
        this.defaultBucket = defaultBucket;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document options = new Document();
        options.put("boundaries", context.getMappedObject(new Document("$set", this.boundaries)).get((Object)"$set"));
        if (this.defaultBucket != null) {
            options.put("default", context.getMappedObject(new Document("$set", this.defaultBucket)).get((Object)"$set"));
        }
        options.putAll((Map)super.toDocument(context));
        return new Document(this.getOperator(), (Object)options);
    }

    @Override
    public String getOperator() {
        return "$bucket";
    }

    public BucketOperation withDefaultBucket(Object literal) {
        Assert.notNull((Object)literal, (String)"Default bucket literal must not be null");
        return new BucketOperation(this, this.boundaries, literal);
    }

    public BucketOperation withBoundaries(Object ... boundaries) {
        Assert.notNull((Object)boundaries, (String)"Boundaries must not be null");
        Assert.noNullElements((Object[])boundaries, (String)"Boundaries must not contain null values");
        ArrayList<Object> newBoundaries = new ArrayList<Object>(this.boundaries.size() + boundaries.length);
        newBoundaries.addAll(this.boundaries);
        newBoundaries.addAll(Arrays.asList(boundaries));
        return new BucketOperation(this, newBoundaries, this.defaultBucket);
    }

    @Override
    protected BucketOperation newBucketOperation(BucketOperationSupport.Outputs outputs) {
        return new BucketOperation(this, outputs);
    }

    public ExpressionBucketOperationBuilder andOutputExpression(String expression, Object ... params) {
        return new ExpressionBucketOperationBuilder(expression, this, params);
    }

    @Override
    public BucketOperationOutputBuilder andOutput(AggregationExpression expression) {
        return new BucketOperationOutputBuilder((Object)expression, this);
    }

    @Override
    public BucketOperationOutputBuilder andOutput(String fieldName) {
        return new BucketOperationOutputBuilder((Object)Fields.field(fieldName), this);
    }

    public static class ExpressionBucketOperationBuilder
    extends BucketOperationSupport.ExpressionBucketOperationBuilderSupport<BucketOperationOutputBuilder, BucketOperation> {
        protected ExpressionBucketOperationBuilder(String expression, BucketOperation operation, Object[] parameters) {
            super(expression, operation, parameters);
        }

        @Override
        protected BucketOperationOutputBuilder apply(BucketOperationSupport.OperationOutput operationOutput) {
            return new BucketOperationOutputBuilder((Object)operationOutput, (BucketOperation)this.operation);
        }
    }

    public static class BucketOperationOutputBuilder
    extends BucketOperationSupport.OutputBuilder<BucketOperationOutputBuilder, BucketOperation> {
        protected BucketOperationOutputBuilder(Object value, BucketOperation operation) {
            super(value, operation);
        }

        @Override
        protected BucketOperationOutputBuilder apply(BucketOperationSupport.OperationOutput operationOutput) {
            return new BucketOperationOutputBuilder((Object)operationOutput, (BucketOperation)this.operation);
        }
    }
}

