/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.ubnt.model.L.B.Object;
import com.ubnt.model.api.dashboard.WifiActivityDataDto;
import com.ubnt.model.api.dashboard.WifiActivityStatDto;
import com.ubnt.model.api.dashboard.widgets.DashboardWidget;
import com.ubnt.model.api.dashboard.widgets.DashboardWidgetDto;
import com.ubnt.model.api.dashboard.widgets.NoStatsReason;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class WifiActivityWidgetDto
extends WifiActivityDataDto
implements DashboardWidgetDto {
    @Nullable
    private final Map<Object, WifiActivityDataDto> byRadioBand;
    @Nullable
    private final NoStatsReason noStatsReason;

    @Override
    public DashboardWidget type() {
        return DashboardWidget.WIFI_ACTIVITY;
    }

    public static WifiActivityWidgetDto of(List<WifiActivityStatDto> list) {
        return WifiActivityWidgetDto.of(list, null);
    }

    public static WifiActivityWidgetDto of(List<WifiActivityStatDto> list, @Nullable Map<Object, List<WifiActivityStatDto>> map) {
        WifiActivityWidgetDtoBuilder<?, ?> wifiActivityWidgetDtoBuilder = WifiActivityWidgetDto.builder();
        WifiActivityWidgetDto.build(wifiActivityWidgetDtoBuilder, list);
        if (map != null) {
            wifiActivityWidgetDtoBuilder.byRadioBand(map.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
                WifiActivityDataDto.WifiActivityDataDtoBuilder<?, ?> wifiActivityDataDtoBuilder = WifiActivityDataDto.builder();
                WifiActivityWidgetDto.build(wifiActivityDataDtoBuilder, (List)entry.getValue());
                return wifiActivityDataDtoBuilder.build();
            })));
        }
        return wifiActivityWidgetDtoBuilder.build();
    }

    private static void build(WifiActivityDataDto.WifiActivityDataDtoBuilder<?, ?> wifiActivityDataDtoBuilder, List<WifiActivityStatDto> list) {
        long l2 = list.stream().mapToLong(WifiActivityStatDto::rxBytes).sum();
        long l3 = list.stream().mapToLong(WifiActivityStatDto::txBytes).sum();
        ((WifiActivityDataDto.WifiActivityDataDtoBuilder)((WifiActivityDataDto.WifiActivityDataDtoBuilder)((WifiActivityDataDto.WifiActivityDataDtoBuilder)wifiActivityDataDtoBuilder.rxBytes(l2)).txBytes(l3)).history(list)).build();
    }

    public static WifiActivityWidgetDto withoutStats(NoStatsReason noStatsReason) {
        return ((WifiActivityWidgetDtoBuilder)((WifiActivityWidgetDtoBuilder)WifiActivityWidgetDto.builder().history(List.of())).noStatsReason(noStatsReason)).build();
    }

    @Generated
    protected WifiActivityWidgetDto(WifiActivityWidgetDtoBuilder<?, ?> wifiActivityWidgetDtoBuilder) {
        super(wifiActivityWidgetDtoBuilder);
        this.byRadioBand = wifiActivityWidgetDtoBuilder.byRadioBand;
        this.noStatsReason = wifiActivityWidgetDtoBuilder.noStatsReason;
    }

    @Generated
    public static WifiActivityWidgetDtoBuilder<?, ?> builder() {
        return new _o();
    }

    @Nullable
    @Generated
    public Map<Object, WifiActivityDataDto> getByRadioBand() {
        return this.byRadioBand;
    }

    @Nullable
    @Generated
    public NoStatsReason getNoStatsReason() {
        return this.noStatsReason;
    }

    @Override
    @Generated
    public boolean equals(java.lang.Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WifiActivityWidgetDto)) {
            return false;
        }
        WifiActivityWidgetDto wifiActivityWidgetDto = (WifiActivityWidgetDto)object;
        if (!wifiActivityWidgetDto.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Map<Object, WifiActivityDataDto> map = this.getByRadioBand();
        Map<Object, WifiActivityDataDto> map2 = wifiActivityWidgetDto.getByRadioBand();
        if (map == null ? map2 != null : !((java.lang.Object)map).equals(map2)) {
            return false;
        }
        NoStatsReason noStatsReason = this.getNoStatsReason();
        NoStatsReason noStatsReason2 = wifiActivityWidgetDto.getNoStatsReason();
        return !(noStatsReason == null ? noStatsReason2 != null : !((java.lang.Object)((java.lang.Object)noStatsReason)).equals((java.lang.Object)noStatsReason2));
    }

    @Override
    @Generated
    protected boolean canEqual(java.lang.Object object) {
        return object instanceof WifiActivityWidgetDto;
    }

    @Override
    @Generated
    public int hashCode() {
        int n2 = super.hashCode();
        Map<Object, WifiActivityDataDto> map = this.getByRadioBand();
        n2 = n2 * 59 + (map == null ? 43 : ((java.lang.Object)map).hashCode());
        NoStatsReason noStatsReason = this.getNoStatsReason();
        n2 = n2 * 59 + (noStatsReason == null ? 43 : ((java.lang.Object)((java.lang.Object)noStatsReason)).hashCode());
        return n2;
    }

    @Generated
    public static abstract class WifiActivityWidgetDtoBuilder<C extends WifiActivityWidgetDto, B extends WifiActivityWidgetDtoBuilder<C, B>>
    extends WifiActivityDataDto.WifiActivityDataDtoBuilder<C, B> {
        @Generated
        private Map<Object, WifiActivityDataDto> byRadioBand;
        @Generated
        private NoStatsReason noStatsReason;

        @Generated
        public B byRadioBand(@Nullable Map<Object, WifiActivityDataDto> map) {
            this.byRadioBand = map;
            return this.Object();
        }

        @Generated
        public B noStatsReason(@Nullable NoStatsReason noStatsReason) {
            this.noStatsReason = noStatsReason;
            return this.Object();
        }

        @Generated
        protected abstract B Object();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "WifiActivityWidgetDto.WifiActivityWidgetDtoBuilder(super=" + super.toString() + ", byRadioBand=" + this.byRadioBand + ", noStatsReason=" + this.noStatsReason + ")";
        }
    }

    @Generated
    private static final class _o
    extends WifiActivityWidgetDtoBuilder<WifiActivityWidgetDto, _o> {
        @Generated
        private _o() {
        }

        @Generated
        protected _o \u00d400000() {
            return this;
        }

        @Override
        @Generated
        public WifiActivityWidgetDto build() {
            return new WifiActivityWidgetDto(this);
        }
    }
}

