/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.ace.view.D;
import com.ubnt.data.Site;
import com.ubnt.model.api.uid.UidClientInfoDto;
import com.ubnt.model.api.uid.UidRadiusConfiguration;
import com.ubnt.model.api.uid.UidVpnServerConfigurationDto;
import com.ubnt.model.api.wlan.WlanConfiguration;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.net.v2.config.security.annotation.RequireUCoreLocal;
import com.ubnt.net.v2.exception.ResourceNotFoundException;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.uid.OoOO;
import com.ubnt.service.uid.new.new;
import com.ubnt.service.uidb.I;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="UID")
public class UidController {
    private final I \u00d200000;
    private final OoOO super;

    public UidController(I i2, OoOO ooOO2) {
        this.\u00d200000 = i2;
        this.super = ooOO2;
    }

    @ModelAttribute
    public void populateRequestActor(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("actor", (Object)D.class);
    }

    @GetMapping(value={"/api/site/{siteName}/uid/radius-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get default (UDAPI) RADIUS Server Configuration")
    public UidRadiusConfiguration getDefaultRadiusConfiguration(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d6O0000(site.getId()).orElseThrow(() -> new ResourceNotFoundException("UID RADIUS configuration is not found"));
    }

    @PostMapping(value={"/api/site/{siteName}/uid/radius-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update default (UDAPI) RADIUS Server Configuration")
    public UidRadiusConfiguration updateDefaultRadiusConfiguration(@PathVariable(value="siteName") Site site, @Valid @RequestBody UidRadiusConfiguration uidRadiusConfiguration) {
        return this.super.oO0000(site.getId(), uidRadiusConfiguration);
    }

    @GetMapping(value={"/api/site/{siteName}/uid/wlan"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get Wireless Networks")
    public List<WlanConfiguration> getUidWiFiNetworks(@PathVariable(value="siteName") Site site) {
        return this.super.supersuper(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/uid/wlan"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create an UID Wireless Network")
    public WlanConfiguration createWlan(@PathVariable(value="siteName") Site site, @Valid @RequestBody WlanConfiguration wlanConfiguration) {
        return this.super.\u00d200000(site.getId(), wlanConfiguration);
    }

    @PutMapping(value={"/api/site/{siteName}/uid/wlan/{wlanId}"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update an UID Wireless Network")
    public WlanConfiguration updateWlan(@PathVariable(value="siteName") Site site, @PathVariable(value="wlanId") String string, @Valid @RequestBody WlanConfiguration wlanConfiguration) {
        return this.super.o00000(site.getId(), string, wlanConfiguration);
    }

    @DeleteMapping(value={"/api/site/{siteName}/uid/wlan/{wlanId}"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete an UID Wireless Network")
    public void deleteWlan(@PathVariable(value="siteName") Site site, @PathVariable(value="wlanId") String string) {
        this.super.\u00d500000(site.getId(), string);
    }

    @GetMapping(value={"/api/site/{siteName}/uid/vpn-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get UID VPN Server Configuration")
    public UidVpnServerConfigurationDto getVpnConfiguration(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d2O0000(site.getId()).orElseThrow(() -> new ResourceNotFoundException("UID VPN is not configured yet"));
    }

    @PostMapping(value={"/api/site/{siteName}/uid/vpn-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Create or update UID VPN Server Configuration")
    public UidVpnServerConfigurationDto updateVpnConfiguration(@PathVariable(value="siteName") Site site, @Valid @RequestBody UidVpnServerConfigurationDto uidVpnServerConfigurationDto) {
        return this.super.\u00d600000(site.getId(), uidVpnServerConfigurationDto);
    }

    @DeleteMapping(value={"/api/site/{siteName}/uid/vpn-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete UID VPN Server Configuration")
    public void deleteVpnConfiguration(@PathVariable(value="siteName") Site site) {
        String string = site.getId();
        this.super.\u00d2O0000(string).orElseThrow(() -> new ResourceNotFoundException("UID VPN is not configured yet"));
        this.super.void(string);
    }

    @PostMapping(value={"/api/site/{siteName}/uid/vpn-server/kick/{username}"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @Operation(summary="Disconnect UID VPN Client")
    public void disconnectVpnClient(@PathVariable(value="siteName") Site site, @PathVariable(value="username") @NotEmpty String string) {
        this.super.Object(site.getId(), string);
    }

    @GetMapping(value={"/api/site/{siteName}/uid/client-info/{clientMac}"})
    @RequireUCoreLocal
    @Operation(summary="Get UID WiFi Client Info")
    public UidClientInfoDto getClientInfo(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") @MacAddress String string) {
        new new_ = this.super.\u00d5O0000(site.getId(), string);
        String string2 = this.\u00d200000.class(new_.\u00d800000());
        return UidClientInfoDto.fromUidClientInfo(new_, string2);
    }
}

