/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.firewall;

import com.ubnt.data.Site;
import com.ubnt.model.api.firewall.simpleappblock.SimpleAppBlockDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.firewall.simpleappblock.SimpleAppBlockDocument;
import com.ubnt.service.firewall.simpleappblock.o0OO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@V2RestController
@Tag(name="Simple App Blocking")
public class SimpleAppBlockController {
    private final o0OO o00000;

    public SimpleAppBlockController(o0OO o0OO2) {
        this.o00000 = o0OO2;
    }

    @GetMapping(value={"/api/site/{siteName}/firewall-app-blocks"})
    @Operation(summary="Get all Simple App Blocking rules")
    public List<SimpleAppBlockDto> getSimpleAppBlockRules(@PathVariable(value="siteName") Site site) {
        return this.o00000.Object(site.getId()).stream().map(SimpleAppBlockDto::ofDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/firewall-app-blocks"})
    @Operation(summary="Update all Simple App Blocking rules")
    public List<SimpleAppBlockDto> updateSimpleAppBlockRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid List<SimpleAppBlockDto> list) {
        List<SimpleAppBlockDocument> list2 = list.stream().map(simpleAppBlockDto -> simpleAppBlockDto.toDocument(site.getId())).toList();
        return this.o00000.OO0000(site.getId(), list2).stream().map(SimpleAppBlockDto::ofDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/firewall-app-blocks/create"})
    @Operation(summary="Create Simple App Block Rule")
    public SimpleAppBlockDto createSimpleAppBlockRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid SimpleAppBlockDto simpleAppBlockDto) {
        return SimpleAppBlockDto.ofDocument(this.o00000.\u00d5o0000(site.getId(), simpleAppBlockDto));
    }

    @PutMapping(value={"/api/site/{siteName}/firewall-app-blocks/{id}"})
    @Operation(summary="Update Simple App Block Rule")
    public SimpleAppBlockDto updateSimpleAppBlockRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid SimpleAppBlockDto simpleAppBlockDto) {
        return SimpleAppBlockDto.ofDocument(this.o00000.\u00f4O0000(site.getId(), string, simpleAppBlockDto));
    }

    @DeleteMapping(value={"/api/site/{siteName}/firewall-app-blocks/{id}"})
    @Operation(summary="Delete Simple App Block Rule")
    public void deleteSimpleAppBlockRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.o00000.Oo0000(string);
    }
}

