/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.gateway.engine;

import com.ubnt.data.Site;
import com.ubnt.model.api.gateway.engine.GatewayEngineFeatureDto;
import com.ubnt.model.api.gateway.engine.GatewayEngineLogDto;
import com.ubnt.model.api.gateway.engine.GatewayEngineNetworkDto;
import com.ubnt.model.api.gateway.engine.GatewayEngineUtilizationDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.gateway.engine.c;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@V2RestController
@Tag(name="Gateway Engine")
public class GatewayEngineController {
    private final c o00000;

    public GatewayEngineController(c c2) {
        this.o00000 = c2;
    }

    @GetMapping(value={"/api/site/{siteName}/gateway/engine/features"})
    @Operation(summary="Return list of Gateway Engine features", description="Since 7.6.43")
    public List<GatewayEngineFeatureDto> listFeatures(@PathVariable(value="siteName") Site site) {
        return this.o00000.o00000(site).stream().map(GatewayEngineFeatureDto::of).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/gateway/engine/most-active-networks"})
    @Operation(summary="Return list of Most Active Networks", description="Since 7.6.41")
    public List<GatewayEngineNetworkDto> listMostActiveNetworks(@PathVariable(value="siteName") Site site, @RequestParam(value="limit", defaultValue="3") int n2) {
        return this.o00000.Object(site).stream().map(GatewayEngineNetworkDto::of).limit(n2).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/gateway/engine/utilization"})
    @Operation(summary="Return utilization of Gateway", description="Since 7.6.40")
    public Optional<GatewayEngineUtilizationDto> getUtilization(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d400000(site).map(GatewayEngineUtilizationDto::of);
    }

    @GetMapping(value={"/api/site/{siteName}/gateway/engine/logs"})
    @Operation(summary="Return gateway engine logs", description="Since 8.0.1")
    public List<GatewayEngineLogDto> getLogs(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d200000(site).stream().map(GatewayEngineLogDto::of).collect(Collectors.toList());
    }
}

