/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.utilization;

import com.ubnt.data.Site;
import com.ubnt.model.api.utilization.UtilizationInfoResponseDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.utilization.E;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@V2RestController
@Validated
@Tag(name="Utilization Info")
public class UtilizationInfoController {
    private final E o00000;

    public UtilizationInfoController(E e2) {
        this.o00000 = e2;
    }

    @GetMapping(value={"/api/site/{siteName}/utilization/time_range"})
    @Operation(summary="Get system utilization info for time range")
    public UtilizationInfoResponseDto getTimeRangedStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Min(value=0L) @NotNull @Min(value=0L) @NotNull Long l2, @RequestParam(value="end") @Min(value=0L) @NotNull @Min(value=0L) @NotNull Long l3) {
        return UtilizationInfoResponseDto.fromUtilizationInfoResponse(this.o00000.super(site.getId(), l2, l3));
    }

    @GetMapping(value={"/api/site/{siteName}/utilization/last_days"})
    @Operation(summary="Get system utilization info for given last days")
    public UtilizationInfoResponseDto getLastDaysStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="days", defaultValue="1") @Min(value=1L) @Max(value=31L) @Min(value=1L) @Max(value=31L) int n2) {
        return UtilizationInfoResponseDto.fromUtilizationInfoResponse(this.o00000.\u00d200000(site.getId(), n2));
    }
}

