/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class ObjectManagerDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.objectManager";
    private String id;
    private AbstractDescriptor.ObjectType managerType;
    private AbstractDescriptor.ObjectType objectType;
    private DBEObjectManager managerInstance;

    ObjectManagerDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("class");
        this.managerType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, this.id);
        this.objectType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("objectType"));
    }

    void dispose() {
        this.objectType = null;
        this.managerType = null;
        this.managerInstance = null;
    }

    public String getId() {
        return this.id;
    }

    public AbstractDescriptor.ObjectType getObjectType() {
        return this.objectType;
    }

    public boolean appliesToType(Class<?> clazz) {
        return this.objectType.matchesType(clazz);
    }

    public synchronized DBEObjectManager getManager() {
        if (this.managerInstance != null) {
            return this.managerInstance;
        }
        Class clazz = this.managerType.getObjectClass(DBEObjectManager.class);
        if (clazz == null) {
            throw new IllegalStateException("Can't instantiate object manager '" + this.managerType.getImplName() + "'");
        }
        try {
            this.managerInstance = (DBEObjectManager)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Error instantiating object manager '" + clazz.getName() + "'", ex);
        }
        return this.managerInstance;
    }

    public String toString() {
        return this.id;
    }
}

