/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.remote.Address;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.DaemonRegistryUpdater;
import org.gradle.launcher.daemon.server.DaemonServerConnector;
import org.gradle.launcher.daemon.server.DaemonStateCoordinator;
import org.gradle.launcher.daemon.server.DaemonStopState;
import org.gradle.launcher.daemon.server.DefaultIncomingConnectionHandler;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecuter;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationListener;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.process.internal.shutdown.ShutdownHooks;

@ServiceScope(value={Scope.Global.class})
public class Daemon
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(Daemon.class);
    private final DaemonServerConnector connector;
    private final DaemonRegistry daemonRegistry;
    private final DaemonContext daemonContext;
    private final DaemonCommandExecuter commandExecuter;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ExecutorFactory executorFactory;
    private final ListenerManager listenerManager;
    private DaemonStateCoordinator stateCoordinator;
    private final Lock lifecycleLock = new ReentrantLock();
    private Address connectorAddress;
    private DaemonRegistryUpdater registryUpdater;
    private DefaultIncomingConnectionHandler connectionHandler;

    public Daemon(DaemonServerConnector connector, DaemonRegistry daemonRegistry, DaemonContext daemonContext, DaemonCommandExecuter commandExecuter, ExecutorFactory executorFactory, ListenerManager listenerManager) {
        this.connector = connector;
        this.daemonRegistry = daemonRegistry;
        this.daemonContext = daemonContext;
        this.commandExecuter = commandExecuter;
        this.executorFactory = executorFactory;
        this.scheduledExecutorService = executorFactory.createScheduled("Daemon periodic checks", 1);
        this.listenerManager = listenerManager;
    }

    public String getUid() {
        return this.daemonContext.getUid();
    }

    public Address getAddress() {
        return this.connectorAddress;
    }

    public DaemonContext getDaemonContext() {
        return this.daemonContext;
    }

    public DaemonRegistry getDaemonRegistry() {
        return this.daemonRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOGGER.info("start() called on daemon - {}", (Object)this.daemonContext);
        this.lifecycleLock.lock();
        try {
            if (this.stateCoordinator != null) {
                throw new IllegalStateException("cannot start daemon as it is already running");
            }
            SecureRandom secureRandom = new SecureRandom();
            byte[] token = new byte[16];
            secureRandom.nextBytes(token);
            this.registryUpdater = new DaemonRegistryUpdater(this.daemonRegistry, this.daemonContext, token);
            ShutdownHooks.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Daemon.this.daemonRegistry.remove(Daemon.this.connectorAddress);
                    }
                    catch (Exception e) {
                        LOGGER.debug("VM shutdown hook was unable to remove the daemon address from the registry. It will be cleaned up later.", (Throwable)e);
                    }
                }
            });
            Runnable onStartCommand = new Runnable(){

                @Override
                public void run() {
                    Daemon.this.registryUpdater.onStartActivity();
                }
            };
            Runnable onFinishCommand = new Runnable(){

                @Override
                public void run() {
                    Daemon.this.registryUpdater.onCompleteActivity();
                }
            };
            Runnable onCancelCommand = new Runnable(){

                @Override
                public void run() {
                    Daemon.this.registryUpdater.onCancel();
                }
            };
            this.stateCoordinator = new DaemonStateCoordinator(this.executorFactory, onStartCommand, onFinishCommand, onCancelCommand);
            this.connectionHandler = new DefaultIncomingConnectionHandler(this.commandExecuter, this.daemonContext, this.stateCoordinator, this.executorFactory, token);
            Runnable connectionErrorHandler = new Runnable(){

                @Override
                public void run() {
                    Daemon.this.stateCoordinator.stop();
                }
            };
            this.connectorAddress = this.connector.start(this.connectionHandler, connectionErrorHandler);
            LOGGER.debug("Daemon starting at: {}, with address: {}", (Object)new Date(), (Object)this.connectorAddress);
            this.registryUpdater.onStart(this.connectorAddress);
        }
        finally {
            this.lifecycleLock.unlock();
        }
        LOGGER.lifecycle("Daemon server started.");
    }

    public void stop() {
        LOGGER.debug("stop() called on daemon");
        this.lifecycleLock.lock();
        try {
            if (this.stateCoordinator == null) {
                throw new IllegalStateException("cannot stop daemon as it has not been started.");
            }
            LOGGER.info("Stop requested. Daemon is removing its presence from the registry...");
            this.scheduledExecutorService.shutdown();
            CompositeStoppable.stoppable((Object[])new Object[]{this.stateCoordinator, this.registryUpdater, this.connector, this.connectionHandler}).stop();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public DaemonStopState stopOnExpiration(DaemonExpirationStrategy expirationStrategy, int checkIntervalMills) {
        LOGGER.debug("stopOnExpiration() called on daemon");
        this.scheduleExpirationChecks(expirationStrategy, checkIntervalMills);
        return this.awaitExpiration();
    }

    private void scheduleExpirationChecks(DaemonExpirationStrategy expirationStrategy, int checkIntervalMills) {
        DaemonExpirationPeriodicCheck periodicCheck = new DaemonExpirationPeriodicCheck(expirationStrategy, this.listenerManager);
        this.listenerManager.addListener((Object)new DefaultDaemonExpirationListener(this.stateCoordinator, this.registryUpdater));
        ScheduledFuture<?> ignored = this.scheduledExecutorService.scheduleAtFixedRate(periodicCheck, checkIntervalMills, checkIntervalMills, TimeUnit.MILLISECONDS);
    }

    private DaemonStopState awaitExpiration() {
        DaemonStateCoordinator stateCoordinator;
        LOGGER.debug("awaitExpiration() called on daemon");
        this.lifecycleLock.lock();
        try {
            if (this.stateCoordinator == null) {
                throw new IllegalStateException("cannot await stop on daemon as it has not been started.");
            }
            stateCoordinator = this.stateCoordinator;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        return stateCoordinator.awaitStop();
    }

    public DaemonStateCoordinator getStateCoordinator() {
        return this.stateCoordinator;
    }

    private static class DaemonExpirationPeriodicCheck
    implements Runnable {
        private final DaemonExpirationStrategy expirationStrategy;
        private final DaemonExpirationListener listenerBroadcast;

        DaemonExpirationPeriodicCheck(DaemonExpirationStrategy expirationStrategy, ListenerManager listenerManager) {
            this.expirationStrategy = expirationStrategy;
            this.listenerBroadcast = (DaemonExpirationListener)listenerManager.getBroadcaster(DaemonExpirationListener.class);
        }

        @Override
        public void run() {
            try {
                LOGGER.debug("Starting periodic daemon health check.");
                DaemonExpirationResult result = this.expirationStrategy.checkExpiration();
                if (result.getStatus() != DaemonExpirationStatus.DO_NOT_EXPIRE) {
                    this.listenerBroadcast.onExpirationEvent(result);
                }
                LOGGER.debug("Finished periodic daemon health check.");
            }
            catch (Throwable t) {
                LOGGER.error("Problem in daemon expiration check", t);
            }
        }
    }

    private static class DefaultDaemonExpirationListener
    implements DaemonExpirationListener {
        private final DaemonStateControl stateControl;
        private final DaemonRegistryUpdater registryUpdater;

        public DefaultDaemonExpirationListener(DaemonStateControl stateControl, DaemonRegistryUpdater registryUpdater) {
            this.stateControl = stateControl;
            this.registryUpdater = registryUpdater;
        }

        @Override
        public void onExpirationEvent(DaemonExpirationResult result) {
            DaemonExpirationStatus expirationCheck = result.getStatus();
            if (expirationCheck != DaemonExpirationStatus.DO_NOT_EXPIRE) {
                if (expirationCheck != DaemonExpirationStatus.QUIET_EXPIRE) {
                    this.registryUpdater.onExpire(result.getReason(), expirationCheck);
                }
                if (expirationCheck == DaemonExpirationStatus.IMMEDIATE_EXPIRE) {
                    this.stateControl.requestForcefulStop(result.getReason());
                } else {
                    this.stateControl.requestStop(result.getReason());
                }
            }
        }
    }
}

