/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import jakarta.ws.rs.core.HttpHeaders;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.distributed.Crypto;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.eclipse.jetty.client.Request;

public class InternalRequestSignature {
    public static final String SIGNATURE_HEADER = "X-Connect-Authorization";
    public static final String SIGNATURE_ALGORITHM_HEADER = "X-Connect-Request-Signature-Algorithm";
    private final byte[] requestBody;
    private final Mac mac;
    private final byte[] requestSignature;

    public static void addToRequest(Crypto crypto, SecretKey key, byte[] requestBody, String signatureAlgorithm, Request request) {
        Mac mac;
        try {
            mac = crypto.mac(signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectException((Throwable)e);
        }
        byte[] requestSignature = InternalRequestSignature.sign(mac, key, requestBody);
        request.headers(field -> {
            field.add(SIGNATURE_HEADER, Base64.getEncoder().encodeToString(requestSignature));
            field.add(SIGNATURE_ALGORITHM_HEADER, signatureAlgorithm);
        });
    }

    public static InternalRequestSignature fromHeaders(Crypto crypto, byte[] requestBody, HttpHeaders headers) {
        byte[] decodedSignature;
        Mac mac;
        if (headers == null) {
            return null;
        }
        String signatureAlgorithm = headers.getHeaderString(SIGNATURE_ALGORITHM_HEADER);
        String encodedSignature = headers.getHeaderString(SIGNATURE_HEADER);
        if (signatureAlgorithm == null || encodedSignature == null) {
            return null;
        }
        try {
            mac = crypto.mac(signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BadRequestException(e.getMessage());
        }
        try {
            decodedSignature = Base64.getDecoder().decode(encodedSignature);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
        return new InternalRequestSignature(requestBody, mac, decodedSignature);
    }

    public InternalRequestSignature(byte[] requestBody, Mac mac, byte[] requestSignature) {
        this.requestBody = requestBody;
        this.mac = mac;
        this.requestSignature = requestSignature;
    }

    public String keyAlgorithm() {
        return this.mac.getAlgorithm();
    }

    public boolean isValid(SecretKey key) {
        return MessageDigest.isEqual(InternalRequestSignature.sign(this.mac, key, this.requestBody), this.requestSignature);
    }

    private static byte[] sign(Mac mac, SecretKey key, byte[] requestBody) {
        try {
            mac.init(key);
        }
        catch (InvalidKeyException e) {
            throw new ConnectException((Throwable)e);
        }
        return mac.doFinal(requestBody);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalRequestSignature that = (InternalRequestSignature)o;
        return MessageDigest.isEqual(this.requestBody, that.requestBody) && this.mac.getAlgorithm().equals(that.mac.getAlgorithm()) && this.mac.getMacLength() == that.mac.getMacLength() && this.mac.getProvider().equals(that.mac.getProvider()) && MessageDigest.isEqual(this.requestSignature, that.requestSignature);
    }

    public int hashCode() {
        int result = Objects.hash(this.mac);
        result = 31 * result + Arrays.hashCode(this.requestBody);
        result = 31 * result + Arrays.hashCode(this.requestSignature);
        return result;
    }
}

