/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.output.Render;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
        throw new UnsupportedOperationException("Utility class. Do not instantiate");
    }

    public static void writeToFile(Render render, ChangedOpenApi diff, String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            logger.debug("File name cannot be null or empty.");
            return;
        }
        Path filePath = Paths.get(fileName, new String[0]);
        try (FileOutputStream outputStream = new FileOutputStream(filePath.toFile());
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);){
            render.render(diff, outputStreamWriter);
        }
        catch (IOException e) {
            logger.error("Exception while writing to file {}", (Object)fileName, (Object)e);
        }
    }
}

