/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Http
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Http> {
    @Nullable
    private final Long currentOpen;
    @Nullable
    private final Long totalOpened;
    public static final JsonpDeserializer<Http> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Http::setupHttpDeserializer);

    private Http(Builder builder) {
        this.currentOpen = builder.currentOpen;
        this.totalOpened = builder.totalOpened;
    }

    public static Http of(Function<Builder, ObjectBuilder<Http>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long currentOpen() {
        return this.currentOpen;
    }

    @Nullable
    public final Long totalOpened() {
        return this.totalOpened;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentOpen != null) {
            generator.writeKey("current_open");
            generator.write(this.currentOpen.longValue());
        }
        if (this.totalOpened != null) {
            generator.writeKey("total_opened");
            generator.write(this.totalOpened.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHttpDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentOpen, JsonpDeserializer.longDeserializer(), "current_open");
        op.add(Builder::totalOpened, JsonpDeserializer.longDeserializer(), "total_opened");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.currentOpen);
        result = 31 * result + Objects.hashCode(this.totalOpened);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Http other = (Http)o;
        return Objects.equals(this.currentOpen, other.currentOpen) && Objects.equals(this.totalOpened, other.totalOpened);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Http> {
        @Nullable
        private Long currentOpen;
        @Nullable
        private Long totalOpened;

        public Builder() {
        }

        private Builder(Http o) {
            this.currentOpen = o.currentOpen;
            this.totalOpened = o.totalOpened;
        }

        private Builder(Builder o) {
            this.currentOpen = o.currentOpen;
            this.totalOpened = o.totalOpened;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder currentOpen(@Nullable Long value) {
            this.currentOpen = value;
            return this;
        }

        @Nonnull
        public final Builder totalOpened(@Nullable Long value) {
            this.totalOpened = value;
            return this;
        }

        @Override
        @Nonnull
        public Http build() {
            this._checkSingleUse();
            return new Http(this);
        }
    }
}

