/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.codec;

import java.util.ArrayList;
import java.util.List;
import org.jitsi.jicofo.JicofoConfig;
import org.jitsi.jicofo.codec.CodecUtil;
import org.jitsi.jicofo.codec.Config;
import org.jitsi.jicofo.codec.OfferOptions;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ExtmapAllowMixedPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;

public class JingleOfferFactory {
    public static final JingleOfferFactory INSTANCE = new JingleOfferFactory();

    public List<ContentPacketExtension> createOffer(OfferOptions options) {
        ArrayList<ContentPacketExtension> contents = new ArrayList<ContentPacketExtension>();
        if (options.getAudio()) {
            contents.add(this.createAudioContent(options));
        }
        if (options.getVideo()) {
            contents.add(this.createVideoContent(options));
        }
        if (JicofoConfig.config.enableSctp() && options.getSctp()) {
            contents.add(this.createDataContent(options));
        }
        return contents;
    }

    private ContentPacketExtension createAudioContent(OfferOptions options) {
        ContentPacketExtension content = JingleOfferFactory.createContentPacketExtension("audio");
        JingleOfferFactory.addAudioToContent(content, options);
        return content;
    }

    private ContentPacketExtension createDataContent(OfferOptions options) {
        ContentPacketExtension content = JingleOfferFactory.createContentPacketExtension("data");
        JingleOfferFactory.addDataToContent(content);
        return content;
    }

    private ContentPacketExtension createVideoContent(OfferOptions options) {
        ContentPacketExtension videoContentPe = JingleOfferFactory.createContentPacketExtension("video");
        this.addVideoToContent(videoContentPe, options);
        return videoContentPe;
    }

    private static ContentPacketExtension createContentPacketExtension(String name) {
        ContentPacketExtension content = new ContentPacketExtension(ContentPacketExtension.CreatorEnum.initiator, name);
        content.setSenders(ContentPacketExtension.SendersEnum.both);
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = new IceUdpTransportPacketExtension();
        iceUdpTransportPacketExtension.addChildExtension((ExtensionElement)new DtlsFingerprintPacketExtension());
        content.addChildExtension((ExtensionElement)iceUdpTransportPacketExtension);
        return content;
    }

    private void addVideoToContent(ContentPacketExtension content, OfferOptions options) {
        RtpDescriptionPacketExtension rtpDesc = new RtpDescriptionPacketExtension();
        rtpDesc.setMedia("video");
        CodecUtil.Companion.createVideoPayloadTypeExtensions(options).forEach(arg_0 -> ((RtpDescriptionPacketExtension)rtpDesc).addPayloadType(arg_0));
        CodecUtil.Companion.createVideoRtpHdrExtExtensions(options).forEach(arg_0 -> ((RtpDescriptionPacketExtension)rtpDesc).addExtmap(arg_0));
        if (Config.config.getExtmapAllowMixed()) {
            rtpDesc.setExtmapAllowMixed(new ExtmapAllowMixedPacketExtension());
        }
        content.addChildExtension((ExtensionElement)rtpDesc);
    }

    private static void addAudioToContent(ContentPacketExtension content, OfferOptions options) {
        RtpDescriptionPacketExtension rtpDesc = new RtpDescriptionPacketExtension();
        rtpDesc.setMedia("audio");
        CodecUtil.Companion.createAudioRtpHdrExtExtensions(options).forEach(arg_0 -> ((RtpDescriptionPacketExtension)rtpDesc).addExtmap(arg_0));
        CodecUtil.Companion.createAudioPayloadTypeExtensions(options).forEach(arg_0 -> ((RtpDescriptionPacketExtension)rtpDesc).addPayloadType(arg_0));
        if (Config.config.getExtmapAllowMixed()) {
            rtpDesc.setExtmapAllowMixed(new ExtmapAllowMixedPacketExtension());
        }
        rtpDesc.setAttribute("maxptime", (Object)"60");
        content.addChildExtension((ExtensionElement)rtpDesc);
    }

    private static void addDataToContent(ContentPacketExtension content) {
        RtpDescriptionPacketExtension rdpe = new RtpDescriptionPacketExtension();
        rdpe.setMedia("application");
        content.addChildExtension((ExtensionElement)rdpe);
    }
}

