/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtcp.EmptySdesItem;
import org.jitsi.rtp.rtcp.SdesItem;
import org.jitsi.rtp.util.FieldParsersKt;
import org.jitsi.rtp.util.RtpUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\f\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/rtp/rtcp/SdesChunk;", "", "buffer", "", "offset", "", "<init>", "([BI)V", "sizeBytes", "getSizeBytes", "()I", "sizeBytes$delegate", "Lkotlin/Lazy;", "ssrc", "", "getSsrc", "()J", "ssrc$delegate", "sdesItems", "", "Lorg/jitsi/rtp/rtcp/SdesItem;", "getSdesItems", "()Ljava/util/List;", "sdesItems$delegate", "Companion", "rtp"})
@SourceDebugExtension(value={"SMAP\nRtcpSdesPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtcpSdesPacket.kt\norg/jitsi/rtp/rtcp/SdesChunk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1563#2:216\n1634#2,3:217\n*S KotlinDebug\n*F\n+ 1 RtcpSdesPacket.kt\norg/jitsi/rtp/rtcp/SdesChunk\n*L\n82#1:216\n82#1:217,3\n*E\n"})
public final class SdesChunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy sizeBytes$delegate;
    @NotNull
    private final Lazy ssrc$delegate;
    @NotNull
    private final Lazy sdesItems$delegate;
    public static final int SSRC_OFFSET = 0;
    public static final int SDES_ITEMS_OFFSET = 4;

    public SdesChunk(@NotNull byte[] buffer, int offset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.sizeBytes$delegate = LazyKt.lazy(() -> SdesChunk.sizeBytes_delegate$lambda$0(this));
        this.ssrc$delegate = LazyKt.lazy(() -> SdesChunk.ssrc_delegate$lambda$0(buffer, offset));
        this.sdesItems$delegate = LazyKt.lazy(() -> SdesChunk.sdesItems_delegate$lambda$0(buffer, offset));
    }

    public final int getSizeBytes() {
        Lazy lazy = this.sizeBytes$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final long getSsrc() {
        Lazy lazy = this.ssrc$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @NotNull
    public final List<SdesItem> getSdesItems() {
        Lazy lazy = this.sdesItems$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final int sizeBytes_delegate$lambda$0(SdesChunk this$0) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this$0.getSdesItems();
        int n = 4;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            SdesItem sdesItem = (SdesItem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getSizeBytes());
        }
        collection = (List)destination$iv$iv;
        int dataSize = n + CollectionsKt.sumOfInt((Iterable)collection);
        return dataSize + RtpUtils.Companion.getNumPaddingBytes(dataSize);
    }

    private static final long ssrc_delegate$lambda$0(byte[] $buffer, int $offset) {
        return Companion.getSsrc($buffer, $offset);
    }

    private static final List sdesItems_delegate$lambda$0(byte[] $buffer, int $offset) {
        return Companion.getSdesItems($buffer, $offset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/rtp/rtcp/SdesChunk$Companion;", "", "<init>", "()V", "SSRC_OFFSET", "", "SDES_ITEMS_OFFSET", "getSsrc", "", "buf", "", "baseOffset", "getSdesItems", "", "Lorg/jitsi/rtp/rtcp/SdesItem;", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final long getSsrc(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getIntAsLong(buf, baseOffset + 0);
        }

        @NotNull
        public final List<SdesItem> getSdesItems(@NotNull byte[] buf, int baseOffset) {
            SdesItem currItem;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int currOffset = baseOffset + 4;
            List sdesItems = new ArrayList();
            while (!Intrinsics.areEqual((Object)(currItem = SdesItem.Companion.parse(buf, currOffset)), (Object)EmptySdesItem.INSTANCE)) {
                sdesItems.add(currItem);
                currOffset += currItem.getSizeBytes();
            }
            return sdesItems;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

