/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.vp9;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.VideoCodecParser;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.rtp.codec.vpx.VpxRtpLayerDesc;
import org.jitsi.nlj.util.StateChangeLogger;
import org.jitsi.rtp.extensions.ByteArrayBufferKt;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000Rb\u0010\u000e\u001aV\u0012\u0004\u0012\u00020\u0010\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\u00110\u000fj*\u0012\u0004\u0012\u00020\u0010\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\u0011`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Parser;", "Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "source", "Lorg/jitsi/nlj/MediaSourceDesc;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/MediaSourceDesc;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "pictureIdState", "Lorg/jitsi/nlj/util/StateChangeLogger;", "extendedPictureIdState", "numSpatialLayers", "", "ssrcsInfo", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "parse", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "addTemporalLayers", "", "layers", "", "Lorg/jitsi/nlj/RtpLayerDesc;", "sid", "maxTid", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nVp9Parser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vp9Parser.kt\norg/jitsi/nlj/rtp/codec/vp9/Vp9Parser\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n382#2,7:158\n37#3,2:165\n37#3,2:169\n1869#4,2:167\n1#5:171\n*S KotlinDebug\n*F\n+ 1 Vp9Parser.kt\norg/jitsi/nlj/rtp/codec/vp9/Vp9Parser\n*L\n53#1:158,7\n89#1:165,2\n124#1:169,2\n109#1:167,2\n*E\n"})
public final class Vp9Parser
extends VideoCodecParser {
    @NotNull
    private final Logger logger;
    @NotNull
    private final StateChangeLogger pictureIdState;
    @NotNull
    private final StateChangeLogger extendedPictureIdState;
    private int numSpatialLayers;
    @NotNull
    private final HashMap<Long, HashMap<Integer, Integer>> ssrcsInfo;

    public Vp9Parser(@NotNull MediaSourceDesc source, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super(source);
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.pictureIdState = new StateChangeLogger("missing picture id", this.logger);
        this.extendedPictureIdState = new StateChangeLogger("missing extended picture ID", this.logger);
        this.numSpatialLayers = -1;
        this.ssrcsInfo = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(@NotNull PacketInfo packetInfo) {
        List layers;
        boolean changed;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        Vp9Packet vp9Packet = (Vp9Packet)((Object)packetInfo.packetAs());
        Map map = this.ssrcsInfo;
        Long key$iv = vp9Packet.getSsrc();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        HashMap layerMap = (HashMap)object;
        Integer n = (Integer)layerMap.get(vp9Packet.getSpatialLayerIndex());
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            ((Map)layerMap).put(vp9Packet.getSpatialLayerIndex(), Math.max(it, vp9Packet.getTemporalLayerIndex()));
        } else {
            Vp9Parser $this$parse_u24lambda_u242 = this;
            boolean bl = false;
            ((Map)layerMap).put(vp9Packet.getSpatialLayerIndex(), vp9Packet.getTemporalLayerIndex());
        }
        if (vp9Packet.getHasScalabilityStructure()) {
            RtpEncodingDesc ss;
            RtpEncodingDesc rtpEncodingDesc;
            int packetSpatialLayers = vp9Packet.getScalabilityStructureNumSpatial();
            if (packetSpatialLayers != -1) {
                if (this.numSpatialLayers != -1 && this.numSpatialLayers != packetSpatialLayers) {
                    packetInfo.setLayeringChanged(true);
                }
                this.numSpatialLayers = packetSpatialLayers;
            }
            RtpEncodingDesc rtpEncodingDesc2 = this.findRtpEncodingDesc(vp9Packet);
            if (rtpEncodingDesc2 != null) {
                RtpEncodingDesc enc = rtpEncodingDesc2;
                boolean bl = false;
                rtpEncodingDesc = Vp9Packet.getScalabilityStructure$default(vp9Packet, enc.getEid(), 0.0, 2, null);
            } else {
                rtpEncodingDesc = ss = null;
            }
            if (ss != null) {
                RtpLayerDesc[] rtpLayerDescArray;
                if (vp9Packet.isFlexibleMode()) {
                    List layersList = ArraysKt.toMutableList((Object[])ss.getLayers$jitsi_media_transform());
                    for (Map.Entry bl : ((Map)layerMap).entrySet()) {
                        int sid = ((Number)bl.getKey()).intValue();
                        int maxTid = ((Number)bl.getValue()).intValue();
                        this.addTemporalLayers(layersList, sid, maxTid);
                    }
                    Collection $this$toTypedArray$iv = layersList;
                    int $i$f$toTypedArray = 0;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    rtpLayerDescArray = thisCollection$iv.toArray(new RtpLayerDesc[0]);
                } else {
                    rtpLayerDescArray = ss.getLayers$jitsi_media_transform();
                }
                RtpLayerDesc[] layers2 = rtpLayerDescArray;
                this.getSource().setEncodingLayers(layers2, vp9Packet.getSsrc());
                for (RtpEncodingDesc otherEnc : this.getSource().getRtpEncodings()) {
                    if (((Map)this.ssrcsInfo).containsKey(otherEnc.getPrimarySSRC())) continue;
                    this.getSource().setEncodingLayers(new RtpLayerDesc[0], otherEnc.getPrimarySSRC());
                }
            }
        }
        if (vp9Packet.getSpatialLayerIndex() > 0 && vp9Packet.isInterPicturePredicted()) {
            Iterable $this$forEach$iv = this.findRtpLayerDescs(vp9Packet);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtpLayerDesc it = (RtpLayerDesc)element$iv;
                boolean bl = false;
                if (!(it instanceof VpxRtpLayerDesc)) continue;
                ((VpxRtpLayerDesc)it).setUseSoftDependencies(vp9Packet.getUsesInterLayerDependency());
            }
        }
        if (vp9Packet.isFlexibleMode() && this.findRtpLayerDescs(vp9Packet).isEmpty() && (changed = this.addTemporalLayers(layers = ArraysKt.toMutableList((Object[])this.getSource().getEncodingLayers(vp9Packet.getSsrc())), vp9Packet.getSpatialLayerIndex(), vp9Packet.getTemporalLayerIndex()))) {
            Collection $this$toTypedArray$iv = layers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.getSource().setEncodingLayers(thisCollection$iv.toArray(new RtpLayerDesc[0]), vp9Packet.getSsrc());
            packetInfo.setLayeringChanged(true);
        }
        this.pictureIdState.setState(vp9Packet.getHasPictureId(), (Object)vp9Packet, (Function0<String>)((Function0)() -> Vp9Parser.parse$lambda$5(vp9Packet)));
        this.extendedPictureIdState.setState(vp9Packet.getHasExtendedPictureId(), (Object)vp9Packet, (Function0<String>)((Function0)() -> Vp9Parser.parse$lambda$6(vp9Packet)));
    }

    private final boolean addTemporalLayers(List<RtpLayerDesc> layers, int sid, int maxTid) {
        boolean changed = false;
        int tid = 1;
        if (tid <= maxTid) {
            while (true) {
                Object object;
                block6: {
                    Iterable iterable = layers;
                    for (Object object2 : iterable) {
                        RtpLayerDesc it = (RtpLayerDesc)object2;
                        boolean bl = false;
                        if (!(it.getSid() == sid && it.getTid() == tid)) continue;
                        object = object2;
                        break block6;
                    }
                    object = null;
                }
                RtpLayerDesc layer = (RtpLayerDesc)object;
                if (layer == null) {
                    Object v1;
                    block7: {
                        Object object2;
                        Iterable iterable = layers;
                        object2 = iterable.iterator();
                        while (object2.hasNext()) {
                            Object e = object2.next();
                            RtpLayerDesc it = (RtpLayerDesc)e;
                            boolean bl = false;
                            if (!(it.getSid() == sid && it.getTid() == tid - 1)) continue;
                            v1 = e;
                            break block7;
                        }
                        v1 = null;
                    }
                    RtpLayerDesc prevLayer = v1;
                    if (prevLayer != null) {
                        RtpLayerDesc newLayer = RtpLayerDesc.copy$default(prevLayer, 0, tid, false, 1, null);
                        layers.add(newLayer);
                        changed = true;
                    }
                }
                if (tid == maxTid) break;
                ++tid;
            }
        }
        return changed;
    }

    private static final String parse$lambda$5(Vp9Packet $vp9Packet) {
        return "Packet Data: " + ByteArrayBufferKt.toHex((ByteArrayBuffer)((ByteArrayBuffer)$vp9Packet), (int)80);
    }

    private static final String parse$lambda$6(Vp9Packet $vp9Packet) {
        return "Packet Data: " + ByteArrayBufferKt.toHex((ByteArrayBuffer)((ByteArrayBuffer)$vp9Packet), (int)80);
    }
}

