/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 02\u00020\u0001:\u00010BU\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012B)\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0013J\u000e\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020(J\u0006\u0010/\u001a\u00020&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u0011\u0010+\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001aR\u0011\u0010-\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001a\u00a8\u00061"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9FrameProjection;", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "vp9Frame", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "ssrc", "", "timestamp", "sequenceNumberDelta", "", "pictureId", "tl0PICIDX", "mark", "", "created", "Ljava/time/Instant;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;JJIIIZLjava/time/Instant;)V", "(Lorg/jitsi/utils/logging/DiagnosticContext;JIJ)V", "getVp9Frame", "()Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "getSsrc", "()J", "getTimestamp", "getPictureId", "()I", "getTl0PICIDX", "getMark", "()Z", "getCreated", "()Ljava/time/Instant;", "value", "closedSeq", "getClosedSeq", "rewriteSeqNo", "seq", "rewriteRtp", "", "pkt", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "accept", "rtpPacket", "earliestProjectedSeqNum", "getEarliestProjectedSeqNum", "latestProjectedSeqNum", "getLatestProjectedSeqNum", "close", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nVp9FrameProjection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vp9FrameProjection.kt\norg/jitsi/videobridge/cc/vp9/Vp9FrameProjection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class Vp9FrameProjection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @Nullable
    private final Vp9Frame vp9Frame;
    private final long ssrc;
    private final long timestamp;
    private final int sequenceNumberDelta;
    private final int pictureId;
    private final int tl0PICIDX;
    private final boolean mark;
    @Nullable
    private final Instant created;
    private int closedSeq;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(Vp9FrameProjection.class);

    public Vp9FrameProjection(@NotNull DiagnosticContext diagnosticContext, @Nullable Vp9Frame vp9Frame, long ssrc, long timestamp, int sequenceNumberDelta, int pictureId, int tl0PICIDX, boolean mark, @Nullable Instant created) {
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        this.vp9Frame = vp9Frame;
        this.ssrc = ssrc;
        this.timestamp = timestamp;
        this.sequenceNumberDelta = sequenceNumberDelta;
        this.pictureId = pictureId;
        this.tl0PICIDX = tl0PICIDX;
        this.mark = mark;
        this.created = created;
        this.closedSeq = -1;
    }

    @Nullable
    public final Vp9Frame getVp9Frame() {
        return this.vp9Frame;
    }

    public final long getSsrc() {
        return this.ssrc;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int getPictureId() {
        return this.pictureId;
    }

    public final int getTl0PICIDX() {
        return this.tl0PICIDX;
    }

    public final boolean getMark() {
        return this.mark;
    }

    @Nullable
    public final Instant getCreated() {
        return this.created;
    }

    public final int getClosedSeq() {
        return this.closedSeq;
    }

    public Vp9FrameProjection(@NotNull DiagnosticContext diagnosticContext, long ssrc, int sequenceNumberDelta, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        this(diagnosticContext, null, ssrc, timestamp, sequenceNumberDelta, 0, 0, false, null);
    }

    public final int rewriteSeqNo(int seq) {
        return RtpUtils.Companion.applySequenceNumberDelta(seq, this.sequenceNumberDelta);
    }

    public final void rewriteRtp(@NotNull Vp9Packet pkt) {
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        int sequenceNumber = this.rewriteSeqNo(pkt.getSequenceNumber());
        if (timeSeriesLogger.isTraceEnabled()) {
            timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("rtp_vp9_rewrite").addField("orig.rtp.ssrc", (Object)pkt.getSsrc()).addField("orig.rtp.timestamp", (Object)pkt.getTimestamp()).addField("orig.rtp.seq", (Object)pkt.getSequenceNumber()).addField("orig.vp9.pictureid", (Object)pkt.getPictureId()).addField("orig.vp9.tl0picidx", (Object)pkt.getTL0PICIDX()).addField("proj.rtp.ssrc", (Object)this.ssrc).addField("proj.rtp.timestamp", (Object)this.timestamp).addField("proj.rtp.seq", (Object)sequenceNumber).addField("proj.vp9.pictureid", (Object)this.pictureId).addField("proj.vp9.tl0picidx", (Object)this.tl0PICIDX).addField("proj.rtp.mark", (Object)this.mark));
        }
        pkt.setSsrc(this.ssrc);
        pkt.setTimestamp(this.timestamp);
        pkt.setSequenceNumber(sequenceNumber);
        if (pkt.getHasTL0PICIDX()) {
            pkt.setTL0PICIDX(this.tl0PICIDX);
        }
        pkt.setPictureId(this.pictureId);
        if (this.mark && pkt.isEndOfFrame()) {
            pkt.setMarked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean accept(@NotNull Vp9Packet rtpPacket) {
        Intrinsics.checkNotNullParameter((Object)rtpPacket, (String)"rtpPacket");
        Vp9Frame vp9Frame = this.vp9Frame;
        if (!(vp9Frame != null ? vp9Frame.matchesFrame(rtpPacket) : false)) {
            return false;
        }
        Vp9Frame vp9Frame2 = this.vp9Frame;
        synchronized (vp9Frame2) {
            boolean bl = false;
            boolean bl2 = this.closedSeq < 0 ? true : RtpUtilsKt.isOlderThan((int)rtpPacket.getSequenceNumber(), (int)this.closedSeq);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getEarliestProjectedSeqNum() {
        if (this.vp9Frame == null) {
            return this.sequenceNumberDelta;
        }
        Vp9Frame vp9Frame = this.vp9Frame;
        synchronized (vp9Frame) {
            boolean bl = false;
            int n = this.rewriteSeqNo(this.vp9Frame.getEarliestKnownSequenceNumber());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLatestProjectedSeqNum() {
        if (this.vp9Frame == null) {
            return this.sequenceNumberDelta;
        }
        Vp9Frame vp9Frame = this.vp9Frame;
        synchronized (vp9Frame) {
            boolean bl = false;
            int n = this.rewriteSeqNo(this.vp9Frame.getLatestKnownSequenceNumber());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.vp9Frame != null) {
            Vp9Frame vp9Frame = this.vp9Frame;
            synchronized (vp9Frame) {
                boolean bl = false;
                this.closedSeq = this.vp9Frame.getLatestKnownSequenceNumber();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9FrameProjection$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

