/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.combobox.LocaleComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;

class MovieScraperNfoSettingsPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener;
    private final ItemListener comboBoxListener;
    private JComboBox<MovieConnectors> cbNfoFormat;
    private JCheckBox cbMovieNfoFilename1;
    private JCheckBox cbMovieNfoFilename2;
    private JComboBox<CertificationStyleWrapper> cbCertificationStyle;
    private JCheckBox chckbxWriteCleanNfo;
    private final List<LocaleComboBox> locales = new ArrayList<LocaleComboBox>();
    private JComboBox cbNfoLanguage;
    private JComboBox<DateField> cbDatefield;
    private JCheckBox chckbxCreateOutline;
    private JCheckBox chckbxOutlineFirstSentence;
    private JCheckBox chckbxSingleStudio;
    private JCheckBox chckbxNfoDiscKodiStyle;
    private JCheckBox chckbxLockdata;
    private JCheckBox chckbxTrailer;
    private JCheckBox chckbxFileinfo;
    private JCheckBox chckbxDateAdded;
    private JCheckBox chckbxArtworkUrls;

    MovieScraperNfoSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.comboBoxListener = e -> this.checkChanges();
        LocaleComboBox actualLocale = null;
        LocaleComboBox fallbackLocale = null;
        Locale settingsLang = Utils.getLocaleFromLanguage(this.settings.getNfoLanguage().toString());
        for (Locale l : Utils.getLanguages()) {
            LocaleComboBox localeComboBox = new LocaleComboBox(l);
            this.locales.add(localeComboBox);
            if (l.equals(settingsLang)) {
                actualLocale = localeComboBox;
            }
            if (!settingsLang.getLanguage().equals(l.getLanguage())) continue;
            fallbackLocale = localeComboBox;
        }
        Collections.sort(this.locales);
        this.initComponents();
        this.initDataBindings();
        if (actualLocale != null) {
            this.cbNfoLanguage.setSelectedItem(actualLocale);
        } else {
            this.cbNfoLanguage.setSelectedItem(fallbackLocale);
        }
        this.cbNfoLanguage.addItemListener(this.comboBoxListener);
        this.cbNfoFormat.addItemListener(e -> {
            block2: {
                block3: {
                    if (this.cbNfoFormat.getSelectedItem() != MovieConnectors.MP) break block3;
                    for (int i = 0; i < this.cbCertificationStyle.getItemCount(); ++i) {
                        CertificationStyleWrapper wrapper = this.cbCertificationStyle.getItemAt(i);
                        if (wrapper.style != CertificationStyle.TECHNICAL) continue;
                        this.cbCertificationStyle.setSelectedItem(wrapper);
                        break block2;
                    }
                    break block2;
                }
                if (this.cbNfoFormat.getSelectedItem() != MovieConnectors.XBMC) break block2;
                for (int i = 0; i < this.cbCertificationStyle.getItemCount(); ++i) {
                    CertificationStyleWrapper wrapper = this.cbCertificationStyle.getItemAt(i);
                    if (wrapper.style != CertificationStyle.LARGE) continue;
                    this.cbCertificationStyle.setSelectedItem(wrapper);
                    break;
                }
            }
        });
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName()) || "wizard".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
                this.buildComboBoxes();
            }
        });
        this.buildCheckBoxes();
        this.buildComboBoxes();
    }

    private void buildCheckBoxes() {
        this.cbMovieNfoFilename1.removeItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename2.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.cbMovieNfoFilename1, this.cbMovieNfoFilename2);
        List<MovieNfoNaming> movieNfoFilenames = this.settings.getNfoFilenames();
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.FILENAME_NFO)) {
            this.cbMovieNfoFilename1.setSelected(true);
        }
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.MOVIE_NFO)) {
            this.cbMovieNfoFilename2.setSelected(true);
        }
        this.cbMovieNfoFilename1.addItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename2.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    private void buildComboBoxes() {
        this.cbCertificationStyle.removeItemListener(this.comboBoxListener);
        this.cbCertificationStyle.removeAllItems();
        for (CertificationStyle style : CertificationStyle.values()) {
            CertificationStyleWrapper wrapper = new CertificationStyleWrapper();
            wrapper.style = style;
            this.cbCertificationStyle.addItem(wrapper);
            if (style != this.settings.getCertificationStyle()) continue;
            this.cbCertificationStyle.setSelectedItem(wrapper);
        }
        this.cbCertificationStyle.addItemListener(this.comboBoxListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelNfo = new JPanel();
        panelNfo.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][15lp!][][][][15lp!][][][][15lp!][][][][][][]"));
        TmmLabel lblNfoT = new TmmLabel(TmmResourceBundle.getString("Settings.nfo"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelNfo, lblNfoT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#nfo-settings"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblNfoFormat = new JLabel(TmmResourceBundle.getString("Settings.nfoFormat"));
        panelNfo.add((Component)lblNfoFormat, "cell 1 0 2 1");
        this.cbNfoFormat = new JComboBox<MovieConnectors>(MovieConnectors.values());
        panelNfo.add(this.cbNfoFormat, "cell 1 0 2 1");
        DocsButton docsButton = new DocsButton("/movies/nfo-formats");
        panelNfo.add((Component)docsButton, "cell 1 0 2 1");
        JPanel panelNfoFormat = new JPanel();
        panelNfo.add((Component)panelNfoFormat, "cell 1 1 2 1");
        panelNfoFormat.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][]"));
        JLabel lblNfoFileNaming = new JLabel(TmmResourceBundle.getString("Settings.nofFileNaming"));
        panelNfoFormat.add((Component)lblNfoFileNaming, "cell 0 0");
        this.cbMovieNfoFilename1 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + ".nfo");
        panelNfoFormat.add((Component)this.cbMovieNfoFilename1, "cell 1 0");
        this.cbMovieNfoFilename2 = new JCheckBox("movie.nfo");
        panelNfoFormat.add((Component)this.cbMovieNfoFilename2, "cell 1 1");
        this.chckbxNfoDiscKodiStyle = new JCheckBox(TmmResourceBundle.getString("Settings.nfoDiscFolder"));
        panelNfo.add((Component)this.chckbxNfoDiscKodiStyle, "cell 2 2");
        this.chckbxWriteCleanNfo = new JCheckBox(TmmResourceBundle.getString("Settings.writecleannfo"));
        panelNfo.add((Component)this.chckbxWriteCleanNfo, "cell 1 3 2 1");
        JLabel lblNfoLanguage = new JLabel(TmmResourceBundle.getString("Settings.nfolanguage"));
        panelNfo.add((Component)lblNfoLanguage, "cell 1 5 2 1");
        this.cbNfoLanguage = new JComboBox<Object>(this.locales.toArray());
        panelNfo.add((Component)this.cbNfoLanguage, "cell 1 5 2 1");
        JLabel lblNfoLanguageDesc = new JLabel(TmmResourceBundle.getString("Settings.nfolanguage.desc"));
        panelNfo.add((Component)lblNfoLanguageDesc, "cell 2 6");
        JLabel lblCertificationStyle = new JLabel(TmmResourceBundle.getString("Settings.certificationformat"));
        panelNfo.add((Component)lblCertificationStyle, "flowx,cell 1 7 2 1");
        this.cbCertificationStyle = new JComboBox();
        panelNfo.add(this.cbCertificationStyle, "cell 1 7 2 1,wmin 0");
        this.chckbxCreateOutline = new JHintCheckBox(TmmResourceBundle.getString("Settings.createoutline"));
        this.chckbxCreateOutline.setToolTipText(TmmResourceBundle.getString("Settings.createoutline.hint"));
        panelNfo.add((Component)this.chckbxCreateOutline, "cell 1 9 2 1");
        this.chckbxOutlineFirstSentence = new JCheckBox(TmmResourceBundle.getString("Settings.outlinefirstsentence"));
        panelNfo.add((Component)this.chckbxOutlineFirstSentence, "cell 2 10");
        this.chckbxSingleStudio = new JCheckBox(TmmResourceBundle.getString("Settings.singlestudio"));
        panelNfo.add((Component)this.chckbxSingleStudio, "cell 1 11 2 1");
        this.chckbxDateAdded = new JCheckBox(TmmResourceBundle.getString("Settings.nfo.dateadded"));
        panelNfo.add((Component)this.chckbxDateAdded, "cell 1 13 2 1");
        JLabel lblNfoDatefield = new JLabel(TmmResourceBundle.getString("Settings.dateadded"));
        panelNfo.add((Component)lblNfoDatefield, "flowx,cell 2 14");
        this.chckbxArtworkUrls = new JHintCheckBox(TmmResourceBundle.getString("Settings.nfo.artworkurls"));
        this.chckbxArtworkUrls.setToolTipText(TmmResourceBundle.getString("Settings.nfo.artworkurls.hint"));
        panelNfo.add((Component)this.chckbxArtworkUrls, "cell 1 15 2 1");
        this.chckbxTrailer = new JHintCheckBox(TmmResourceBundle.getString("Settings.nfo.trailer"));
        this.chckbxTrailer.setToolTipText(TmmResourceBundle.getString("Settings.nfo.trailer.hint"));
        panelNfo.add((Component)this.chckbxTrailer, "cell 1 16 2 1");
        this.chckbxFileinfo = new JHintCheckBox(TmmResourceBundle.getString("Settings.nfo.fileinfo"));
        this.chckbxFileinfo.setToolTipText(TmmResourceBundle.getString("Settings.nfo.fileinfo.hint"));
        panelNfo.add((Component)this.chckbxFileinfo, "cell 1 17 2 1");
        this.chckbxLockdata = new JHintCheckBox(TmmResourceBundle.getString("Settings.lockdata"));
        this.chckbxLockdata.setToolTipText(TmmResourceBundle.getString("Settings.lockdata.hint"));
        panelNfo.add((Component)this.chckbxLockdata, "cell 1 18 2 1");
        this.cbDatefield = new JComboBox<DateField>(DateField.values());
        panelNfo.add(this.cbDatefield, "cell 2 14");
    }

    private void checkChanges() {
        CertificationStyleWrapper wrapper;
        LocaleComboBox loc = (LocaleComboBox)this.cbNfoLanguage.getSelectedItem();
        if (loc != null) {
            Locale actualLocale = this.settings.getNfoLanguage();
            if (!loc.getLocale().equals(actualLocale)) {
                this.settings.setNfoLanguage(loc.getLocale());
            }
        }
        this.settings.clearNfoFilenames();
        if (this.cbMovieNfoFilename1.isSelected()) {
            this.settings.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        }
        if (this.cbMovieNfoFilename2.isSelected()) {
            this.settings.addNfoFilename(MovieNfoNaming.MOVIE_NFO);
        }
        if ((wrapper = (CertificationStyleWrapper)this.cbCertificationStyle.getSelectedItem()) != null && this.settings.getCertificationStyle() != wrapper.style) {
            this.settings.setCertificationStyle(wrapper.style);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"movieConnector");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, this.cbNfoFormat, (Property)jComboBoxBeanProperty_1);
        autoBinding_9.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"writeCleanNfo");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxWriteCleanNfo, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"createOutline");
        BeanProperty jHintCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxCreateOutline, (Property)jHintCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"outlineFirstSentence");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxOutlineFirstSentence, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxCreateOutline, (Property)jHintCheckBoxBeanProperty, (Object)this.chckbxOutlineFirstSentence, (Property)jCheckBoxBeanProperty_1);
        autoBinding_4.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"nfoDateAddedField");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, this.cbDatefield, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSettingsBeanProperty_5 = BeanProperty.create((String)"nfoWriteSingleStudio");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_5, (Object)this.chckbxSingleStudio, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty movieSettingsBeanProperty_6 = BeanProperty.create((String)"nfoDiscFolderInside");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_6, (Object)this.chckbxNfoDiscKodiStyle, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty movieSettingsBeanProperty_7 = BeanProperty.create((String)"nfoWriteLockdata");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_7, (Object)this.chckbxLockdata, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"nfoWriteTrailer");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, (Object)this.chckbxTrailer, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_8 = BeanProperty.create((String)"nfoWriteFileinfo");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_8, (Object)this.chckbxFileinfo, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
        BeanProperty movieSettingsBeanProperty_9 = BeanProperty.create((String)"nfoWriteDateAdded");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_9, (Object)this.chckbxDateAdded, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty movieSettingsBeanProperty_10 = BeanProperty.create((String)"nfoWriteArtworkUrls");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_10, (Object)this.chckbxArtworkUrls, (Property)jCheckBoxBeanProperty);
        autoBinding_12.bind();
    }

    private static class CertificationStyleWrapper {
        private CertificationStyle style;

        private CertificationStyleWrapper() {
        }

        public String toString() {
            String bundleTag = TmmResourceBundle.getString("Settings.certification." + this.style.name().toLowerCase(Locale.ROOT));
            return bundleTag.replace("{}", CertificationStyle.formatCertification(MediaCertification.DE_FSK16, this.style));
        }
    }
}

