/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatTableUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;

public class TmmTableUI
extends FlatTableUI {
    private Color selectedGridColor;

    public static ComponentUI createUI(JComponent c) {
        return new TmmTableUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (UIManager.getBoolean("Table.paintTmmGrid")) {
            this.selectedGridColor = UIManager.getColor("Table.selectedGridColor");
            this.table.remove(this.rendererPane);
            this.rendererPane = this.createCustomCellRendererPane();
            this.table.add(this.rendererPane);
        }
    }

    private CellRendererPane createCustomCellRendererPane() {
        return new CellRendererPane(){

            @Override
            public void paintComponent(Graphics graphics, Component component, Container container, int x, int y, int w, int h, boolean shouldValidate) {
                Point point = new Point(x, y);
                int rowAtPoint = TmmTableUI.this.table.rowAtPoint(point);
                int columnAtPoint = TmmTableUI.this.table.columnAtPoint(point);
                boolean isSelected = TmmTableUI.this.table.isRowSelected(rowAtPoint);
                Object prop = TmmTableUI.this.table.getClientProperty("borderNotToDraw");
                ArrayList colsNotToDraw = new ArrayList();
                if (prop instanceof List) {
                    try {
                        colsNotToDraw.addAll((List)prop);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (component instanceof JCheckBox) {
                    ((JCheckBox)component).setContentAreaFilled(false);
                }
                if (component instanceof JComponent) {
                    JComponent jcomponent = (JComponent)component;
                    jcomponent.setOpaque(isSelected);
                    if (isSelected) {
                        jcomponent.setBorder(BorderFactory.createCompoundBorder(new BottomSideBorder(TmmTableUI.this.selectedGridColor), jcomponent.getBorder()));
                    }
                    if (isSelected && !colsNotToDraw.contains(columnAtPoint) && columnAtPoint != TmmTableUI.this.table.getColumnCount() - 1) {
                        jcomponent.setBorder(BorderFactory.createCompoundBorder(new RightSideBorder(TmmTableUI.this.selectedGridColor), jcomponent.getBorder()));
                    }
                }
                super.paintComponent(graphics, component, container, x, y, w, h, shouldValidate);
            }
        };
    }

    private static class RightSideBorder
    extends AbstractBorder {
        private static final int THICKNESS = 1;
        private final Color color;

        public RightSideBorder(Color color) {
            this.color = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(this.color);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(width - 1, 0, width - 1, height - 1);
            g2d.dispose();
        }
    }

    private static class BottomSideBorder
    extends AbstractBorder {
        private static final int THICKNESS = 1;
        private final Color color;

        public BottomSideBorder(Color color) {
            this.color = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(this.color);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(0, height - 1, width - 1, height - 1);
            g2d.dispose();
        }
    }
}

