/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractAlterer;
import io.jenetics.Alterer;
import io.jenetics.AltererResult;
import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.util.ISeq;
import io.jenetics.util.Seq;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CompositeAlterer<G extends Gene<?, G>, C extends Comparable<? super C>>
extends AbstractAlterer<G, C> {
    private final ISeq<Alterer<G, C>> _alterers;

    CompositeAlterer(Seq<Alterer<G, C>> alterers) {
        super(1.0);
        this._alterers = CompositeAlterer.normalize(alterers);
    }

    private static <G extends Gene<?, G>, C extends Comparable<? super C>> ISeq<Alterer<G, C>> normalize(Seq<Alterer<G, C>> alterers) {
        Function<Alterer, Stream> mapper = a -> a instanceof CompositeAlterer ? ((CompositeAlterer)a).getAlterers().stream() : Stream.of(a);
        return alterers.stream().flatMap(mapper).collect(ISeq.toISeq());
    }

    @Override
    public AltererResult<G, C> alter(Seq<Phenotype<G, C>> population, long generation) {
        AltererResult<G, C> result = AltererResult.of(population.asISeq());
        for (Alterer alterer : this._alterers) {
            AltererResult<G, C> as = alterer.alter(result.getPopulation(), generation);
            result = AltererResult.of(as.getPopulation(), as.getAlterations() + result.getAlterations());
        }
        return result;
    }

    ISeq<Alterer<G, C>> getAlterers() {
        return this._alterers;
    }

    @Override
    public int hashCode() {
        return 17 + 31 * this._alterers.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof CompositeAlterer && Objects.equals(((CompositeAlterer)obj)._alterers, this._alterers);
    }

    public String toString() {
        return String.format("%s:\n%s", this.getClass().getSimpleName(), this._alterers.stream().map(a -> "   - " + a).collect(Collectors.joining("\n")));
    }

    @SafeVarargs
    static <G extends Gene<?, G>, C extends Comparable<? super C>> CompositeAlterer<G, C> of(Alterer<G, C> ... alterers) {
        return new CompositeAlterer<G, C>(ISeq.of(alterers));
    }

    static <T extends Gene<?, T>, C extends Comparable<? super C>> CompositeAlterer<T, C> join(Alterer<T, C> a1, Alterer<T, C> a2) {
        return CompositeAlterer.of(a1, a2);
    }
}

