/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.ProbabilitySelector;
import io.jenetics.util.Seq;

public final class LinearRankSelector<G extends Gene<?, G>, C extends Comparable<? super C>>
extends ProbabilitySelector<G, C> {
    private final double _nminus;
    private final double _nplus;

    public LinearRankSelector(double nminus) {
        super(true);
        if (nminus < 0.0) {
            throw new IllegalArgumentException(String.format("nminus is smaller than zero: %s", nminus));
        }
        this._nminus = nminus;
        this._nplus = 2.0 - this._nminus;
    }

    public LinearRankSelector() {
        this(0.5);
    }

    @Override
    protected double[] probabilities(Seq<Phenotype<G, C>> population, int count) {
        assert (population != null) : "Population must not be null. ";
        assert (!population.isEmpty()) : "Population is empty.";
        assert (count > 0) : "Population to select must be greater than zero. ";
        double N = population.size();
        double[] probabilities = new double[population.size()];
        if (N == 1.0) {
            probabilities[0] = 1.0;
        } else {
            int i = probabilities.length;
            while (--i >= 0) {
                probabilities[probabilities.length - i - 1] = (this._nminus + (this._nplus - this._nminus) * (double)i / (N - 1.0)) / N;
            }
        }
        return probabilities;
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * Double.hashCode(this._nminus) + 37;
        return hash += 31 * Double.hashCode(this._nplus) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LinearRankSelector && Double.compare(((LinearRankSelector)obj)._nminus, this._nminus) == 0 && Double.compare(((LinearRankSelector)obj)._nplus, this._nplus) == 0;
    }

    public String toString() {
        return String.format("%s[(n-)=%f, (n+)=%f]", this.getClass().getSimpleName(), this._nminus, this._nplus);
    }
}

