/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.engine.CompositeCodec;
import io.jenetics.util.Factory;
import io.jenetics.util.ISeq;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface Codec<T, G extends Gene<?, G>> {
    public Factory<Genotype<G>> encoding();

    public Function<Genotype<G>, T> decoder();

    default public T decode(Genotype<G> genotype) {
        Objects.requireNonNull(genotype);
        return this.decoder().apply(genotype);
    }

    default public <B> Codec<B, G> map(Function<? super T, ? extends B> mapper) {
        Objects.requireNonNull(mapper);
        return Codec.of(this.encoding(), (Genotype<G> gt) -> mapper.apply((T)this.decode((Genotype<G>)gt)));
    }

    public static <G extends Gene<?, G>, T> Codec<T, G> of(final Factory<Genotype<G>> encoding, final Function<Genotype<G>, T> decoder) {
        Objects.requireNonNull(encoding);
        Objects.requireNonNull(decoder);
        return new Codec<T, G>(){

            @Override
            public Factory<Genotype<G>> encoding() {
                return encoding;
            }

            @Override
            public Function<Genotype<G>, T> decoder() {
                return decoder;
            }
        };
    }

    public static <G extends Gene<?, G>, A, B, T> Codec<T, G> of(Codec<A, G> codec1, Codec<B, G> codec2, BiFunction<A, B, T> decoder) {
        Function<Object[], Object> decoderAdapter = v -> decoder.apply(v[0], v[1]);
        return Codec.of(ISeq.of(codec1, codec2), decoderAdapter);
    }

    public static <G extends Gene<?, G>, T> Codec<T, G> of(ISeq<? extends Codec<?, G>> codecs, Function<? super Object[], ? extends T> decoder) {
        return new CompositeCodec(codecs, decoder);
    }
}

