/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

final class ExecutionTimeLimit
implements Predicate<Object> {
    private final Duration _duration;
    private final Clock _clock;
    private final AtomicReference<Instant> _start = new AtomicReference();

    ExecutionTimeLimit(Duration duration, Clock clock) {
        this._duration = Objects.requireNonNull(duration);
        this._clock = Objects.requireNonNull(clock);
    }

    @Override
    public boolean test(Object ignore) {
        Instant instant = this._clock.instant();
        this._start.compareAndSet(null, instant);
        return this._start.get().plus(this._duration).isAfter(instant);
    }
}

