/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Chromosome;
import io.jenetics.Genotype;
import io.jenetics.NumericGene;
import io.jenetics.Phenotype;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.stat.DoubleMomentStatistics;
import io.jenetics.stat.DoubleMoments;
import io.jenetics.util.ISeq;
import io.jenetics.util.Seq;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Predicate;

final class GeneConvergenceLimit<G extends NumericGene<?, G>>
implements Predicate<EvolutionResult<G, ?>> {
    private final Predicate<DoubleMoments> _convergence;
    private final double _convergenceRate;

    GeneConvergenceLimit(Predicate<DoubleMoments> convergence, double convergenceRate) {
        if (convergenceRate < 0.0 || convergenceRate > 1.0) {
            throw new IllegalArgumentException(String.format("The given convergence rate is not in the range [0, 1]: %f", convergenceRate));
        }
        this._convergence = Objects.requireNonNull(convergence);
        this._convergenceRate = convergenceRate;
    }

    @Override
    public boolean test(EvolutionResult<G, ?> result) {
        ISeq<DoubleMoments> stat = GeneConvergenceLimit.statistics(result.getPopulation());
        return result.getTotalGenerations() <= 1L || (double)stat.stream().filter(this._convergence).count() <= this._convergenceRate * (double)stat.size();
    }

    static <G extends NumericGene<?, G>> ISeq<DoubleMoments> statistics(Seq<? extends Phenotype<G, ?>> population) {
        HashMap<Long, DoubleMomentStatistics> statistics = new HashMap<Long, DoubleMomentStatistics>();
        for (Phenotype<G, ?> pt : population) {
            Genotype<G> gt = pt.getGenotype();
            for (int i = 0; i < gt.length(); ++i) {
                Chromosome<G> ch = gt.getChromosome(i);
                for (int j = 0; j < ch.length(); ++j) {
                    statistics.computeIfAbsent((long)i << 32 | (long)j & 0xFFFFFFFFL, k -> new DoubleMomentStatistics()).accept(((NumericGene)ch.getGene(j)).doubleValue());
                }
            }
        }
        return statistics.values().stream().map(DoubleMomentStatistics::toDoubleMoments).collect(ISeq.toISeq());
    }
}

