/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Optimize;
import io.jenetics.engine.EvolutionResult;
import java.util.function.Predicate;

final class SteadyFitnessLimit<C extends Comparable<? super C>>
implements Predicate<EvolutionResult<?, C>> {
    private final int _generations;
    private boolean _proceed = true;
    private int _stable = 0;
    private C _fitness;

    SteadyFitnessLimit(int generations) {
        if (generations < 1) {
            throw new IllegalArgumentException("Generations < 1: " + generations);
        }
        this._generations = generations;
    }

    @Override
    public boolean test(EvolutionResult<?, C> result) {
        if (!this._proceed) {
            return false;
        }
        if (this._fitness == null) {
            this._fitness = result.getBestFitness();
            this._stable = 1;
        } else {
            Optimize opt = result.getOptimize();
            if (opt.compare(this._fitness, result.getBestFitness()) >= 0) {
                this._proceed = ++this._stable <= this._generations;
            } else {
                this._fitness = result.getBestFitness();
                this._stable = 1;
            }
        }
        return this._proceed;
    }
}

