/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import java.io.Serializable;
import java.util.stream.LongStream;

public final class LongRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long _min;
    private final long _max;

    private LongRange(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("Min greater than max: %s > %s", min, max));
        }
        this._min = min;
        this._max = max;
    }

    public long getMin() {
        return this._min;
    }

    public long getMax() {
        return this._max;
    }

    public LongStream stream() {
        return LongStream.range(this._min, this._max);
    }

    public static LongRange of(long min, long max) {
        return new LongRange(min, max);
    }

    public static LongRange of(long value) {
        return LongRange.of(value, value + 1L);
    }

    public int hashCode() {
        return (int)(this._min + 31L * this._max);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LongRange && this._min == ((LongRange)obj)._min && this._max == ((LongRange)obj)._max;
    }

    public String toString() {
        return "[" + this._min + ", " + this._max + "]";
    }
}

