/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import io.jenetics.util.Seq;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Objects;
import java.util.RandomAccess;

class SeqList<T>
extends AbstractList<T>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Seq<T> seq;

    SeqList(Seq<T> seq) {
        this.seq = Objects.requireNonNull(seq, "Seq must not be null.");
    }

    @Override
    public T get(int index) {
        return this.seq.get(index);
    }

    @Override
    public int size() {
        return this.seq.length();
    }

    @Override
    public int indexOf(Object element) {
        int index = -1;
        if (element == null) {
            for (int i = 0; i < this.seq.length() && index == -1; ++i) {
                if (this.seq.get(i) != null) continue;
                index = i;
            }
        } else {
            for (int i = 0; i < this.seq.length() && index == -1; ++i) {
                if (!element.equals(this.seq.get(i))) continue;
                index = i;
            }
        }
        return index;
    }

    @Override
    public int lastIndexOf(Object element) {
        int index = -1;
        if (element == null) {
            int i = this.seq.length();
            while (--i >= 0 && index == -1) {
                if (this.seq.get(i) != null) continue;
                index = i;
            }
        } else {
            int i = this.seq.length();
            while (--i >= 0 && index == -1) {
                if (!element.equals(this.seq.get(i))) continue;
                index = i;
            }
        }
        return index;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public Object[] toArray() {
        Object[] array2 = new Object[this.size()];
        int i = this.size();
        while (--i >= 0) {
            array2[i] = this.seq.get(i);
        }
        return array2;
    }

    @Override
    public <E> E[] toArray(E[] array2) {
        if (array2.length < this.size()) {
            Object[] copy = (Object[])Array.newInstance(array2.getClass().getComponentType(), this.size());
            int i = this.size();
            while (--i >= 0) {
                copy[i] = this.seq.get(i);
            }
            return copy;
        }
        int i = this.size();
        while (--i >= 0) {
            array2[i] = this.seq.get(i);
        }
        return array2;
    }
}

