/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.eap;

import com.axlradius.misc.StackTrace;
import java.util.EnumSet;

public enum PublicState {
    NONE,
    IDENTITY,
    CONTINUE,
    COMPLETE,
    FAIL,
    ERROR,
    CLIENT_FAIL;

    private String errorMessage;
    private String d;
    private Exception exception;

    public static final String getName(PublicState publicState) {
        return publicState.name() + "(" + publicState.ordinal() + ")";
    }

    public final void setMessage(String string) {
        this.errorMessage = string == null ? "No message set." : string;
        if (this.isError()) {
            new StackTrace();
            this.d = StackTrace.getStackTrace();
        }
    }

    public final void setMessage(String object, Exception exception) {
        this.errorMessage = object == null ? "No message set." : object;
        object = this;
        if (((PublicState)((Object)object)).isError()) {
            ((PublicState)((Object)object)).exception = exception;
        }
    }

    private boolean isError() {
        return this.name().equals("ERROR");
    }

    public final String getStacktrace() {
        if (this.exception != null) {
            new StackTrace();
            return StackTrace.getStackTrace(this.exception);
        }
        return this.d;
    }

    public final String getMessage() {
        return this.errorMessage;
    }

    public final void clean() {
        for (PublicState publicState : EnumSet.allOf(PublicState.class)) {
            ((PublicState)((Object)var1_1.next())).errorMessage = null;
            publicState.d = null;
            publicState.exception = null;
        }
    }

    public final void clearMessage() {
        this.errorMessage = null;
    }

    public final boolean hasMessage() {
        return this.errorMessage != null;
    }

    public final String toString() {
        String string = this.name();
        if (this.hasMessage()) {
            string = string + " Message " + this.getMessage();
        }
        return string;
    }
}

