/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.contentfiltering;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.OOoO.return;
import com.ubnt.model.api.contentfiltering.ImmutableContentFilteringDto;
import com.ubnt.model.schedule.ScheduleDto;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.contentfiltering.ContentFilteringDocument;
import com.ubnt.service.contentfiltering.new;
import com.ubnt.service.contentfiltering.ooOO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Schema(name="Content Filtering")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableContentFilteringDto.class)
@Value.Immutable
@return
public interface ContentFilteringDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @NotEmpty
    @JsonProperty(value="categories")
    public List<new> categories();

    @NotEmpty
    @JsonProperty(value="name")
    public String name();

    @JsonProperty(value="network_ids")
    public List<String> networkIds();

    @MacAddress
    @JsonProperty(value="client_macs")
    public List<String> macAddresses();

    @JsonProperty(value="allow_list")
    public List<String> allowList();

    @JsonProperty(value="block_list")
    public List<String> blockList();

    @JsonProperty(value="schedule")
    @NotNull
    public ScheduleDto schedule();

    @JsonProperty(value="safe_search")
    @NotNull
    public List<ooOO> safeSearch();

    @JsonProperty(value="enabled")
    public boolean enabled();

    public static ImmutableContentFilteringDto.Builder builder() {
        return ImmutableContentFilteringDto.builder();
    }

    public static ContentFilteringDto ofDocument(ContentFilteringDocument contentFilteringDocument) {
        return ContentFilteringDto.builder().id(contentFilteringDocument.getId()).name(contentFilteringDocument.getName()).categories(contentFilteringDocument.getCategories()).networkIds(contentFilteringDocument.getNetworkIds()).macAddresses(contentFilteringDocument.getMacAddresses()).allowList(contentFilteringDocument.getAllowList()).blockList(contentFilteringDocument.getBlockList()).schedule(ScheduleDto.fromDocument(contentFilteringDocument.getSchedule())).safeSearch(contentFilteringDocument.getSafeSearch()).enabled(contentFilteringDocument.isEnabled()).build();
    }

    default public ContentFilteringDocument toDocument(String string) {
        return this.documentBuilder(string).Object(this.id()).\u00f500000();
    }

    default public ContentFilteringDocument toDocument(String string, String string2) {
        return this.documentBuilder(string).Object(string2).\u00f500000();
    }

    default public ContentFilteringDocument._Oo documentBuilder(String string) {
        return ContentFilteringDocument.builder().OO0000(string).\u00d500000(this.categories()).\u00d200000(this.name()).\u00d400000(this.networkIds()).\u00d600000(this.macAddresses()).void(this.allowList()).float(this.blockList()).\u00f400000(ScheduleDto.toDocument(this.schedule())).\u00f600000(this.safeSearch()).o00000(this.enabled());
    }
}

