/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.ubnt.model.api.dashboard.WifiActivityDataDto;
import com.ubnt.model.api.dashboard.WifiActivityStatDto;
import com.ubnt.model.api.dashboard.widgets.DashboardWidget;
import com.ubnt.model.api.dashboard.widgets.DashboardWidgetDto;
import com.ubnt.model.api.dashboard.widgets.NoStatsReason;
import com.ubnt.model.for.super.C;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class WifiActivityWidgetDto
extends WifiActivityDataDto
implements DashboardWidgetDto {
    @Nullable
    private final Map<C, WifiActivityDataDto> byRadioBand;
    @Nullable
    private final NoStatsReason noStatsReason;

    @Override
    public DashboardWidget type() {
        return DashboardWidget.WIFI_ACTIVITY;
    }

    public static WifiActivityWidgetDto of(List<WifiActivityStatDto> list) {
        return WifiActivityWidgetDto.of(list, null);
    }

    public static WifiActivityWidgetDto of(List<WifiActivityStatDto> list, @Nullable Map<C, List<WifiActivityStatDto>> map) {
        WifiActivityWidgetDtoBuilder<?, ?> wifiActivityWidgetDtoBuilder = WifiActivityWidgetDto.builder();
        WifiActivityWidgetDto.build(wifiActivityWidgetDtoBuilder, list);
        if (map != null) {
            wifiActivityWidgetDtoBuilder.byRadioBand(map.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
                WifiActivityDataDto.WifiActivityDataDtoBuilder<?, ?> wifiActivityDataDtoBuilder = WifiActivityDataDto.builder();
                WifiActivityWidgetDto.build(wifiActivityDataDtoBuilder, (List)entry.getValue());
                return wifiActivityDataDtoBuilder.build();
            })));
        }
        return wifiActivityWidgetDtoBuilder.build();
    }

    private static void build(WifiActivityDataDto.WifiActivityDataDtoBuilder<?, ?> wifiActivityDataDtoBuilder, List<WifiActivityStatDto> list) {
        long l2 = list.stream().mapToLong(WifiActivityStatDto::rxBytes).sum();
        long l3 = list.stream().mapToLong(WifiActivityStatDto::txBytes).sum();
        ((WifiActivityDataDto.WifiActivityDataDtoBuilder)((WifiActivityDataDto.WifiActivityDataDtoBuilder)((WifiActivityDataDto.WifiActivityDataDtoBuilder)wifiActivityDataDtoBuilder.rxBytes(l2)).txBytes(l3)).history(list)).build();
    }

    public static WifiActivityWidgetDto withoutStats(NoStatsReason noStatsReason) {
        return ((WifiActivityWidgetDtoBuilder)((WifiActivityWidgetDtoBuilder)WifiActivityWidgetDto.builder().history(List.of())).noStatsReason(noStatsReason)).build();
    }

    @Generated
    protected WifiActivityWidgetDto(WifiActivityWidgetDtoBuilder<?, ?> wifiActivityWidgetDtoBuilder) {
        super(wifiActivityWidgetDtoBuilder);
        this.byRadioBand = wifiActivityWidgetDtoBuilder.byRadioBand;
        this.noStatsReason = wifiActivityWidgetDtoBuilder.noStatsReason;
    }

    @Generated
    public static WifiActivityWidgetDtoBuilder<?, ?> builder() {
        return new _o();
    }

    @Nullable
    @Generated
    public Map<C, WifiActivityDataDto> getByRadioBand() {
        return this.byRadioBand;
    }

    @Nullable
    @Generated
    public NoStatsReason getNoStatsReason() {
        return this.noStatsReason;
    }

    @Override
    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WifiActivityWidgetDto)) {
            return false;
        }
        WifiActivityWidgetDto wifiActivityWidgetDto = (WifiActivityWidgetDto)object;
        if (!wifiActivityWidgetDto.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Map<C, WifiActivityDataDto> map = this.getByRadioBand();
        Map<C, WifiActivityDataDto> map2 = wifiActivityWidgetDto.getByRadioBand();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        NoStatsReason noStatsReason = this.getNoStatsReason();
        NoStatsReason noStatsReason2 = wifiActivityWidgetDto.getNoStatsReason();
        return !(noStatsReason == null ? noStatsReason2 != null : !((Object)((Object)noStatsReason)).equals((Object)noStatsReason2));
    }

    @Override
    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof WifiActivityWidgetDto;
    }

    @Override
    @Generated
    public int hashCode() {
        int n2 = super.hashCode();
        Map<C, WifiActivityDataDto> map = this.getByRadioBand();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        NoStatsReason noStatsReason = this.getNoStatsReason();
        n2 = n2 * 59 + (noStatsReason == null ? 43 : ((Object)((Object)noStatsReason)).hashCode());
        return n2;
    }

    @Generated
    public static abstract class WifiActivityWidgetDtoBuilder<C extends WifiActivityWidgetDto, B extends WifiActivityWidgetDtoBuilder<C, B>>
    extends WifiActivityDataDto.WifiActivityDataDtoBuilder<C, B> {
        @Generated
        private Map<C, WifiActivityDataDto> byRadioBand;
        @Generated
        private NoStatsReason noStatsReason;

        @Generated
        public B byRadioBand(@Nullable Map<C, WifiActivityDataDto> map) {
            this.byRadioBand = map;
            return this.\u00d300000();
        }

        @Generated
        public B noStatsReason(@Nullable NoStatsReason noStatsReason) {
            this.noStatsReason = noStatsReason;
            return this.\u00d300000();
        }

        @Generated
        protected abstract B \u00d300000();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "WifiActivityWidgetDto.WifiActivityWidgetDtoBuilder(super=" + super.toString() + ", byRadioBand=" + String.valueOf(this.byRadioBand) + ", noStatsReason=" + String.valueOf((Object)this.noStatsReason) + ")";
        }
    }

    @Generated
    private static final class _o
    extends WifiActivityWidgetDtoBuilder<WifiActivityWidgetDto, _o> {
        @Generated
        private _o() {
        }

        @Generated
        protected _o String() {
            return this;
        }

        @Override
        @Generated
        public WifiActivityWidgetDto build() {
            return new WifiActivityWidgetDto(this);
        }
    }
}

