/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.setting.elementadopt;

import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.setting.elementadopt.AutolinkCredentialsDto;
import com.ubnt.model.api.setting.elementadopt.ElementAdoptSettingDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.exception.ResourceNotFoundException;
import com.ubnt.service.setting.void.oOOO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@V2RestController
@Tag(name="New Device Auto-Link (aka Element Adopt) Setting")
public class ElementAdoptSettingController {
    private final oOOO o00000;

    public ElementAdoptSettingController(oOOO oOOO2) {
        this.o00000 = oOOO2;
    }

    @Operation(summary="Get default Device Auto-Link settings", description="Since 7.1.35")
    @GetMapping(value={"/api/site/{siteName}/settings/element_adopt/defaults"})
    public ElementAdoptSettingDto getDefaults(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d200000();
    }

    @GetMapping(value={"/api/site/{siteName}/settings/element_adopt/credentials"})
    @Operation(summary="Get autolink credentials of a site.", description="Since 10.0.158")
    public AutolinkCredentialsDto getAutolinkCredentials(@PathVariable(value="siteName") Site site) {
        Optional<Setting> optional = this.o00000.super(site.getId());
        if (optional.isEmpty()) {
            throw new ResourceNotFoundException("Element Adopt setting not found for site: " + site.getName());
        }
        Setting setting = optional.get();
        return new AutolinkCredentialsDto(setting.getString("x_element_essid", ""), setting.getString("x_element_psk", ""), setting.isEnabled());
    }
}

